/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;

public class CalledHaplotypes {
    private final List<VariantContext> calls;
    private final Set<Haplotype> calledHaplotypes;

    public CalledHaplotypes(List<VariantContext> calls, Set<Haplotype> calledHaplotypes) {
        this.calls = Utils.nonNull(calls, "calls cannot be null");
        this.calledHaplotypes = Utils.nonNull(calledHaplotypes, "calledHaplotypes cannot be null");
        Utils.validateArg(calls.isEmpty() == calledHaplotypes.isEmpty(), "Calls and calledHaplotypes should both be empty or both not but got calls=" + calls + " calledHaplotypes=" + calledHaplotypes);
    }

    public List<VariantContext> getCalls() {
        return this.calls;
    }

    public Set<Haplotype> getCalledHaplotypes() {
        return this.calledHaplotypes;
    }
}

