/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.pairhmm.DragstrReadSTRAnalyzer;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputation;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputator;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class DragstrPairHMMInputScoreImputator
implements PairHMMInputScoreImputator {
    private static final int GOP_AT_THE_END_OF_READ = 45;
    private static final int GCP_AT_THE_END_OF_READ = 10;
    private static final double MAX_GOP_IN_READ = 40.0;
    private final DragstrParams params;

    public static DragstrPairHMMInputScoreImputator of(DragstrParams params) {
        return new DragstrPairHMMInputScoreImputator(params);
    }

    private DragstrPairHMMInputScoreImputator(DragstrParams params) {
        this.params = params;
    }

    @Override
    public PairHMMInputScoreImputation impute(GATKRead read) {
        byte[] bases = read.getBases();
        int length = bases.length;
        final byte[] gop = new byte[length];
        final byte[] gcp = new byte[length];
        DragstrReadSTRAnalyzer analyzer = DragstrReadSTRAnalyzer.of(read, this.params.maximumPeriod());
        for (int i = 0; i < length - 1; ++i) {
            int period = analyzer.mostRepeatedPeriod(i);
            int repeats = analyzer.numberOfMostRepeats(i);
            gop[i] = (byte)Math.round(Math.min(40.0, this.params.gop(period, repeats)));
            gcp[i] = (byte)Math.round(this.params.gcp(period, repeats));
        }
        gop[length - 1] = 45;
        gcp[length - 1] = 10;
        return new PairHMMInputScoreImputation(){

            @Override
            public byte[] delOpenPenalties() {
                return gop;
            }

            @Override
            public byte[] insOpenPenalties() {
                return gop;
            }

            @Override
            public byte[] gapContinuationPenalties() {
                return gcp;
            }
        };
    }
}

