/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collection;
import org.aeonbits.owner.util.Collections;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;

final class DragstrVariantContextAnnotations {
    public static final String DRAGSTRINFO_KEY = "DRAGstrInfo";
    public static final String DRAGSTRPARAMS_KEY = "DRAGstrParams";

    DragstrVariantContextAnnotations() {
    }

    static Collection<? extends VCFHeaderLine> vcfHeaderLines() {
        return Collections.list((Object[])new VCFInfoHeaderLine[]{new VCFInfoHeaderLine(DRAGSTRINFO_KEY, 2, VCFHeaderLineType.Integer, "Indicates the period and repeat count"), new VCFInfoHeaderLine(DRAGSTRPARAMS_KEY, 3, VCFHeaderLineType.Float, "Parameters used (GOP, GCP, API)")});
    }

    static VariantContext annotateVariantContextWithDragstrParametersUsed(VariantContext vc, DragstrParams dragstrParams, int period, int repeats) {
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        double gop = dragstrParams.gop(period, repeats);
        double gcp = dragstrParams.gcp(period, repeats);
        double api = dragstrParams.api(period, repeats);
        builder.attribute(DRAGSTRINFO_KEY, (Object)new int[]{period, repeats});
        builder.attribute(DRAGSTRPARAMS_KEY, (Object)new String[]{String.format("%.1f", gop), String.format("%.1f", gcp), String.format("%.1f", api)});
        return builder.make();
    }
}

