/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.GATKPlugin.GATKReadFilterPluginDescriptor;
import org.broadinstitute.hellbender.cmdline.argumentcollections.ReferenceInputArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.AssemblyRegionWalker;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.MappingQualityReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.transformers.DRAGENMappingQualityReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.fasta.CachingIndexedFastaSequenceFile;

@CommandLineProgramProperties(summary="Call germline SNPs and indels via local re-assembly of haplotypes", oneLineSummary="Call germline SNPs and indels via local re-assembly of haplotypes", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
public final class HaplotypeCaller
extends AssemblyRegionWalker {
    @ArgumentCollection
    private HaplotypeCallerArgumentCollection hcArgs = new HaplotypeCallerArgumentCollection();
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written")
    public GATKPath outputVCF = null;
    private VariantContextWriter vcfWriter;
    private HaplotypeCallerEngine hcEngine;

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return HaplotypeCallerEngine.makeStandardHCReadFilters();
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.hcArgs.dragenMode.booleanValue()) {
            GATKReadFilterPluginDescriptor readFilterPlugin = (GATKReadFilterPluginDescriptor)((Object)this.getCommandLineParser().getPluginDescriptor(GATKReadFilterPluginDescriptor.class));
            Optional<ReadFilter> filterOptional = readFilterPlugin.getResolvedInstances().stream().filter(rf -> rf instanceof MappingQualityReadFilter).findFirst();
            filterOptional.ifPresent(readFilter -> {
                ((MappingQualityReadFilter)readFilter).minMappingQualityScore = 1;
            });
        }
        return null;
    }

    @Override
    public ReadTransformer makePreReadFilterTransformer() {
        return HaplotypeCallerEngine.makeStandardHCReadTransformer();
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return HaplotypeCallerEngine.getStandardHaplotypeCallerAnnotationGroups();
    }

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public ReadTransformer makePostReadFilterTransformer() {
        return super.makePostReadFilterTransformer().andThen(this.hcArgs.transformDRAGENMapQ ? new DRAGENMappingQualityReadTransformer() : ReadTransformer.identity());
    }

    @Override
    public Collection<Annotation> makeVariantAnnotations() {
        boolean confidenceMode = this.hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE;
        Collection<Annotation> annotations = super.makeVariantAnnotations();
        return confidenceMode ? HaplotypeCallerEngine.filterReferenceConfidenceAnnotations(annotations) : annotations;
    }

    @Override
    public AssemblyRegionEvaluator assemblyRegionEvaluator() {
        return this.hcEngine;
    }

    @Override
    public void onTraversalStart() {
        if (this.hcArgs.emitReferenceConfidence == ReferenceConfidenceMode.GVCF && this.hcArgs.maxMnpDistance > 0) {
            this.logger.warn("*************************************************************************");
            this.logger.warn("* MNP support enabled in GVCF mode.                                     *");
            this.logger.warn("* Generated GVCFs that contain MNPs can only be genotyped individually. *");
            this.logger.warn("* Multi-sample calling from MNP-enabled GVCFs is unsupported.           *");
            this.logger.warn("*************************************************************************");
        }
        if (this.hcArgs.dragenMode.booleanValue()) {
            this.logger.warn("*************************************************************************");
            this.logger.warn("* DRAGEN-GATK mode enabled                                              *");
            this.logger.warn("* The following arguments have had their inputs overwritten:            *");
            this.logger.warn("* --apply-frd                                                           *");
            this.logger.warn("* --apply-bqd                                                           *");
            this.logger.warn("* --transform-dragen-mapping-quality                                    *");
            this.logger.warn("* --soft-clip-low-quality-ends                                          *");
            this.logger.warn("* --mapping-quality-threshold-for-genotyping  1                         *");
            this.logger.warn("* --minimum-mapping-quality  1                                          *");
            this.logger.warn("* --allele-informative-reads-overlap-margin  1                          *");
            this.logger.warn("* --disable-cap-base-qualities-to-map-quality                           *");
            this.logger.warn("* --enable-dynamic-read-disqualification-for-genotyping                 *");
            this.logger.warn("* --expected-mismatch-rate-for-read-disqualification  0.03              *");
            this.logger.warn("* --genotype-assignment-method USE_POSTERIOR_PROBABILITIES              *");
            this.logger.warn("* --padding-around-indels  150                                          *");
            this.logger.warn("* --standard-min-confidence-threshold-for-calling 3.0                   *");
            this.logger.warn("* --use-posteriors-to-calculate-qual                                    *");
            this.logger.warn("* --allele-informative-reads-overlap-margin  1                          *");
            this.logger.warn("*                                                                       *");
            this.logger.warn("* If you would like to run DRAGEN-GATK with different inputs for any    *");
            this.logger.warn("* of the above arguments please manually construct the command.         *");
            this.logger.warn("*************************************************************************");
            this.hcArgs.applyBQD = true;
            this.hcArgs.applyFRD = true;
            this.hcArgs.transformDRAGENMapQ = true;
            this.hcArgs.softClipLowQualityEnds = true;
            this.hcArgs.mappingQualityThreshold = 1;
            this.hcArgs.informativeReadOverlapMargin = 1;
            this.hcArgs.likelihoodArgs.disableCapReadQualitiesToMapQ = true;
            this.hcArgs.likelihoodArgs.enableDynamicReadDisqualification = true;
            this.hcArgs.likelihoodArgs.expectedErrorRatePerBase = 0.03;
            this.hcArgs.standardArgs.genotypeArgs.genotypeAssignmentMethod = GenotypeAssignmentMethod.USE_POSTERIOR_PROBABILITIES;
            this.hcArgs.standardArgs.genotypeArgs.STANDARD_CONFIDENCE_FOR_CALLING = 3.0;
            this.hcArgs.standardArgs.genotypeArgs.usePosteriorProbabilitiesToCalculateQual = true;
            this.assemblyRegionArgs.indelPaddingForGenotyping = 150;
        }
        VariantAnnotatorEngine variantAnnotatorEngine = new VariantAnnotatorEngine(this.makeVariantAnnotations(), this.hcArgs.dbsnp.dbsnp, this.hcArgs.comps, this.hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE, false);
        this.hcEngine = new HaplotypeCallerEngine(this.hcArgs, this.assemblyRegionArgs, this.createOutputBamIndex, this.createOutputBamMD5, this.getHeaderForReads(), HaplotypeCaller.getReferenceReader(this.referenceArguments), variantAnnotatorEngine);
        SAMSequenceDictionary sequenceDictionary = this.getHeaderForReads().getSequenceDictionary();
        this.vcfWriter = this.hcEngine.makeVCFWriter(this.outputVCF, sequenceDictionary, this.createOutputVariantIndex, this.createOutputVariantMD5, this.outputSitesOnlyVCFs);
        this.hcEngine.writeHeader(this.vcfWriter, sequenceDictionary, this.getDefaultToolVCFHeaderLines());
    }

    private static CachingIndexedFastaSequenceFile getReferenceReader(ReferenceInputArgumentCollection referenceArguments) {
        return new CachingIndexedFastaSequenceFile(referenceArguments.getReferenceSpecifier());
    }

    @Override
    public void apply(AssemblyRegion region, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.hcEngine.callRegion(region, featureContext, referenceContext).forEach(arg_0 -> ((VariantContextWriter)this.vcfWriter).add(arg_0));
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
        if (this.hcEngine != null) {
            this.hcEngine.shutdown();
        }
    }
}

