/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.tools.walkers.genotyper.StandardCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerReadThreadingAssemblerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadThreadingAssemblerArgumentCollection;

public class HaplotypeCallerArgumentCollection
extends AssemblyBasedCallerArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GQ_BAND_LONG_NAME = "gvcf-gq-bands";
    public static final String GQ_BAND_SHORT_NAME = "GQB";
    public static final String DO_NOT_CORRECT_OVERLAPPING_BASE_QUALITIES_LONG_NAME = "do-not-correct-overlapping-quality";
    public static final String OUTPUT_BLOCK_LOWER_BOUNDS = "floor-blocks";
    public static final String DRAGEN_GATK_MODE_LONG_NAME = "dragen-mode";
    @ArgumentCollection
    public StandardCallerArgumentCollection standardArgs = new StandardCallerArgumentCollection();
    @Argument(fullName="sample-name", shortName="ALIAS", doc="Name of single sample to use from a multi-sample bam", optional=true)
    public String sampleNameToUse = null;
    @ArgumentCollection
    public DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Advanced
    @Argument(fullName="comparison", shortName="comp", doc="Comparison VCF file(s)", optional=true)
    public List<FeatureInput<VariantContext>> comps = new ArrayList<FeatureInput<VariantContext>>();
    @Advanced
    @Argument(fullName="gvcf-gq-bands", shortName="GQB", doc="Exclusive upper bounds for reference confidence GQ bands (must be in [1, 100] and specified in increasing order)", optional=true)
    public List<Integer> GVCFGQBands = new ArrayList<Integer>(70);
    @Advanced
    @Argument(fullName="floor-blocks", doc="Output the band lower bound for each GQ block regardless of the data it represents", optional=true)
    public boolean floorBlocks;
    @Advanced
    @Argument(fullName="indel-size-to-eliminate-in-ref-model", doc="The size of an indel to check for in the reference model", optional=true)
    public int indelSizeToEliminateInRefModel;
    @Advanced
    @Argument(fullName="disable-optimizations", doc="Don't skip calculations in ActiveRegions with no variants", optional=true)
    public boolean disableOptimizations;
    @Argument(fullName="dragen-mode", optional=true, doc="Single argument for enabling the bulk of DRAGEN-GATK features. NOTE: THIS WILL OVERWRITE PROVIDED ARGUMENT CHECK TOOL INFO TO SEE WHICH ARGUMENTS ARE SET).")
    public Boolean dragenMode;
    @Advanced
    @Argument(fullName="apply-bqd", doc="If enabled this argument will apply the DRAGEN-GATK BaseQualityDropout model to the genotyping model for filtering sites due to Linked Error mode.", optional=true)
    public boolean applyBQD;
    @Advanced
    @Argument(fullName="apply-frd", doc="If enabled this argument will apply the DRAGEN-GATK ForeignReadDetection model to the genotyping model for filtering sites.", optional=true)
    public boolean applyFRD;
    @Advanced
    @Argument(fullName="disable-spanning-event-genotyping", doc="If enabled this argument will disable inclusion of the '*' spanning event when genotyping events that overlap deletions", optional=true)
    public boolean disableSpanningEventGenotyping;
    @Advanced
    @Argument(fullName="transform-dragen-mapping-quality", doc="If enabled this argument will map DRAGEN aligner aligned reads with mapping quality <=250 to scale up to MQ 50", optional=true)
    public boolean transformDRAGENMapQ;
    @Advanced
    @Argument(fullName="mapping-quality-threshold-for-genotyping", doc="Control the threshold for discounting reads from the genotyper due to mapping quality after the active region detection and assembly steps but before genotyping. NOTE: this is in contrast to the --minimum-mapping-quality argument which filters reads from all parts of the HaplotypeCaller. If you would like to call genotypes with a different threshold both arguments must be set.", optional=true)
    public int mappingQualityThreshold;
    @Advanced
    @Argument(fullName="max-effective-depth-adjustment-for-frd", doc="Set the maximum depth to modify FRD adjustment to in the event of high depth sites (0 to disable)", optional=false)
    public int maxEffectiveDepthAdjustment;
    @Hidden
    @Argument(fullName="keep-rg", doc="Only use reads from this read group when making calls (but use all reads to build the assembly)", optional=true)
    public String keepRG;
    @Hidden
    @Argument(fullName="just-determine-active-regions", doc="Just determine ActiveRegions, don't perform assembly or calling", optional=true)
    public boolean justDetermineActiveRegions;
    @Hidden
    @Advanced
    @Argument(fullName="debug-assembly-region-state", doc="Write output files for assembled regions with read summaries and called haplotypes to the specified path", optional=true)
    public GATKPath assemblyStateOutput;
    @Hidden
    @Advanced
    @Argument(fullName="debug-genotyper-output", doc="Location to write genotyper debug stream that contains detailed information about the internal state of the genotyepr", optional=true)
    public String genotyperDebugOutStream;
    @Hidden
    @Argument(fullName="dont-genotype", doc="Perform assembly but do not genotype variants", optional=true)
    public boolean dontGenotype;
    @Advanced
    @Argument(fullName="do-not-run-physical-phasing", doc="Disable physical phasing", optional=true)
    public boolean doNotRunPhysicalPhasing;
    @Advanced
    @Argument(fullName="do-not-correct-overlapping-quality", doc="Disable overlapping base quality correction")
    public boolean doNotCorrectOverlappingBaseQualities;
    @Advanced
    @Argument(fullName="use-filtered-reads-for-annotations", doc="Use the contamination-filtered read maps for the purposes of annotating variants", optional=true)
    public boolean useFilteredReadMapForAnnotations;

    public HaplotypeCallerArgumentCollection() {
        for (int i = 1; i <= 60; ++i) {
            this.GVCFGQBands.add(i);
        }
        this.GVCFGQBands.add(70);
        this.GVCFGQBands.add(80);
        this.GVCFGQBands.add(90);
        this.GVCFGQBands.add(99);
        this.floorBlocks = false;
        this.indelSizeToEliminateInRefModel = 10;
        this.disableOptimizations = false;
        this.dragenMode = false;
        this.applyBQD = false;
        this.applyFRD = false;
        this.disableSpanningEventGenotyping = false;
        this.transformDRAGENMapQ = false;
        this.mappingQualityThreshold = 20;
        this.maxEffectiveDepthAdjustment = 0;
        this.keepRG = null;
        this.justDetermineActiveRegions = false;
        this.assemblyStateOutput = null;
        this.genotyperDebugOutStream = null;
        this.dontGenotype = false;
        this.doNotRunPhysicalPhasing = false;
        this.doNotCorrectOverlappingBaseQualities = false;
        this.useFilteredReadMapForAnnotations = false;
    }

    @Override
    protected int getDefaultMaxMnpDistance() {
        return 0;
    }

    @Override
    protected ReadThreadingAssemblerArgumentCollection getReadThreadingAssemblerArgumentCollection() {
        return new HaplotypeCallerReadThreadingAssemblerArgumentCollection();
    }
}

