/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.MappingQualityReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.ChromosomeCounts;
import org.broadinstitute.hellbender.tools.walkers.annotator.FisherStrand;
import org.broadinstitute.hellbender.tools.walkers.annotator.QualByDepth;
import org.broadinstitute.hellbender.tools.walkers.annotator.RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardHCAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasBySample;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandOddsRatio;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.tools.walkers.genotyper.MinimalGenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.OutputMode;
import org.broadinstitute.hellbender.tools.walkers.genotyper.StandardCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyRegionTrimmer;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyResultSet;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.CalledHaplotypes;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.DragstrVariantContextAnnotations;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingDebugger;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadLikelihoodCalculationEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.RefVsAnyResult;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceModel;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;
import org.broadinstitute.hellbender.transformers.IUPACReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;
import org.broadinstitute.hellbender.utils.downsampling.AlleleBiasedDownsamplingUtils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParamUtils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.haplotype.HaplotypeBAMWriter;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.writers.GVCFWriter;

public final class HaplotypeCallerEngine
implements AssemblyRegionEvaluator {
    private static final Logger logger = LogManager.getLogger(HaplotypeCallerEngine.class);
    private final HaplotypeCallerArgumentCollection hcArgs;
    private final SAMFileHeader readsHeader;
    private ReferenceConfidenceModel referenceConfidenceModel = null;
    private AssemblyRegionTrimmer trimmer;
    private final OutputStreamWriter assemblyDebugOutStream;
    private MinimalGenotypingEngine activeRegionEvaluationGenotyperEngine = null;
    private ReadThreadingAssembler assemblyEngine = null;
    private ReadLikelihoodCalculationEngine likelihoodCalculationEngine = null;
    private HaplotypeCallerGenotypingEngine genotypingEngine = null;
    private VariantAnnotatorEngine annotationEngine = null;
    private final ReferenceSequenceFile referenceReader;
    private Optional<HaplotypeBAMWriter> haplotypeBAMWriter;
    private Set<String> sampleSet;
    private SampleList samplesList;
    private final boolean forceCallingAllelesPresent;
    private byte minTailQuality;
    private SmithWatermanAligner aligner;
    private final DragstrParams dragstrParams;
    public static final byte MIN_TAIL_QUALITY_WITH_ERROR_CORRECTION = 6;
    private static final double AVERAGE_HQ_SOFTCLIPS_HQ_BASES_THRESHOLD = 6.0;
    private static final double MAXMIN_CONFIDENCE_FOR_CONSIDERING_A_SITE_AS_POSSIBLE_VARIANT_IN_ACTIVE_REGION_DISCOVERY = 4.0;
    private static final int MINIMUM_PUTATIVE_PLOIDY_FOR_ACTIVE_REGION_DISCOVERY = 2;
    private static final int READ_LENGTH_FILTER_THRESHOLD = 10;
    public static final int DEFAULT_READ_QUALITY_FILTER_THRESHOLD = 20;
    private static final List<VariantContext> NO_CALLS = Collections.emptyList();
    private static final Allele FAKE_REF_ALLELE = Allele.create((String)"N", (boolean)true);
    private static final Allele FAKE_ALT_ALLELE = Allele.create((String)"<FAKE_ALT>", (boolean)false);

    public HaplotypeCallerEngine(HaplotypeCallerArgumentCollection hcArgs, AssemblyRegionArgumentCollection assemblyRegionArgs, boolean createBamOutIndex, boolean createBamOutMD5, SAMFileHeader readsHeader, ReferenceSequenceFile referenceReader, VariantAnnotatorEngine annotationEngine) {
        this.dragstrParams = DragstrParamUtils.parse(hcArgs.likelihoodArgs.dragstrParams);
        this.hcArgs = Utils.nonNull(hcArgs);
        this.readsHeader = Utils.nonNull(readsHeader);
        this.referenceReader = Utils.nonNull(referenceReader);
        this.annotationEngine = Utils.nonNull(annotationEngine);
        this.aligner = SmithWatermanAligner.getAligner(hcArgs.smithWatermanImplementation);
        boolean bl = this.forceCallingAllelesPresent = hcArgs.alleles != null;
        if (hcArgs.assemblyStateOutput != null) {
            try {
                this.assemblyDebugOutStream = new OutputStreamWriter(hcArgs.assemblyStateOutput.getOutputStream());
            }
            catch (Exception e) {
                throw new UserException.CouldNotCreateOutputFile(hcArgs.assemblyStateOutput, "Provided argument for assembly debug graph location could not be created", e);
            }
        } else {
            this.assemblyDebugOutStream = null;
        }
        if (hcArgs.genotyperDebugOutStream != null) {
            HaplotypeCallerGenotypingDebugger.initialize(hcArgs.genotyperDebugOutStream);
        }
        this.trimmer = new AssemblyRegionTrimmer(assemblyRegionArgs, readsHeader.getSequenceDictionary());
        this.initialize(createBamOutIndex, createBamOutMD5);
    }

    public static Collection<Annotation> filterReferenceConfidenceAnnotations(Collection<Annotation> annotations) {
        logger.info("Tool is in reference confidence mode and the annotation, the following changes will be made to any specified annotations: 'StrandBiasBySample' will be enabled. 'ChromosomeCounts', 'FisherStrand', 'StrandOddsRatio' and 'QualByDepth' annotations have been disabled");
        if (!annotations.contains(new StrandBiasBySample())) {
            annotations.add(new StrandBiasBySample());
        }
        return annotations.stream().filter(c -> c.getClass() != ChromosomeCounts.class && c.getClass() != FisherStrand.class && c.getClass() != StrandOddsRatio.class && c.getClass() != QualByDepth.class).collect(Collectors.toList());
    }

    public static List<Class<? extends Annotation>> getStandardHaplotypeCallerAnnotationGroups() {
        return Arrays.asList(StandardAnnotation.class, StandardHCAnnotation.class);
    }

    private void initialize(boolean createBamOutIndex, boolean createBamOutMD5) {
        this.initializeSamples();
        this.validateAndInitializeArgs();
        this.minTailQuality = (byte)(this.hcArgs.minBaseQualityScore - 1);
        this.initializeActiveRegionEvaluationGenotyperEngine();
        this.genotypingEngine = new HaplotypeCallerGenotypingEngine(this.hcArgs, this.samplesList, !this.hcArgs.doNotRunPhysicalPhasing, this.hcArgs.applyBQD);
        this.genotypingEngine.setAnnotationEngine(this.annotationEngine);
        this.referenceConfidenceModel = new ReferenceConfidenceModel(this.samplesList, this.readsHeader, this.hcArgs.indelSizeToEliminateInRefModel, this.hcArgs.standardArgs.genotypeArgs.numRefIfMissing);
        if (this.isAlleleSpecificMode(this.annotationEngine) && this.isVCFMode()) {
            throw new UserException("Allele-specific annotations are not yet supported in the VCF mode");
        }
        this.haplotypeBAMWriter = AssemblyBasedCallerUtils.createBamWriter(this.hcArgs, createBamOutIndex, createBamOutMD5, this.readsHeader);
        this.assemblyEngine = this.hcArgs.createReadThreadingAssembler();
        this.likelihoodCalculationEngine = AssemblyBasedCallerUtils.createLikelihoodCalculationEngine(this.hcArgs.likelihoodArgs, !this.hcArgs.softClipLowQualityEnds);
    }

    private boolean isVCFMode() {
        return this.hcArgs.emitReferenceConfidence == ReferenceConfidenceMode.NONE;
    }

    private boolean isAlleleSpecificMode(VariantAnnotatorEngine annotationEngine) {
        return annotationEngine.getInfoAnnotations().stream().anyMatch(infoFieldAnnotation -> infoFieldAnnotation.getClass().getSimpleName().startsWith("AS_")) || annotationEngine.getGenotypeAnnotations().stream().anyMatch(genotypeAnnotation -> genotypeAnnotation.getClass().getSimpleName().startsWith("AS_"));
    }

    private void validateAndInitializeArgs() {
        if (this.hcArgs.standardArgs.genotypeArgs.samplePloidy != 2 && !this.hcArgs.doNotRunPhysicalPhasing) {
            this.hcArgs.doNotRunPhysicalPhasing = true;
            logger.info("Currently, physical phasing is only available for diploid samples.");
        }
        if (this.hcArgs.dontGenotype && this.emitReferenceConfidence()) {
            throw new UserException("You cannot request gVCF output and 'do not genotype' at the same time");
        }
        if (this.emitReferenceConfidence()) {
            this.hcArgs.standardArgs.genotypeArgs.STANDARD_CONFIDENCE_FOR_CALLING = -0.0;
            logger.info("Standard Emitting and Calling confidence set to 0.0 for reference-model confidence output");
            if (!this.hcArgs.standardArgs.annotateAllSitesWithPLs) {
                logger.info("All sites annotated with PLs forced to true for reference-model confidence output");
            }
            this.hcArgs.standardArgs.annotateAllSitesWithPLs = true;
        } else if (!this.hcArgs.doNotRunPhysicalPhasing) {
            this.hcArgs.doNotRunPhysicalPhasing = true;
            logger.info("Disabling physical phasing, which is supported only for reference-model confidence output");
        }
        if (this.hcArgs.standardArgs.CONTAMINATION_FRACTION_FILE != null) {
            this.hcArgs.standardArgs.setSampleContamination((Map<String, Double>)AlleleBiasedDownsamplingUtils.loadContaminationFile(this.hcArgs.standardArgs.CONTAMINATION_FRACTION_FILE, this.hcArgs.standardArgs.CONTAMINATION_FRACTION, this.sampleSet, logger));
        }
        Utils.validateArg(this.hcArgs.likelihoodArgs.BASE_QUALITY_SCORE_THRESHOLD >= 6, "BASE_QUALITY_SCORE_THRESHOLD must be greater than or equal to 6 (QualityUtils.MIN_USABLE_Q_SCORE)");
        if (this.emitReferenceConfidence() && this.samplesList.numberOfSamples() != 1) {
            throw new CommandLineException.BadArgumentValue("emit-ref-confidence", "Can only be used in single sample mode currently. Use the --sample-name argument to run on a single sample out of a multi-sample BAM file.");
        }
        if (this.hcArgs.floorBlocks && !this.emitReferenceConfidence()) {
            throw new UserException("floor-blocks refers to GVCF blocks, so reference confidence mode (emit-ref-confidence) must be specified.");
        }
    }

    private void initializeSamples() {
        this.sampleSet = ReadUtils.getSamplesFromHeader(this.readsHeader);
        this.samplesList = new IndexedSampleList(this.sampleSet);
        if (this.hcArgs.sampleNameToUse != null) {
            if (!this.sampleSet.contains(this.hcArgs.sampleNameToUse)) {
                throw new CommandLineException.BadArgumentValue("--sample_name", "Specified name does not exist in input bam files");
            }
            if (this.sampleSet.size() == 1) {
                this.hcArgs.sampleNameToUse = null;
            } else {
                this.samplesList = new IndexedSampleList(this.hcArgs.sampleNameToUse);
                this.sampleSet.clear();
                this.sampleSet.add(this.hcArgs.sampleNameToUse);
            }
        }
    }

    private void initializeActiveRegionEvaluationGenotyperEngine() {
        StandardCallerArgumentCollection activeRegionArgs = new StandardCallerArgumentCollection();
        activeRegionArgs.copyStandardCallerArgsFrom(this.hcArgs.standardArgs);
        activeRegionArgs.outputMode = OutputMode.EMIT_VARIANTS_ONLY;
        activeRegionArgs.genotypeArgs.STANDARD_CONFIDENCE_FOR_CALLING = Math.min(4.0, this.hcArgs.standardArgs.genotypeArgs.STANDARD_CONFIDENCE_FOR_CALLING);
        activeRegionArgs.CONTAMINATION_FRACTION = 0.0;
        activeRegionArgs.CONTAMINATION_FRACTION_FILE = null;
        activeRegionArgs.genotypeArgs.samplePloidy = Math.max(2, this.hcArgs.standardArgs.genotypeArgs.samplePloidy);
        this.activeRegionEvaluationGenotyperEngine = new MinimalGenotypingEngine(activeRegionArgs, this.samplesList);
        this.activeRegionEvaluationGenotyperEngine.setLogger(logger);
    }

    public static List<ReadFilter> makeStandardHCReadFilters() {
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>();
        filters.add(new MappingQualityReadFilter(20));
        filters.add(ReadFilterLibrary.MAPPING_QUALITY_AVAILABLE);
        filters.add(ReadFilterLibrary.MAPPED);
        filters.add(ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT);
        filters.add(ReadFilterLibrary.NOT_DUPLICATE);
        filters.add(ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK);
        filters.add(ReadFilterLibrary.NON_ZERO_REFERENCE_LENGTH_ALIGNMENT);
        filters.add(ReadFilterLibrary.GOOD_CIGAR);
        filters.add(new WellformedReadFilter());
        return filters;
    }

    public static ReadTransformer makeStandardHCReadTransformer() {
        return new IUPACReadTransformer(true);
    }

    public VariantContextWriter makeVCFWriter(GATKPath outputVCF, SAMSequenceDictionary readsDictionary, boolean createOutputVariantIndex, boolean createOutputVariantMD5, boolean sitesOnlyMode) {
        Utils.nonNull(outputVCF);
        Utils.nonNull(readsDictionary);
        ArrayList<Options> options = new ArrayList<Options>(2);
        if (createOutputVariantIndex) {
            options.add(Options.INDEX_ON_THE_FLY);
        }
        if (sitesOnlyMode) {
            options.add(Options.DO_NOT_WRITE_GENOTYPES);
        }
        VariantContextWriter writer = GATKVariantContextUtils.createVCFWriter(outputVCF.toPath(), readsDictionary, createOutputVariantMD5, options.toArray(new Options[options.size()]));
        if (this.hcArgs.emitReferenceConfidence == ReferenceConfidenceMode.GVCF) {
            try {
                writer = new GVCFWriter(writer, new ArrayList<Number>(this.hcArgs.GVCFGQBands), this.hcArgs.standardArgs.genotypeArgs.samplePloidy, this.hcArgs.floorBlocks);
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException.BadArgumentValue("GQBands", "are malformed: " + e.getMessage());
            }
        }
        return writer;
    }

    public VCFHeader makeVCFHeader(SAMSequenceDictionary sequenceDictionary, Set<VCFHeaderLine> defaultToolHeaderLines) {
        HashSet<Object> headerInfo = new HashSet<Object>();
        headerInfo.addAll(defaultToolHeaderLines);
        headerInfo.addAll(this.genotypingEngine.getAppropriateVCFInfoHeaders());
        headerInfo.addAll(this.annotationEngine.getVCFAnnotationDescriptions(this.emitReferenceConfidence()));
        headerInfo.add(GATKVCFHeaderLines.getInfoLine("MLEAC"));
        headerInfo.add(GATKVCFHeaderLines.getInfoLine("MLEAF"));
        VCFStandardHeaderLines.addStandardFormatLines(headerInfo, (boolean)true, (String[])new String[]{"GT", "GQ", "DP", "PL"});
        if (this.hcArgs.standardArgs.genotypeArgs.supportVariants != null) {
            headerInfo.add(VCFStandardHeaderLines.getInfoLine((String)"AC"));
            headerInfo.add(VCFStandardHeaderLines.getInfoLine((String)"AF"));
            headerInfo.add(VCFStandardHeaderLines.getInfoLine((String)"AN"));
            headerInfo.add(GATKVCFHeaderLines.getFormatLine("PP"));
            headerInfo.add(GATKVCFHeaderLines.getInfoLine("PG"));
        }
        if (!this.hcArgs.doNotRunPhysicalPhasing) {
            headerInfo.add(GATKVCFHeaderLines.getFormatLine("PID"));
            headerInfo.add(GATKVCFHeaderLines.getFormatLine("PGT"));
            headerInfo.add(VCFStandardHeaderLines.getFormatLine((String)"PS"));
        }
        headerInfo.add(GATKVCFHeaderLines.getFilterLine("LowQual"));
        if (this.emitReferenceConfidence()) {
            headerInfo.addAll(this.referenceConfidenceModel.getVCFHeaderLines());
        }
        if (this.hcArgs.likelihoodArgs.dragstrParams != null) {
            headerInfo.addAll(DragstrVariantContextAnnotations.vcfHeaderLines());
        }
        if (this.hcArgs.standardArgs.genotypeArgs.genotypeAssignmentMethod == GenotypeAssignmentMethod.USE_POSTERIOR_PROBABILITIES) {
            headerInfo.add(new VCFFormatHeaderLine("GP", VCFHeaderLineCount.G, VCFHeaderLineType.Float, "genotype posterior in Phred Scale"));
            headerInfo.add(new VCFFormatHeaderLine("PG", VCFHeaderLineCount.G, VCFHeaderLineType.Float, "genotype priors in Phred Scale"));
        }
        VCFHeader vcfHeader = new VCFHeader(headerInfo, this.sampleSet);
        vcfHeader.setSequenceDictionary(sequenceDictionary);
        return vcfHeader;
    }

    public void writeHeader(VariantContextWriter vcfWriter, SAMSequenceDictionary sequenceDictionary, Set<VCFHeaderLine> defaultToolHeaderLines) {
        Utils.nonNull(vcfWriter);
        vcfWriter.writeHeader(this.makeVCFHeader(sequenceDictionary, defaultToolHeaderLines));
    }

    @Override
    public ActivityProfileState isActive(AlignmentContext context, ReferenceContext ref, FeatureContext features) {
        VariantContext vcOut;
        if (this.forceCallingAllelesPresent && features.getValues(this.hcArgs.alleles, ref).stream().anyMatch(vc -> this.hcArgs.forceCallFiltered || vc.isNotFiltered())) {
            return new ActivityProfileState(ref.getInterval(), 1.0);
        }
        if (context == null || context.getBasePileup().isEmpty()) {
            return new ActivityProfileState(ref.getInterval(), 0.0);
        }
        int ploidy = ((StandardCallerArgumentCollection)this.activeRegionEvaluationGenotyperEngine.getConfiguration()).genotypeArgs.samplePloidy;
        List<Allele> noCall = GATKVariantContextUtils.noCallAlleles(ploidy);
        Map<String, AlignmentContext> splitContexts = this.samplesList.numberOfSamples() == 1 ? context.splitContextBySampleName(this.samplesList.getSample(0), this.readsHeader) : context.splitContextBySampleName(this.readsHeader);
        GenotypesContext genotypes = GenotypesContext.create((int)splitContexts.keySet().size());
        MathUtils.RunningAverage averageHQSoftClips = new MathUtils.RunningAverage();
        for (Map.Entry<String, AlignmentContext> sample : splitContexts.entrySet()) {
            int activeRegionDetectionHackishSamplePloidy = ((StandardCallerArgumentCollection)this.activeRegionEvaluationGenotyperEngine.getConfiguration()).genotypeArgs.samplePloidy;
            double[] genotypeLikelihoods = ((RefVsAnyResult)this.referenceConfidenceModel.calcGenotypeLikelihoodsOfRefVsAny((int)activeRegionDetectionHackishSamplePloidy, (ReadPileup)sample.getValue().getBasePileup(), (byte)ref.getBase(), (byte)this.hcArgs.minBaseQualityScore, (MathUtils.RunningAverage)averageHQSoftClips, (boolean)false)).genotypeLikelihoods;
            genotypes.add(new GenotypeBuilder(sample.getKey()).alleles(noCall).PL(genotypeLikelihoods).make());
        }
        List<Allele> alleles = Arrays.asList(FAKE_REF_ALLELE, FAKE_ALT_ALLELE);
        double isActiveProb = genotypes.size() == 1 ? this.activeRegionEvaluationGenotyperEngine.calculateSingleSampleRefVsAnyActiveStateProfileValue(genotypes.get(0).getLikelihoods().getAsVector()) : ((vcOut = this.activeRegionEvaluationGenotyperEngine.calculateGenotypes(new VariantContextBuilder("HCisActive!", context.getContig(), (long)context.getLocation().getStart(), (long)context.getLocation().getEnd(), alleles).genotypes(genotypes).make())) == null ? 0.0 : QualityUtils.qualToProb(vcOut.getPhredScaledQual()));
        return new ActivityProfileState(ref.getInterval(), isActiveProb, averageHQSoftClips.mean() > 6.0 ? ActivityProfileState.Type.HIGH_QUALITY_SOFT_CLIPS : ActivityProfileState.Type.NONE, averageHQSoftClips.mean());
    }

    public List<VariantContext> callRegion(AssemblyRegion region, FeatureContext features, ReferenceContext referenceContext) {
        SortedSet<VariantContext> sortedSet;
        AssemblyRegionTrimmer.Result trimmingResult;
        if (this.hcArgs.justDetermineActiveRegions) {
            return NO_CALLS;
        }
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            HaplotypeCallerGenotypingDebugger.println("calling for region: " + region.getSpan());
        }
        ArrayList<VariantContext> VCpriors = new ArrayList<VariantContext>();
        if (this.hcArgs.standardArgs.genotypeArgs.supportVariants != null) {
            features.getValues(this.hcArgs.standardArgs.genotypeArgs.supportVariants).stream().forEach(VCpriors::add);
        }
        if (this.hcArgs.sampleNameToUse != null) {
            this.removeReadsFromAllSamplesExcept(this.hcArgs.sampleNameToUse, region);
        }
        if (!region.isActive()) {
            return this.referenceModelForNoVariation(region, true, VCpriors);
        }
        List<VariantContext> givenAlleles = features.getValues(this.hcArgs.alleles).stream().filter(vc -> this.hcArgs.forceCallFiltered || vc.isNotFiltered()).collect(Collectors.toList());
        if (givenAlleles.isEmpty() && region.size() == 0) {
            return this.referenceModelForNoVariation(region, true, VCpriors);
        }
        if (this.assemblyDebugOutStream != null) {
            try {
                this.assemblyDebugOutStream.write("\n\n\n\n" + region.getSpan() + "\nNumber of reads in region: " + region.getReads().size() + "     they are:\n");
                for (GATKRead gATKRead : region.getReads()) {
                    this.assemblyDebugOutStream.write(gATKRead.getName() + "   " + gATKRead.convertToSAMRecord(region.getHeader()).getFlags() + "\n");
                }
            }
            catch (IOException e) {
                throw new UserException("Error writing to debug output stream", e);
            }
        }
        AssemblyResultSet untrimmedAssemblyResult = AssemblyBasedCallerUtils.assembleReads(region, givenAlleles, this.hcArgs, this.readsHeader, this.samplesList, logger, this.referenceReader, this.assemblyEngine, this.aligner, !this.hcArgs.doNotCorrectOverlappingBaseQualities);
        if (this.assemblyDebugOutStream != null) {
            try {
                this.assemblyDebugOutStream.write("\nThere were " + untrimmedAssemblyResult.getHaplotypeList().size() + " haplotypes found. Here they are:\n");
                for (String haplotype2 : untrimmedAssemblyResult.getHaplotypeList().stream().map(haplotype -> haplotype.toString()).sorted().collect(Collectors.toList())) {
                    this.assemblyDebugOutStream.write(haplotype2);
                    this.assemblyDebugOutStream.append('\n');
                }
            }
            catch (IOException iOException) {
                throw new UserException("Error writing to debug output stream", iOException);
            }
        }
        if (!(trimmingResult = this.trimmer.trim(region, sortedSet = untrimmedAssemblyResult.getVariationEvents(this.hcArgs.maxMnpDistance), referenceContext)).isVariationPresent() && !this.hcArgs.disableOptimizations) {
            return this.referenceModelForNoVariation(region, false, VCpriors);
        }
        AssemblyResultSet assemblyResult = untrimmedAssemblyResult.trimTo(trimmingResult.getVariantRegion());
        AssemblyRegion regionForGenotyping = assemblyResult.getRegionForGenotyping();
        List<GATKRead> readStubs = regionForGenotyping.getReads().stream().filter(r -> AlignmentUtils.unclippedReadLength(r) < 10).collect(Collectors.toList());
        regionForGenotyping.removeAll(readStubs);
        Set<GATKRead> filteredReads = this.filterNonPassingReads(regionForGenotyping);
        Map<String, List<GATKRead>> perSampleFilteredReadList = AssemblyBasedCallerUtils.splitReadsBySample(this.samplesList, this.readsHeader, filteredReads);
        if (!assemblyResult.isVariationPresent() && !this.hcArgs.disableOptimizations) {
            return this.referenceModelForNoVariation(region, false, VCpriors);
        }
        if (this.hcArgs.dontGenotype) {
            return NO_CALLS;
        }
        if (regionForGenotyping.size() == 0 && !this.hcArgs.disableOptimizations) {
            return this.referenceModelForNoVariation(region, false, VCpriors);
        }
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            HaplotypeCallerGenotypingDebugger.println("\n=================================================");
            HaplotypeCallerGenotypingDebugger.println("assemblyRegion: " + new SimpleInterval(region));
            HaplotypeCallerGenotypingDebugger.println("=================================================");
        }
        List<Haplotype> haplotypes = assemblyResult.getHaplotypeList();
        Map<String, List<GATKRead>> reads = AssemblyBasedCallerUtils.splitReadsBySample(this.samplesList, this.readsHeader, regionForGenotyping.getReads());
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            HaplotypeCallerGenotypingDebugger.println("\nUnclipped Haplotypes(" + haplotypes.size() + "):");
            for (Haplotype haplotype3 : untrimmedAssemblyResult.getHaplotypeList()) {
                HaplotypeCallerGenotypingDebugger.println("[" + haplotype3.getStartPosition() + "-" + haplotype3.getStopPosition() + "] k=" + haplotype3.getKmerSize() + " len: " + haplotype3.length() + " " + haplotype3.getCigar() + (haplotype3.isReference() ? "ref" : ""));
                HaplotypeCallerGenotypingDebugger.println(haplotype3.toString());
            }
            HaplotypeCallerGenotypingDebugger.println("\nClipped Haplotyes(" + haplotypes.size() + "):");
            for (Haplotype haplotype2 : haplotypes) {
                HaplotypeCallerGenotypingDebugger.println("[" + haplotype2.getStartPosition() + "-" + haplotype2.getStopPosition() + "] k=" + haplotype2.getKmerSize() + " len: " + haplotype2.length() + " " + haplotype2.getCigar() + (haplotype2.isReference() ? "ref" : ""));
                HaplotypeCallerGenotypingDebugger.println(haplotype2.toString());
            }
            HaplotypeCallerGenotypingDebugger.println("");
        }
        AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods = this.likelihoodCalculationEngine.computeReadLikelihoods(assemblyResult, this.samplesList, reads);
        Map<GATKRead, GATKRead> readRealignments = AssemblyBasedCallerUtils.realignReadsToTheirBestHaplotype(readLikelihoods, assemblyResult.getReferenceHaplotype(), assemblyResult.getPaddedReferenceLoc(), this.aligner);
        readLikelihoods.changeEvidence(readRealignments);
        if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
            for (int counter = 0; counter < readLikelihoods.sampleEvidence(0).size(); ++counter) {
                GATKRead read = readLikelihoods.sampleEvidence(0).get(counter);
                HaplotypeCallerGenotypingDebugger.println("read " + counter + ": " + read.getName() + " cigar: " + read.getCigar() + " mapQ: " + read.getMappingQuality() + " loc: [" + read.getStart() + "-" + read.getEnd() + "] unclippedloc: [" + read.getUnclippedStart() + "-" + read.getUnclippedEnd() + "] length:" + read.getLength());
                String hmmScores = "";
                for (int h = 0; h < readLikelihoods.numberOfAlleles(); ++h) {
                    hmmScores = hmmScores + "," + readLikelihoods.sampleMatrix(0).get(h, counter);
                }
                HaplotypeCallerGenotypingDebugger.println(hmmScores);
            }
        }
        CalledHaplotypes calledHaplotypes = this.genotypingEngine.assignGenotypeLikelihoods(haplotypes, readLikelihoods, perSampleFilteredReadList, assemblyResult.getFullReferenceWithPadding(), assemblyResult.getPaddedReferenceLoc(), regionForGenotyping.getSpan(), features, givenAlleles, this.emitReferenceConfidence(), this.hcArgs.maxMnpDistance, this.readsHeader, this.haplotypeBAMWriter.isPresent());
        if (this.haplotypeBAMWriter.isPresent()) {
            HashSet<Haplotype> calledHaplotypeSet = new HashSet<Haplotype>(calledHaplotypes.getCalledHaplotypes());
            if (this.hcArgs.disableOptimizations) {
                calledHaplotypeSet.add(assemblyResult.getReferenceHaplotype());
            }
            this.haplotypeBAMWriter.get().writeReadsAlignedToHaplotypes(haplotypes, assemblyResult.getPaddedReferenceLoc(), haplotypes, calledHaplotypeSet, readLikelihoods, regionForGenotyping.getSpan());
        }
        if (this.hcArgs.assemblerArgs.debugAssembly) {
            logger.info("----------------------------------------------------------------------------------");
        }
        if (this.emitReferenceConfidence()) {
            if (!this.containsCalls(calledHaplotypes)) {
                return this.referenceModelForNoVariation(region, false, VCpriors);
            }
            LinkedList<VariantContext> result = new LinkedList<VariantContext>();
            trimmingResult.nonVariantLeftFlankRegion().ifPresent(flank -> result.addAll(this.referenceModelForNoVariation((AssemblyRegion)flank, false, (List<VariantContext>)VCpriors)));
            result.addAll(this.referenceConfidenceModel.calculateRefConfidence(assemblyResult.getReferenceHaplotype(), calledHaplotypes.getCalledHaplotypes(), assemblyResult.getPaddedReferenceLoc(), regionForGenotyping, readLikelihoods, this.genotypingEngine.getPloidyModel(), calledHaplotypes.getCalls(), this.hcArgs.standardArgs.genotypeArgs.supportVariants != null, VCpriors));
            trimmingResult.nonVariantRightFlankRegion().ifPresent(flank -> result.addAll(this.referenceModelForNoVariation((AssemblyRegion)flank, false, (List<VariantContext>)VCpriors)));
            return result;
        }
        return calledHaplotypes.getCalls().stream().map(RMSMappingQuality.getInstance()::finalizeRawMQ).collect(Collectors.toList());
    }

    private boolean containsCalls(CalledHaplotypes calledHaplotypes) {
        return calledHaplotypes.getCalls().stream().flatMap(call -> call.getGenotypes().stream()).anyMatch(Genotype::isCalled);
    }

    private List<VariantContext> referenceModelForNoVariation(AssemblyRegion region, boolean needsToBeFinalized, List<VariantContext> VCpriors) {
        if (this.emitReferenceConfidence()) {
            if (needsToBeFinalized) {
                AssemblyBasedCallerUtils.finalizeRegion(region, this.hcArgs.assemblerArgs.errorCorrectReads, this.hcArgs.dontUseSoftClippedBases, this.minTailQuality, this.readsHeader, this.samplesList, !this.hcArgs.doNotCorrectOverlappingBaseQualities, this.hcArgs.softClipLowQualityEnds);
            }
            this.filterNonPassingReads(region);
            SimpleInterval paddedLoc = region.getPaddedSpan();
            Haplotype refHaplotype = AssemblyBasedCallerUtils.createReferenceHaplotype(region, paddedLoc, this.referenceReader);
            List<Haplotype> haplotypes = Collections.singletonList(refHaplotype);
            return this.referenceConfidenceModel.calculateRefConfidence(refHaplotype, haplotypes, paddedLoc, region, AssemblyBasedCallerUtils.createDummyStratifiedReadMap(refHaplotype, this.samplesList, this.readsHeader, region), this.genotypingEngine.getPloidyModel(), Collections.emptyList(), this.hcArgs.standardArgs.genotypeArgs.supportVariants != null, VCpriors);
        }
        return NO_CALLS;
    }

    public void shutdown() {
        this.likelihoodCalculationEngine.close();
        this.aligner.close();
        if (this.haplotypeBAMWriter.isPresent()) {
            this.haplotypeBAMWriter.get().close();
        }
        if (this.referenceReader != null) {
            try {
                this.referenceReader.close();
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        if (this.assemblyDebugOutStream != null) {
            try {
                this.assemblyDebugOutStream.close();
            }
            catch (IOException e) {
                throw new UserException("Error closing debug output stream", e);
            }
        }
        HaplotypeCallerGenotypingDebugger.close();
        this.assemblyEngine.printDebugHistograms();
    }

    private Set<GATKRead> filterNonPassingReads(AssemblyRegion activeRegion) {
        LinkedHashSet<GATKRead> readsToRemove = new LinkedHashSet<GATKRead>();
        for (GATKRead rec : activeRegion.getReads()) {
            if (AlignmentUtils.unclippedReadLength(rec) >= 10 && rec.getMappingQuality() >= this.hcArgs.mappingQualityThreshold && ReadFilterLibrary.MATE_ON_SAME_CONTIG_OR_NO_MAPPED_MATE.test(rec) && (this.hcArgs.keepRG == null || rec.getReadGroup().equals(this.hcArgs.keepRG))) continue;
            if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                HaplotypeCallerGenotypingDebugger.println("Filtered before assembly the read: " + rec.toString());
            }
            readsToRemove.add(rec);
        }
        activeRegion.removeAll(readsToRemove);
        return readsToRemove;
    }

    public boolean emitReferenceConfidence() {
        return this.hcArgs.emitReferenceConfidence != ReferenceConfidenceMode.NONE;
    }

    private void removeReadsFromAllSamplesExcept(String targetSample, AssemblyRegion activeRegion) {
        LinkedHashSet<GATKRead> readsToRemove = new LinkedHashSet<GATKRead>();
        for (GATKRead rec : activeRegion.getReads()) {
            if (ReadUtils.getSampleName(rec, this.readsHeader).equals(targetSample)) continue;
            readsToRemove.add(rec);
        }
        activeRegion.removeAll(readsToRemove);
    }
}

