/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public class HaplotypeCallerGenotypingDebugger {
    private static PrintStream genotyperDebugOutStream;

    public static void initialize(String debugLocation) {
        try {
            genotyperDebugOutStream = new PrintStream(Files.newOutputStream(IOUtils.getPath(debugLocation), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(debugLocation, "Provided argument for genotyper debug location could not be created");
        }
    }

    public static boolean isEnabled() {
        return genotyperDebugOutStream != null;
    }

    public static synchronized void println(String debug) {
        if (genotyperDebugOutStream != null) {
            genotyperDebugOutStream.println(debug);
        }
    }

    public static void close() {
        if (genotyperDebugOutStream != null) {
            genotyperDebugOutStream.close();
        }
    }
}

