/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceMemorySource;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.DRAGENGenotypesModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingData;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingLikelihoods;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.HomogeneousPloidyModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.IndependentSampleGenotypesModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.tools.walkers.genotyper.StandardCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.CalledHaplotypes;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.DragstrVariantContextAnnotations;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingDebugger;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParamUtils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.dragstr.DragstrReferenceAnalyzer;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;
import org.broadinstitute.hellbender.utils.genotyper.GenotypePriorCalculator;
import org.broadinstitute.hellbender.utils.genotyper.IndexedAlleleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.haplotype.EventMap;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class HaplotypeCallerGenotypingEngine
extends GenotypingEngine<StandardCallerArgumentCollection> {
    private static final Logger logger = LogManager.getLogger(HaplotypeCallerGenotypingEngine.class);
    private static final OneShotLogger DRAGENConaminationWarning = new OneShotLogger(logger);
    private final GenotypingModel genotypingModel;
    private final PloidyModel ploidyModel;
    private final ReferenceConfidenceMode referenceConfidenceMode;
    protected final double snpHeterozygosity;
    protected final double indelHeterozygosity;
    private final int maxGenotypeCountToEnumerate;
    private final Map<Integer, Integer> practicalAlleleCountForPloidy = new HashMap<Integer, Integer>();
    protected final boolean doPhysicalPhasing;
    private final DragstrParams dragstrParams;
    private final HaplotypeCallerArgumentCollection hcArgs;

    public HaplotypeCallerGenotypingEngine(HaplotypeCallerArgumentCollection configuration, SampleList samples, boolean doPhysicalPhasing, boolean applyBQD) {
        super(configuration.standardArgs, samples, false);
        this.hcArgs = configuration;
        this.doPhysicalPhasing = doPhysicalPhasing;
        this.ploidyModel = new HomogeneousPloidyModel(samples, configuration.standardArgs.genotypeArgs.samplePloidy);
        this.dragstrParams = DragstrParamUtils.parse(configuration.likelihoodArgs.dragstrParams);
        this.genotypingModel = this.hcArgs.applyBQD || this.hcArgs.applyFRD ? new DRAGENGenotypesModel(applyBQD, this.hcArgs.applyFRD, this.hcArgs.informativeReadOverlapMargin, this.hcArgs.maxEffectiveDepthAdjustment, this.dragstrParams) : new IndependentSampleGenotypesModel();
        this.maxGenotypeCountToEnumerate = configuration.standardArgs.genotypeArgs.MAX_GENOTYPE_COUNT;
        this.referenceConfidenceMode = configuration.emitReferenceConfidence;
        this.snpHeterozygosity = configuration.standardArgs.genotypeArgs.snpHeterozygosity;
        this.indelHeterozygosity = configuration.standardArgs.genotypeArgs.indelHeterozygosity;
    }

    @Override
    protected String callSourceString() {
        return "HC_call";
    }

    @Override
    protected boolean forceKeepAllele(Allele allele) {
        return allele.equals(Allele.NON_REF_ALLELE, false) || this.referenceConfidenceMode != ReferenceConfidenceMode.NONE;
    }

    public CalledHaplotypes assignGenotypeLikelihoods(List<Haplotype> haplotypes, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods, Map<String, List<GATKRead>> perSampleFilteredReadList, byte[] ref, SimpleInterval refLoc, SimpleInterval activeRegionWindow, FeatureContext tracker, List<VariantContext> givenAlleles, boolean emitReferenceConfidence, int maxMnpDistance, SAMFileHeader header, boolean withBamOut) {
        Utils.nonEmpty(haplotypes, "haplotypes input should be non-empty and non-null");
        Utils.validateArg(readLikelihoods != null && readLikelihoods.numberOfSamples() > 0, "readLikelihoods input should be non-empty and non-null");
        Utils.validateArg(ref != null && ref.length > 0, "ref bytes input should be non-empty and non-null");
        Utils.nonNull(refLoc, "refLoc must be non-null");
        Utils.validateArg(refLoc.size() == ref.length, " refLoc length must match ref bytes");
        Utils.nonNull(activeRegionWindow, "activeRegionWindow must be non-null");
        Utils.nonNull(givenAlleles, "givenAlleles must be non-null");
        Utils.validateArg(refLoc.contains(activeRegionWindow), "refLoc must contain activeRegionWindow");
        ParamUtils.isPositiveOrZero(maxMnpDistance, "maxMnpDistance may not be negative.");
        TreeSet<Integer> startPosKeySet = EventMap.buildEventMapsForHaplotypes(haplotypes, ref, refLoc, this.hcArgs.assemblerArgs.debugAssembly, maxMnpDistance);
        HashSet<Haplotype> calledHaplotypes = new HashSet<Haplotype>();
        ArrayList<VariantContext> returnCalls = new ArrayList<VariantContext>();
        int ploidy = this.configuration.genotypeArgs.samplePloidy;
        List<Allele> noCallAlleles = GATKVariantContextUtils.noCallAlleles(ploidy);
        if (withBamOut) {
            AssemblyBasedCallerUtils.annotateReadLikelihoodsWithRegions(readLikelihoods, activeRegionWindow);
        }
        DragstrReferenceAnalyzer dragstrs = this.constructDragstrReferenceSTRAnalyzerIfNecessary(haplotypes, ref, refLoc, startPosKeySet);
        BiPredicate<GATKRead, SimpleInterval> readQualifiesForGenotypingPredicate = this.composeReadQualifiesForGenotypingPredicate(this.hcArgs);
        Iterator iterator = startPosKeySet.iterator();
        while (iterator.hasNext()) {
            List<VariantContext> eventsAtThisLoc;
            List<VariantContext> eventsAtThisLocWithSpanDelsReplaced;
            VariantContext mergedVC;
            int loc = (Integer)iterator.next();
            if (loc < activeRegionWindow.getStart() || loc > activeRegionWindow.getEnd() || (mergedVC = AssemblyBasedCallerUtils.makeMergedVariantContext(eventsAtThisLocWithSpanDelsReplaced = HaplotypeCallerGenotypingEngine.replaceSpanDels(eventsAtThisLoc = AssemblyBasedCallerUtils.getVariantContextsFromActiveHaplotypes(loc, haplotypes, !this.hcArgs.disableSpanningEventGenotyping), Allele.create((byte)ref[loc - refLoc.getStart()], (boolean)true), loc))) == null) continue;
            int mergedAllelesListSizeBeforePossibleTrimming = mergedVC.getAlleles().size();
            Map<Allele, List<Haplotype>> alleleMapper = AssemblyBasedCallerUtils.createAlleleMapper(mergedVC, loc, haplotypes, !this.hcArgs.disableSpanningEventGenotyping);
            if (this.hcArgs.assemblerArgs.debugAssembly && logger != null) {
                logger.info("Genotyping event at " + loc + " with alleles = " + mergedVC.getAlleles());
            }
            mergedVC = this.removeAltAllelesIfTooManyGenotypes(ploidy, alleleMapper, mergedVC);
            AlleleLikelihoods<GATKRead, Allele> readAlleleLikelihoods = readLikelihoods.marginalize(alleleMapper);
            SAMSequenceDictionary sequenceDictionary = header.getSequenceDictionary();
            SimpleInterval variantCallingRelevantOverlap = new SimpleInterval((Locatable)mergedVC).expandWithinContig(this.hcArgs.informativeReadOverlapMargin, sequenceDictionary);
            readAlleleLikelihoods.retainEvidence(read -> readQualifiesForGenotypingPredicate.test((GATKRead)read, variantCallingRelevantOverlap));
            readAlleleLikelihoods.setVariantCallingSubsetUsed(variantCallingRelevantOverlap);
            if (this.configuration.isSampleContaminationPresent()) {
                if (this.hcArgs.applyBQD || this.hcArgs.applyFRD) {
                    DRAGENConaminationWarning.warn("\\n=============================================================================Sample contamination specified with FRD/BQD enabled. Contamination calling with either BQD or FRD genotyping models enabled is currently unsupported and may produce unexpected results. Use at your own risk.\n=============================================================================");
                }
                readAlleleLikelihoods.contaminationDownsampling(this.configuration.getSampleContamination());
            }
            if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                HaplotypeCallerGenotypingDebugger.println("\n=============================================================================");
                HaplotypeCallerGenotypingDebugger.println("Event at: " + mergedVC + " with " + readAlleleLikelihoods.evidenceCount() + " reads and " + readAlleleLikelihoods.filteredSampleEvidence(0).size() + " disqualified");
                HaplotypeCallerGenotypingDebugger.println("=============================================================================");
                HaplotypeCallerGenotypingDebugger.println("haplotype alleles key:");
                for (Map.Entry<Allele, List<Haplotype>> allele : alleleMapper.entrySet()) {
                    HaplotypeCallerGenotypingDebugger.println("Allele: " + allele.getKey() + " Haps: " + allele.getValue().stream().map(readLikelihoods::indexOfAllele).map(i -> Integer.toString(i)).collect(Collectors.joining(", ")));
                }
            }
            if (emitReferenceConfidence) {
                mergedVC = ReferenceConfidenceUtils.addNonRefSymbolicAllele(mergedVC);
                readAlleleLikelihoods.addNonReferenceAllele(Allele.NON_REF_ALLELE);
                ++mergedAllelesListSizeBeforePossibleTrimming;
            }
            GenotypesContext genotypes = this.calculateGLsForThisEvent(readAlleleLikelihoods, mergedVC, noCallAlleles, ref, loc - refLoc.getStart(), dragstrs);
            GenotypePriorCalculator gpc = this.resolveGenotypePriorCalculator(dragstrs, loc - refLoc.getStart() + 1, this.snpHeterozygosity, this.indelHeterozygosity);
            VariantContext call = this.calculateGenotypes(new VariantContextBuilder(mergedVC).genotypes(genotypes).make(), gpc, givenAlleles);
            if (call == null) continue;
            readAlleleLikelihoods = this.prepareReadAlleleLikelihoodsForAnnotation(readLikelihoods, perSampleFilteredReadList, emitReferenceConfidence, alleleMapper, readAlleleLikelihoods, call, variantCallingRelevantOverlap);
            VariantContext annotatedCall = HaplotypeCallerGenotypingEngine.makeAnnotatedCall(ref, refLoc, tracker, header, mergedVC, mergedAllelesListSizeBeforePossibleTrimming, readAlleleLikelihoods, call, this.annotationEngine);
            if (dragstrs != null && GATKVariantContextUtils.containsInlineIndel(annotatedCall)) {
                int strOffset = loc - refLoc.getStart() + 1;
                annotatedCall = DragstrVariantContextAnnotations.annotateVariantContextWithDragstrParametersUsed(annotatedCall, this.dragstrParams, dragstrs.period(strOffset), dragstrs.repeatLength(strOffset));
            }
            returnCalls.add(annotatedCall);
            if (withBamOut) {
                AssemblyBasedCallerUtils.annotateReadLikelihoodsWithSupportedAlleles(call, readAlleleLikelihoods);
            }
            call.getAlleles().stream().map(alleleMapper::get).filter(Objects::nonNull).forEach(calledHaplotypes::addAll);
        }
        ArrayList<VariantContext> phasedCalls = this.doPhysicalPhasing ? AssemblyBasedCallerUtils.phaseCalls(returnCalls, calledHaplotypes) : returnCalls;
        return new CalledHaplotypes(phasedCalls, calledHaplotypes);
    }

    private DragstrReferenceAnalyzer constructDragstrReferenceSTRAnalyzerIfNecessary(List<Haplotype> haplotypes, byte[] ref, SimpleInterval refLoc, SortedSet<Integer> startPosKeySet) {
        if (this.isDragstrSTRAnalyzerNecessary(startPosKeySet, haplotypes)) {
            int offset = startPosKeySet.first() - refLoc.getStart();
            int to = startPosKeySet.last() - refLoc.getStart() + 2;
            return DragstrReferenceAnalyzer.of(ref, offset, to, this.dragstrParams.maximumPeriod());
        }
        return null;
    }

    private BiPredicate<GATKRead, SimpleInterval> composeReadQualifiesForGenotypingPredicate(HaplotypeCallerArgumentCollection hcArgs) {
        if (hcArgs.applyBQD || hcArgs.applyFRD) {
            return (read, target) -> this.softUnclippedReadOverlapsInterval((GATKRead)read, (Locatable)target);
        }
        return (read, target) -> target.overlaps((Locatable)read);
    }

    private boolean softUnclippedReadOverlapsInterval(GATKRead read, Locatable target) {
        return read.getContig().equalsIgnoreCase(target.getContig()) && read.getSoftStart() <= target.getEnd() && read.getSoftEnd() >= target.getStart() && read.getSoftStart() <= read.getSoftEnd();
    }

    private boolean isDragstrSTRAnalyzerNecessary(SortedSet<Integer> startPosKeySet, List<Haplotype> haplotypes) {
        return !startPosKeySet.isEmpty() && this.dragstrParams != null && !this.hcArgs.standardArgs.genotypeArgs.dontUseDragstrPriors && haplotypes.stream().anyMatch(h -> h.getEventMap().getVariantContexts().stream().anyMatch(GATKVariantContextUtils::containsInlineIndel));
    }

    private GenotypePriorCalculator resolveGenotypePriorCalculator(DragstrReferenceAnalyzer strs, int pos, double snpHeterozygosity, double indelHeterozygosity) {
        if (this.hcArgs.likelihoodArgs.dragstrParams == null || this.hcArgs.standardArgs.genotypeArgs.dontUseDragstrPriors) {
            return GenotypePriorCalculator.assumingHW(Math.log10(snpHeterozygosity), Math.log10(indelHeterozygosity));
        }
        if (strs == null) {
            return GenotypePriorCalculator.givenHetToHomRatio(Math.log10(snpHeterozygosity), Math.log10(indelHeterozygosity), Math.log10(Math.min(snpHeterozygosity, indelHeterozygosity)), this.hcArgs.likelihoodArgs.dragstrHetHomRatio);
        }
        int period = strs.period(pos);
        int repeats = strs.repeatLength(pos);
        return GenotypePriorCalculator.givenDragstrParams(this.dragstrParams, period, repeats, Math.log10(snpHeterozygosity), this.hcArgs.likelihoodArgs.dragstrHetHomRatio);
    }

    @VisibleForTesting
    static List<VariantContext> replaceSpanDels(List<VariantContext> eventsAtThisLoc, Allele refAllele, int loc) {
        return eventsAtThisLoc.stream().map(vc -> HaplotypeCallerGenotypingEngine.replaceWithSpanDelVC(vc, refAllele, loc)).collect(Collectors.toList());
    }

    @VisibleForTesting
    static VariantContext replaceWithSpanDelVC(VariantContext variantContext, Allele refAllele, int loc) {
        if (variantContext.getStart() == loc) {
            return variantContext;
        }
        VariantContextBuilder builder = new VariantContextBuilder(variantContext).start((long)loc).stop((long)loc).alleles(Arrays.asList(refAllele, Allele.SPAN_DEL)).genotypes(GenotypesContext.NO_GENOTYPES);
        return builder.make();
    }

    private VariantContext removeAltAllelesIfTooManyGenotypes(int ploidy, Map<Allele, List<Haplotype>> alleleMapper, VariantContext mergedVC) {
        int originalAlleleCount = alleleMapper.size();
        this.practicalAlleleCountForPloidy.putIfAbsent(ploidy, GenotypeLikelihoodCalculators.computeMaxAcceptableAlleleCount(ploidy, this.maxGenotypeCountToEnumerate));
        int practicalAlleleCount = this.practicalAlleleCountForPloidy.get(ploidy);
        if (originalAlleleCount > practicalAlleleCount) {
            List<Allele> allelesToKeep = HaplotypeCallerGenotypingEngine.whichAllelesToKeepBasedonHapScores(alleleMapper, practicalAlleleCount);
            alleleMapper.keySet().retainAll(allelesToKeep);
            logger.warn(String.format("At position %s removed alt alleles where ploidy is %d and original allele count is %d, whereas after trimming the allele count becomes %d. Alleles kept are:%s", new SimpleInterval((Locatable)mergedVC).toString(), ploidy, originalAlleleCount, practicalAlleleCount, allelesToKeep));
            return HaplotypeCallerGenotypingEngine.removeExcessAltAllelesFromVC(mergedVC, allelesToKeep);
        }
        return mergedVC;
    }

    @VisibleForTesting
    static List<Allele> whichAllelesToKeepBasedonHapScores(Map<Allele, List<Haplotype>> alleleMapper, int desiredNumOfAlleles) {
        if (alleleMapper.size() <= desiredNumOfAlleles) {
            return alleleMapper.keySet().stream().collect(Collectors.toList());
        }
        PriorityQueue<AlleleScoredByHaplotypeScores> alleleMaxPriorityQ = new PriorityQueue<AlleleScoredByHaplotypeScores>();
        for (Allele allele : alleleMapper.keySet()) {
            List hapScores = alleleMapper.get(allele).stream().map(Haplotype::getScore).sorted().collect(Collectors.toList());
            Double highestScore = hapScores.size() > 0 ? (Double)hapScores.get(hapScores.size() - 1) : Double.valueOf(Double.NEGATIVE_INFINITY);
            Double secondHighestScore = hapScores.size() > 1 ? (Double)hapScores.get(hapScores.size() - 2) : Double.valueOf(Double.NEGATIVE_INFINITY);
            alleleMaxPriorityQ.add(new AlleleScoredByHaplotypeScores(allele, highestScore, secondHighestScore));
        }
        LinkedHashSet<Allele> allelesToRetain = new LinkedHashSet<Allele>();
        while (allelesToRetain.size() < desiredNumOfAlleles) {
            allelesToRetain.add(((AlleleScoredByHaplotypeScores)alleleMaxPriorityQ.poll()).getAllele());
        }
        return alleleMapper.keySet().stream().filter(allelesToRetain::contains).collect(Collectors.toList());
    }

    @VisibleForTesting
    static VariantContext removeExcessAltAllelesFromVC(VariantContext inputVC, Collection<Allele> allelesToKeep) {
        Utils.validateArg(allelesToKeep != null, "alleles to keep is null");
        Utils.validateArg(!allelesToKeep.contains(null), "alleles to keep contains null elements");
        Utils.validateArg(allelesToKeep.stream().anyMatch(Allele::isReference), "alleles to keep doesn't contain reference allele!");
        Utils.validateArg(inputVC.getAlleles().containsAll(allelesToKeep), "alleles to keep is not a subset of input VC alleles");
        if (inputVC.getAlleles().size() == allelesToKeep.size()) {
            return inputVC;
        }
        VariantContextBuilder vcb = new VariantContextBuilder(inputVC);
        List originalList = inputVC.getAlleles();
        originalList.retainAll(allelesToKeep);
        vcb.alleles((Collection)originalList);
        return vcb.make();
    }

    @VisibleForTesting
    protected static VariantContext makeAnnotatedCall(byte[] ref, SimpleInterval refLoc, FeatureContext tracker, SAMFileHeader header, VariantContext mergedVC, int mergedAllelesListSizeBeforePossibleTrimming, AlleleLikelihoods<GATKRead, Allele> readAlleleLikelihoods, VariantContext call, VariantAnnotatorEngine annotationEngine) {
        SimpleInterval locus = new SimpleInterval((Locatable)mergedVC);
        SimpleInterval refLocInterval = new SimpleInterval(refLoc);
        SAMSequenceDictionary sequenceDictionary = header.getSequenceDictionary();
        ReferenceMemorySource refData = new ReferenceMemorySource(new ReferenceBases(ref, refLocInterval), sequenceDictionary);
        ReferenceContext referenceContext = new ReferenceContext(refData, locus, refLocInterval);
        VariantContext untrimmedResult = annotationEngine.annotateContext(call, tracker, referenceContext, readAlleleLikelihoods, a -> true);
        return untrimmedResult.getAlleles().size() == mergedAllelesListSizeBeforePossibleTrimming ? untrimmedResult : GATKVariantContextUtils.reverseTrimAlleles(untrimmedResult);
    }

    protected GenotypesContext calculateGLsForThisEvent(AlleleLikelihoods<GATKRead, Allele> readLikelihoods, VariantContext mergedVC, List<Allele> noCallAlleles, byte[] paddedReference, int offsetForRefIntoEvent, DragstrReferenceAnalyzer dragstrs) {
        Utils.nonNull(readLikelihoods, "readLikelihoods");
        Utils.nonNull(mergedVC, "mergedVC");
        List vcAlleles = mergedVC.getAlleles();
        AlleleList alleleList = readLikelihoods.numberOfAlleles() == vcAlleles.size() ? readLikelihoods : new IndexedAlleleList(vcAlleles);
        GenotypingLikelihoods<Allele> likelihoods = this.genotypingModel.calculateLikelihoods(alleleList, new GenotypingData<Allele>(this.ploidyModel, readLikelihoods), paddedReference, offsetForRefIntoEvent, dragstrs);
        int sampleCount = this.samples.numberOfSamples();
        GenotypesContext result = GenotypesContext.create((int)sampleCount);
        for (int s = 0; s < sampleCount; ++s) {
            result.add(new GenotypeBuilder(this.samples.getSample(s)).alleles(noCallAlleles).PL(likelihoods.sampleLikelihoods(s).getAsPLs()).make());
        }
        return result;
    }

    public PloidyModel getPloidyModel() {
        return this.ploidyModel;
    }

    private AlleleLikelihoods<GATKRead, Allele> prepareReadAlleleLikelihoodsForAnnotation(AlleleLikelihoods<GATKRead, Haplotype> readHaplotypeLikelihoods, Map<String, List<GATKRead>> perSampleFilteredReadList, boolean emitReferenceConfidence, Map<Allele, List<Haplotype>> alleleMapper, AlleleLikelihoods<GATKRead, Allele> readAlleleLikelihoodsForGenotyping, VariantContext call, SimpleInterval relevantReadsOverlap) {
        AlleleLikelihoods<GATKRead, Allele> readAlleleLikelihoodsForAnnotations;
        if (this.hcArgs.useFilteredReadMapForAnnotations || !this.configuration.isSampleContaminationPresent()) {
            readAlleleLikelihoodsForAnnotations = readAlleleLikelihoodsForGenotyping;
        } else {
            readAlleleLikelihoodsForAnnotations = readHaplotypeLikelihoods.marginalize(alleleMapper);
            readAlleleLikelihoodsForAnnotations.retainEvidence(relevantReadsOverlap::overlaps);
            if (emitReferenceConfidence) {
                readAlleleLikelihoodsForAnnotations.addNonReferenceAllele(Allele.NON_REF_ALLELE);
            }
        }
        if (call.getAlleles().size() != readAlleleLikelihoodsForAnnotations.numberOfAlleles()) {
            readAlleleLikelihoodsForAnnotations.updateNonRefAlleleLikelihoods(new IndexedAlleleList(call.getAlleles()));
        }
        Map overlappingFilteredReads = HaplotypeCallerGenotypingEngine.overlappingFilteredReads(perSampleFilteredReadList, relevantReadsOverlap);
        readAlleleLikelihoodsForAnnotations.addEvidence(overlappingFilteredReads, 0.0);
        return readAlleleLikelihoodsForAnnotations;
    }

    private static Map<String, List<GATKRead>> overlappingFilteredReads(Map<String, List<GATKRead>> perSampleFilteredReadList, SimpleInterval loc) {
        HashMap<String, List<GATKRead>> overlappingFilteredReads = new HashMap<String, List<GATKRead>>(perSampleFilteredReadList.size());
        for (Map.Entry<String, List<GATKRead>> sampleEntry : perSampleFilteredReadList.entrySet()) {
            List newList;
            List<GATKRead> originalList = sampleEntry.getValue();
            String sample = sampleEntry.getKey();
            if (originalList == null || originalList.isEmpty() || (newList = (List)originalList.stream().filter(read -> read.overlaps(loc)).collect(Collectors.toCollection(() -> new ArrayList(originalList.size())))).isEmpty()) continue;
            overlappingFilteredReads.put(sample, newList);
        }
        return overlappingFilteredReads;
    }

    private static final class AlleleScoredByHaplotypeScores
    implements Comparable<AlleleScoredByHaplotypeScores> {
        private final Allele allele;
        private final Double bestHaplotypeScore;
        private final Double secondBestHaplotypeScore;

        public AlleleScoredByHaplotypeScores(Allele allele, Double bestHaplotypeScore, Double secondBestHaplotypeScore) {
            this.allele = allele;
            this.bestHaplotypeScore = bestHaplotypeScore;
            this.secondBestHaplotypeScore = secondBestHaplotypeScore;
        }

        @Override
        public int compareTo(AlleleScoredByHaplotypeScores other) {
            if (this.allele.isReference() && other.allele.isNonReference()) {
                return -1;
            }
            if (this.allele.isNonReference() && other.allele.isReference()) {
                return 1;
            }
            if (this.bestHaplotypeScore > other.bestHaplotypeScore) {
                return -1;
            }
            if (this.bestHaplotypeScore < other.bestHaplotypeScore) {
                return 1;
            }
            if (!this.secondBestHaplotypeScore.equals(other.secondBestHaplotypeScore)) {
                return this.secondBestHaplotypeScore > other.secondBestHaplotypeScore ? -1 : 1;
            }
            return this.allele.compareTo(other.allele);
        }

        public Allele getAllele() {
            return this.allele;
        }
    }
}

