/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import java.io.File;
import java.util.Collections;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadThreadingAssemblerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;

public class HaplotypeCallerReadThreadingAssemblerArgumentCollection
extends ReadThreadingAssemblerArgumentCollection {
    private static final long serialVersionUID = 6520834L;
    @Advanced
    @Argument(fullName="adaptive-pruning", doc="Use Mutect2's adaptive graph pruning algorithm", optional=true)
    public boolean useAdaptivePruning = false;
    @Hidden
    @Argument(fullName="do-not-recover-dangling-branches", doc="Disable dangling head and tail recovery", optional=true)
    public boolean doNotRecoverDanglingBranches = false;
    @Deprecated
    @Argument(fullName="recover-dangling-heads", doc="This argument is deprecated since version 3.3", optional=true)
    public boolean DEPRECATED_RecoverDanglingHeads = false;

    @Override
    public ReadThreadingAssembler makeReadThreadingAssembler() {
        ReadThreadingAssembler assemblyEngine = new ReadThreadingAssembler(this.maxNumHaplotypesInPopulation, Collections.unmodifiableList(this.kmerSizes), this.dontIncreaseKmerSizesForCycles, this.allowNonUniqueKmersInRef, this.numPruningSamples, this.useAdaptivePruning ? 0 : this.minPruneFactor, this.useAdaptivePruning, this.initialErrorRateForPruning, this.pruningLogOddsThreshold, this.pruningSeedingLogOddsThreshold, this.maxUnprunedVariants, this.useLinkedDeBruijnGraph, this.enableLegacyGraphCycleDetection, this.minMatchingBasesToDanglingEndRecovery);
        assemblyEngine.setDebugGraphTransformations(this.debugGraphTransformations);
        assemblyEngine.setRecoverDanglingBranches(!this.doNotRecoverDanglingBranches);
        assemblyEngine.setRecoverAllDanglingBranches(this.recoverAllDanglingBranches);
        assemblyEngine.setMinDanglingBranchLength(this.minDanglingBranchLength);
        assemblyEngine.setArtificialHaplotypeRecoveryMode(this.disableArtificialHaplotypeRecovery);
        if (this.graphOutput != null) {
            assemblyEngine.setGraphWriter(new File(this.graphOutput));
        }
        if (this.haplotypeHistogramOutput != null) {
            assemblyEngine.setDebugHistogramOutput(new File(this.haplotypeHistogramOutput));
        }
        return assemblyEngine;
    }
}

