/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.Kmer;
import org.broadinstitute.hellbender.utils.Utils;

public final class KMerCounter {
    private final Map<Kmer, CountedKmer> countsByKMer = new HashMap<Kmer, CountedKmer>();
    private final int kmerLength;

    public KMerCounter(int kmerLength) {
        Utils.validateArg(kmerLength > 0, () -> "kmerLength must be > 0 but got " + kmerLength);
        this.kmerLength = kmerLength;
    }

    public int getKmerCount(Kmer kmer) {
        Utils.nonNull(kmer, "kmer cannot be null");
        CountedKmer counted = this.countsByKMer.get(kmer);
        return counted == null ? 0 : counted.count;
    }

    public Collection<CountedKmer> getCountedKmers() {
        return this.countsByKMer.values();
    }

    public Collection<Kmer> getKmersWithCountsAtLeast(int minCount) {
        LinkedList<Kmer> result = new LinkedList<Kmer>();
        for (CountedKmer countedKmer : this.getCountedKmers()) {
            if (countedKmer.count < minCount) continue;
            result.add(countedKmer.kmer);
        }
        return result;
    }

    public void clear() {
        this.countsByKMer.clear();
    }

    public void addKmer(Kmer kmer, int kmerCount) {
        Utils.validateArg(kmer.length() == this.kmerLength, () -> "bad kmer length " + kmer + " expected size " + this.kmerLength);
        Utils.validateArg(kmerCount >= 0, () -> "bad kmerCount " + kmerCount);
        CountedKmer countFromMap = this.countsByKMer.get(kmer);
        if (countFromMap == null) {
            countFromMap = new CountedKmer(kmer);
            this.countsByKMer.put(kmer, countFromMap);
        }
        countFromMap.count += kmerCount;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("KMerCounter{");
        b.append("counting ").append(this.countsByKMer.size()).append(" distinct kmers");
        b.append("\n}");
        return b.toString();
    }

    @VisibleForTesting
    void addKmer(String rawKmer, int kmerCount) {
        this.addKmer(new Kmer(rawKmer), kmerCount);
    }

    @VisibleForTesting
    void addKmers(String ... kmers) {
        for (String kmer : kmers) {
            this.addKmer(kmer, 1);
        }
    }

    static final class CountedKmer
    implements Comparable<CountedKmer> {
        final Kmer kmer;
        int count = 0;

        private CountedKmer(Kmer kmer) {
            this.kmer = kmer;
        }

        public Kmer getKmer() {
            return this.kmer;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return "CountedKmer{kmer='" + this.kmer + '\'' + ", count=" + this.count + '}';
        }

        @Override
        public int compareTo(CountedKmer o) {
            return Integer.compare(o.count, this.count);
        }
    }
}

