/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.broadinstitute.hellbender.utils.Utils;

public final class Kmer {
    private byte[] bases;
    private int start;
    private final int length;
    private final int hash;

    public Kmer(byte[] kmer) {
        this(kmer, 0, kmer.length);
    }

    public Kmer(String kmer) {
        this(Utils.nonNull(kmer).getBytes());
    }

    public Kmer(byte[] bases, int start, int length) {
        this.bases = Utils.nonNull(bases, "bases cannot be null");
        Utils.validateArg(start >= 0, () -> "start must be >= 0 but got " + start);
        Utils.validateArg(length >= 0, () -> "length must be >= 0 but got " + length);
        Utils.validateArg(start + length <= bases.length, () -> "start + length " + (start + length) + " must be <= bases.length " + bases.length + " but got " + start + " with length " + length);
        this.start = start;
        this.length = length;
        this.hash = Kmer.hashCode(bases, start, length);
    }

    private static int hashCode(byte[] bases, int start, int length) {
        if (length == 0) {
            return 0;
        }
        int h = 0;
        int stop = start + length;
        for (int i = start; i < stop; ++i) {
            h = 31 * h + bases[i];
        }
        return h;
    }

    public Kmer subKmer(int newStart, int newLength) {
        return new Kmer(this.bases, this.start + newStart, newLength);
    }

    public byte[] bases() {
        if (this.start != 0 || this.bases.length != this.length) {
            this.bases = Arrays.copyOfRange(this.bases, this.start, this.start + this.length);
            this.start = 0;
        }
        return this.bases;
    }

    public int length() {
        return this.length;
    }

    public int getDifferingPositions(Kmer other, int maxDistance, int[] differingIndeces, byte[] differingBases) {
        Utils.nonNull(other);
        Utils.nonNull(differingIndeces);
        Utils.nonNull(differingBases);
        Utils.validateArg(maxDistance > 0, "maxDistance must be positive but was " + maxDistance);
        int dist = 0;
        if (this.length == other.length()) {
            byte[] f2 = other.bases;
            for (int i = 0; i < this.length; ++i) {
                if (this.bases[this.start + i] == f2[i]) continue;
                differingIndeces[dist] = i;
                differingBases[dist++] = f2[i];
                if (dist <= maxDistance) continue;
                return -1;
            }
        }
        return dist;
    }

    public String toString() {
        return "Kmer{" + new String(this.bases, this.start, this.length) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Kmer)) {
            return false;
        }
        Kmer kmer = (Kmer)o;
        if (this.hash != kmer.hash || this.length != kmer.length) {
            return false;
        }
        return Utils.equalRange(this.bases, this.start, kmer.bases, kmer.start, this.length);
    }

    public int hashCode() {
        return this.hash;
    }

    @VisibleForTesting
    int start() {
        return this.start;
    }
}

