/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.PairHMMLikelihoodCalculationEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.PairHMMNativeArgumentCollection;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMM;

public final class LikelihoodEngineArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BASE_QUALITY_SCORE_THRESHOLD_FULLNAME = "base-quality-score-threshold";
    public static final String DRAGSTR_PARAMS_PATH_FULLNAME = "dragstr-params-path";
    public static final String DRAGSTR_HET_HOM_RATIO_FULLNAME = "dragstr-het-hom-ratio";
    public static final String DONT_USE_DRAGSTR_PAIRHMM_FULLNAME = "dont-use-dragstr-pair-hmm-scores";
    @Argument(fullName="base-quality-score-threshold", doc="Base qualities below this threshold will be reduced to the minimum (6)", optional=true)
    public byte BASE_QUALITY_SCORE_THRESHOLD = (byte)18;
    @Argument(fullName="dragstr-params-path", doc="location of the DRAGstr model parameters for STR error correction used in the Pair HMM. When provided, it overrides other PCR error correcting mechanisms", optional=true)
    public GATKPath dragstrParams = null;
    @Argument(fullName="dragstr-het-hom-ratio", doc="het to hom prior ratio use with DRAGstr on", optional=true)
    public int dragstrHetHomRatio = 2;
    @Argument(fullName="dont-use-dragstr-pair-hmm-scores", doc="disable DRAGstr pair-hmm score even when dragstr-params-path was provided", optional=false)
    public boolean dontUseDragstrPairHMMScores = false;
    @Advanced
    @Argument(fullName="pair-hmm-gap-continuation-penalty", doc="Flat gap continuation penalty for use in the Pair HMM", optional=true)
    public int gcpHMM = 10;
    @Advanced
    @Argument(fullName="expected-mismatch-rate-for-read-disqualification", doc="Error rate used to set expectation for post HMM read disqualification based on mismatches", optional=true)
    public double expectedErrorRatePerBase = 0.02;
    @Advanced
    @Argument(fullName="pair-hmm-implementation", shortName="pairHMM", doc="The PairHMM implementation to use for genotype likelihood calculations", optional=true)
    public PairHMM.Implementation pairHMM = PairHMM.Implementation.FASTEST_AVAILABLE;
    @Advanced
    @Argument(fullName="pcr-indel-model", doc="The PCR indel model to use", optional=true)
    public PairHMMLikelihoodCalculationEngine.PCRErrorModel pcrErrorModel = PairHMMLikelihoodCalculationEngine.PCRErrorModel.CONSERVATIVE;
    @Advanced
    @Argument(fullName="phred-scaled-global-read-mismapping-rate", doc="The global assumed mismapping rate for reads", optional=true)
    public int phredScaledGlobalReadMismappingRate = 45;
    @Advanced
    @Argument(fullName="disable-symmetric-hmm-normalizing", doc="Toggle to revive legacy behavior of asymmetrically normalizing the arguments to the reference haplotype", optional=true)
    public boolean disableSymmetricallyNormalizeAllelesToReference = false;
    @Advanced
    @Argument(fullName="disable-cap-base-qualities-to-map-quality", doc="If false this disables capping of base qualities in the HMM to the mapping quality of the read", optional=true)
    public boolean disableCapReadQualitiesToMapQ = false;
    @Argument(fullName="enable-dynamic-read-disqualification-for-genotyping", doc="Will enable less strict read disqualification low base quality reads")
    public boolean enableDynamicReadDisqualification = false;
    @Advanced
    @Hidden
    @Argument(fullName="dynamic-read-disqualification-threshold", doc="Constant used to scale the dynamic read disqualificaiton")
    public double readDisqualificationThresholdConstant = 1.0;
    @ArgumentCollection
    public PairHMMNativeArgumentCollection pairHMMNativeArgs = new PairHMMNativeArgumentCollection();
}

