/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import java.io.File;
import java.util.Collections;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadThreadingAssemblerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;

public class MutectReadThreadingAssemblerArgumentCollection
extends ReadThreadingAssemblerArgumentCollection {
    private static final long serialVersionUID = 5304L;
    @Advanced
    @Argument(fullName="disable-adaptive-pruning", doc="Disable the adaptive algorithm for pruning paths in the graph", optional=true)
    public boolean disableAdaptivePruning = false;

    @Override
    public ReadThreadingAssembler makeReadThreadingAssembler() {
        ReadThreadingAssembler assemblyEngine = new ReadThreadingAssembler(this.maxNumHaplotypesInPopulation, Collections.unmodifiableList(this.kmerSizes), this.dontIncreaseKmerSizesForCycles, this.allowNonUniqueKmersInRef, this.numPruningSamples, this.disableAdaptivePruning ? this.minPruneFactor : 0, !this.disableAdaptivePruning, this.initialErrorRateForPruning, this.pruningLogOddsThreshold, this.pruningSeedingLogOddsThreshold, this.maxUnprunedVariants, this.useLinkedDeBruijnGraph, this.enableLegacyGraphCycleDetection, this.minMatchingBasesToDanglingEndRecovery);
        assemblyEngine.setDebugGraphTransformations(this.debugGraphTransformations);
        assemblyEngine.setRecoverDanglingBranches(true);
        assemblyEngine.setRecoverAllDanglingBranches(this.recoverAllDanglingBranches);
        assemblyEngine.setMinDanglingBranchLength(this.minDanglingBranchLength);
        assemblyEngine.setArtificialHaplotypeRecoveryMode(this.disableArtificialHaplotypeRecovery);
        if (this.graphOutput != null) {
            assemblyEngine.setGraphWriter(new File(this.graphOutput));
        }
        if (this.haplotypeHistogramOutput != null) {
            assemblyEngine.setDebugHistogramOutput(new File(this.haplotypeHistogramOutput));
        }
        return assemblyEngine;
    }
}

