/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeArguments;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyResultSet;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.DragstrPairHMMInputScoreImputator;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingDebugger;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadLikelihoodCalculationEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.StandardPairHMMInputScoreImputator;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.clipping.ReadClipper;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.IndexedAlleleList;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMM;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class PairHMMLikelihoodCalculationEngine
implements ReadLikelihoodCalculationEngine {
    static final double DEFAULT_DYNAMIC_DISQUALIFICATION_SCALE_FACTOR = 1.0;
    private static final Logger logger = LogManager.getLogger(PairHMMLikelihoodCalculationEngine.class);
    private static final int MAX_STR_UNIT_LENGTH = 8;
    private static final int MAX_REPEAT_LENGTH = 20;
    private static final int MIN_ADJUSTED_QSCORE = 10;
    @VisibleForTesting
    static final double INITIAL_QSCORE = 40.0;
    public static final String HMM_BASE_QUALITIES_TAG = "HMMQuals";
    private final byte constantGCP;
    private final double log10globalReadMismappingRate;
    private final PairHMM pairHMM;
    private final DragstrParams dragstrParams;
    private final boolean dynamicDisqualification;
    private final double readDisqualificationScale;
    private final double expectedErrorRatePerBase;
    private final boolean disableCapReadQualitiesToMapQ;
    private final boolean symmetricallyNormalizeAllelesToReference;
    private final boolean modifySoftclippedBases;
    private final PCRErrorModel pcrErrorModel;
    private final byte baseQualityScoreThreshold;
    public static final double DEFAULT_EXPECTED_ERROR_RATE_PER_BASE = 0.02;
    private static double[] dynamicReadQualThreshLookupTable = new double[]{1.0, 5.996842844, 0.196616587, 2.0, 5.870018422, 1.388545569, 3.0, 5.401558531, 5.641990128, 4.0, 4.818940919, 10.33176216, 5.0, 4.218758304, 14.25799688, 6.0, 3.646319832, 17.02880749, 7.0, 3.122346753, 18.64537883, 8.0, 2.654731979, 19.27521677, 9.0, 2.244479156, 19.13584613, 10.0, 1.88893867, 18.43922003, 11.0, 1.583645342, 17.36842261, 12.0, 1.3233807, 16.07088712, 13.0, 1.102785365, 14.65952563, 14.0, 0.916703025, 13.21718577, 15.0, 0.760361881, 11.80207947, 16.0, 0.629457387, 10.45304833, 17.0, 0.520175654, 9.194183767, 18.0, 0.42918208, 8.038657241, 19.0, 0.353590663, 6.991779595, 20.0, 0.290923699, 6.053379213, 21.0, 0.23906788, 5.219610436, 22.0, 0.196230431, 4.484302033, 23.0, 0.160897421, 3.839943445, 24.0, 0.131795374, 3.27839108, 25.0, 0.1078567, 2.791361596, 26.0, 0.088189063, 2.370765375, 27.0, 0.072048567, 2.008921719, 28.0, 0.058816518, 1.698687797, 29.0, 0.047979438, 1.433525748, 30.0, 0.039111985, 1.207526336, 31.0, 0.031862437, 1.015402928, 32.0, 0.025940415, 0.852465956, 33.0, 0.021106532, 0.714585285, 34.0, 0.017163711, 0.598145851, 35.0, 0.013949904, 0.500000349, 36.0, 0.011332027, 0.41742159, 37.0, 0.009200898, 0.348056286, 38.0, 0.007467036, 0.289881373, 39.0, 0.006057179, 0.241163527, 40.0, 0.004911394, 0.200422214};
    private static final int MAXIMUM_DYNAMIC_QUAL_THRESHOLD_ENTRY_BASEQ = 40;
    private static final int DYNAMIC_QUAL_THRESHOLD_TABLE_ENTRY_LENGTH = 3;
    private static final int DYNAMIC_QUAL_THRESHOLD_TABLE_ENTRY_MEAN_OFFSET = 1;
    private byte[] pcrIndelErrorModelCache;
    private PairHMMInputScoreImputator inputScoreImputator;

    public PairHMMLikelihoodCalculationEngine(byte constantGCP, DragstrParams dragstrParams, PairHMMNativeArguments arguments, PairHMM.Implementation hmmType, double log10globalReadMismappingRate, PCRErrorModel pcrErrorModel) {
        this(constantGCP, dragstrParams, arguments, hmmType, log10globalReadMismappingRate, pcrErrorModel, 18, false, 1.0, 0.02, true, false, true);
    }

    public PairHMMLikelihoodCalculationEngine(byte constantGCP, DragstrParams dragstrParams, PairHMMNativeArguments arguments, PairHMM.Implementation hmmType, double log10globalReadMismappingRate, PCRErrorModel pcrErrorModel, byte baseQualityScoreThreshold, boolean dynamicReadDisqualificaiton, double readDisqualificationScale, double expectedErrorRatePerBase, boolean symmetricallyNormalizeAllelesToReference, boolean disableCapReadQualitiesToMapQ, boolean modifySoftclippedBases) {
        Utils.nonNull(hmmType, "hmmType is null");
        Utils.nonNull(pcrErrorModel, "pcrErrorModel is null");
        if (constantGCP < 0) {
            throw new IllegalArgumentException("gap continuation penalty must be non-negative");
        }
        if (log10globalReadMismappingRate > 0.0) {
            throw new IllegalArgumentException("log10globalReadMismappingRate must be negative");
        }
        this.dragstrParams = dragstrParams;
        this.constantGCP = constantGCP;
        this.log10globalReadMismappingRate = log10globalReadMismappingRate;
        this.pcrErrorModel = this.dragstrParams == null ? pcrErrorModel : PCRErrorModel.NONE;
        this.pairHMM = hmmType.makeNewHMM(arguments);
        this.dynamicDisqualification = dynamicReadDisqualificaiton;
        this.readDisqualificationScale = readDisqualificationScale;
        this.symmetricallyNormalizeAllelesToReference = symmetricallyNormalizeAllelesToReference;
        this.expectedErrorRatePerBase = expectedErrorRatePerBase;
        this.disableCapReadQualitiesToMapQ = disableCapReadQualitiesToMapQ;
        this.modifySoftclippedBases = modifySoftclippedBases;
        this.initializePCRErrorModel();
        if (baseQualityScoreThreshold < 6) {
            throw new IllegalArgumentException("baseQualityScoreThreshold must be greater than or equal to 6 (QualityUtils.MIN_USABLE_Q_SCORE)");
        }
        this.baseQualityScoreThreshold = baseQualityScoreThreshold;
    }

    @Override
    public void close() {
        this.pairHMM.close();
    }

    @Override
    public AlleleLikelihoods<GATKRead, Haplotype> computeReadLikelihoods(AssemblyResultSet assemblyResultSet, SampleList samples, Map<String, List<GATKRead>> perSampleReadList) {
        Utils.nonNull(assemblyResultSet, "assemblyResultSet is null");
        Utils.nonNull(samples, "samples is null");
        Utils.nonNull(perSampleReadList, "perSampleReadList is null");
        List<Haplotype> haplotypeList = assemblyResultSet.getHaplotypeList();
        IndexedAlleleList<Haplotype> haplotypes = new IndexedAlleleList<Haplotype>((Collection<Haplotype>)haplotypeList);
        this.initializePairHMM(haplotypeList, perSampleReadList);
        AlleleLikelihoods<GATKRead, Haplotype> result = new AlleleLikelihoods<GATKRead, Haplotype>(samples, haplotypes, perSampleReadList);
        int sampleCount = result.numberOfSamples();
        for (int i = 0; i < sampleCount; ++i) {
            this.computeReadLikelihoods(result.sampleMatrix(i));
        }
        result.normalizeLikelihoods(this.log10globalReadMismappingRate, this.symmetricallyNormalizeAllelesToReference);
        if (this.dynamicDisqualification) {
            result.filterPoorlyModeledEvidence(this.daynamicLog10MinLiklihoodModel(this.readDisqualificationScale, this.log10MinTrueLikelihood(this.expectedErrorRatePerBase, false)));
        } else {
            result.filterPoorlyModeledEvidence(this.log10MinTrueLikelihood(this.expectedErrorRatePerBase, true));
        }
        return result;
    }

    private ToDoubleFunction<GATKRead> daynamicLog10MinLiklihoodModel(double dynamicRadQualConstant, ToDoubleFunction<GATKRead> log10MinTrueLikelihood) {
        return read -> {
            double log10MaxLikelihoodForTrueAllele;
            double dynamicThreshold = PairHMMLikelihoodCalculationEngine.calculateLog10DynamicReadQualThreshold(read, dynamicRadQualConstant);
            if (dynamicThreshold < (log10MaxLikelihoodForTrueAllele = log10MinTrueLikelihood.applyAsDouble((GATKRead)read))) {
                if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                    HaplotypeCallerGenotypingDebugger.println("For read " + read.getName() + " replacing old threshold (" + log10MaxLikelihoodForTrueAllele + ") with new threshold: " + dynamicThreshold);
                }
                return dynamicThreshold;
            }
            return log10MaxLikelihoodForTrueAllele;
        };
    }

    private static double calculateLog10DynamicReadQualThreshold(GATKRead read, double dynamicReadQualConstant) {
        byte[] baseQualities;
        double sumMean = 0.0;
        double sumVariance = 0.0;
        for (byte qualByte : baseQualities = read.getOptionalTransientAttribute(HMM_BASE_QUALITIES_TAG, byte[].class).orElseGet(read::getBaseQualities)) {
            int bq = 0xFF & qualByte;
            int entryIndex = bq <= 1 ? 0 : Math.min(40, bq) - 1;
            int meanOffset = entryIndex * 3 + 1;
            int varOffset = meanOffset + 1;
            sumMean += dynamicReadQualThreshLookupTable[meanOffset];
            sumVariance += dynamicReadQualThreshLookupTable[varOffset];
        }
        double threshold = sumMean + dynamicReadQualConstant * Math.sqrt(sumVariance);
        return QualityUtils.qualToErrorProbLog10(threshold);
    }

    private ToDoubleFunction<GATKRead> log10MinTrueLikelihood(double maximumErrorPerBase, boolean capLikelihoods) {
        return read -> {
            int qualifiedReadLength = read.getTransientAttribute(HMM_BASE_QUALITIES_TAG) != null ? ((byte[])read.getTransientAttribute(HMM_BASE_QUALITIES_TAG)).length : read.getLength();
            double maxErrorsForRead = capLikelihoods ? Math.min(2.0, Math.ceil((double)qualifiedReadLength * maximumErrorPerBase)) : Math.ceil((double)qualifiedReadLength * maximumErrorPerBase);
            double log10QualPerBase = -4.0;
            return maxErrorsForRead * -4.0;
        };
    }

    private static GATKRead createQualityModifiedRead(GATKRead read, byte[] readBases, byte[] baseQualities, byte[] baseInsertionQualities, byte[] baseDeletionQualities) {
        Utils.validateArg(baseQualities.length == readBases.length && baseInsertionQualities.length == readBases.length && baseDeletionQualities.length == readBases.length, () -> String.format("Read bases and read quality arrays aren't the same size: Bases: %d vs Base Q's: %d vs Insert Q's: %d vs Delete Q's: %d.", readBases.length, baseQualities.length, baseInsertionQualities.length, baseDeletionQualities.length));
        GATKRead processedRead = ReadUtils.emptyRead(read);
        processedRead.setBases(readBases);
        processedRead.setBaseQualities(baseQualities);
        ReadUtils.setInsertionBaseQualities(processedRead, baseInsertionQualities);
        ReadUtils.setDeletionBaseQualities(processedRead, baseDeletionQualities);
        return processedRead;
    }

    private void initializePairHMM(List<Haplotype> haplotypes, Map<String, List<GATKRead>> perSampleReadList) {
        int readMaxLength = perSampleReadList.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).mapToInt(GATKRead::getLength).max().orElse(0);
        int haplotypeMaxLength = haplotypes.stream().mapToInt(h -> h.getBases().length).max().orElse(0);
        this.pairHMM.initialize(haplotypes, perSampleReadList, readMaxLength, haplotypeMaxLength);
    }

    private void computeReadLikelihoods(LikelihoodMatrix<GATKRead, Haplotype> likelihoods) {
        List<GATKRead> processedReads = this.modifyReadQualities(likelihoods.evidence());
        for (int counter = 0; counter < processedReads.size(); ++counter) {
            GATKRead read = processedReads.get(counter);
            if (!HaplotypeCallerGenotypingDebugger.isEnabled()) continue;
            HaplotypeCallerGenotypingDebugger.println("read " + counter + ": " + read.getName() + " cigar: " + read.getCigar() + " mapQ: " + read.getMappingQuality() + " loc: [" + read.getStart() + "-" + read.getEnd() + "] unclippedloc: [" + read.getUnclippedStart() + "-" + read.getUnclippedEnd() + "]");
            HaplotypeCallerGenotypingDebugger.println(Arrays.toString(read.getBaseQualitiesNoCopy()));
        }
        this.pairHMM.computeLog10Likelihoods(likelihoods, processedReads, this.inputScoreImputator);
    }

    private List<GATKRead> modifyReadQualities(List<GATKRead> reads) {
        ArrayList<GATKRead> result = new ArrayList<GATKRead>(reads.size());
        for (GATKRead read : reads) {
            GATKRead maybeUnclipped = this.modifySoftclippedBases ? read : ReadClipper.hardClipSoftClippedBases(read);
            byte[] readBases = maybeUnclipped.getBases();
            byte[] readQuals = (byte[])maybeUnclipped.getBaseQualities().clone();
            byte[] readInsQuals = (byte[])ReadUtils.getBaseInsertionQualities(maybeUnclipped).clone();
            byte[] readDelQuals = (byte[])ReadUtils.getBaseDeletionQualities(maybeUnclipped).clone();
            this.applyPCRErrorModel(readBases, readInsQuals, readDelQuals);
            PairHMMLikelihoodCalculationEngine.capMinimumReadQualities(maybeUnclipped, readQuals, readInsQuals, readDelQuals, this.baseQualityScoreThreshold, this.disableCapReadQualitiesToMapQ);
            read.setTransientAttribute(HMM_BASE_QUALITIES_TAG, readQuals);
            result.add(PairHMMLikelihoodCalculationEngine.createQualityModifiedRead(maybeUnclipped, readBases, readQuals, readInsQuals, readDelQuals));
        }
        return result;
    }

    private static void capMinimumReadQualities(GATKRead read, byte[] readQuals, byte[] readInsQuals, byte[] readDelQuals, byte baseQualityScoreThreshold, boolean disableCapReadQualitiesToMapQ) {
        for (int i = 0; i < readQuals.length; ++i) {
            if (!disableCapReadQualitiesToMapQ) {
                readQuals[i] = (byte)Math.min(0xFF & readQuals[i], read.getMappingQuality());
            }
            readQuals[i] = PairHMMLikelihoodCalculationEngine.setToFixedValueIfTooLow(readQuals[i], baseQualityScoreThreshold, (byte)6);
            readInsQuals[i] = PairHMMLikelihoodCalculationEngine.setToFixedValueIfTooLow(readInsQuals[i], (byte)6, (byte)6);
            readDelQuals[i] = PairHMMLikelihoodCalculationEngine.setToFixedValueIfTooLow(readDelQuals[i], (byte)6, (byte)6);
        }
    }

    private static byte setToFixedValueIfTooLow(byte currentVal, byte minQual, byte fixedQual) {
        return currentVal < minQual ? fixedQual : currentVal;
    }

    private static Map<GATKRead, byte[]> buildGapContinuationPenalties(List<GATKRead> reads, byte gapPenalty) {
        HashMap<GATKRead, byte[]> result = new HashMap<GATKRead, byte[]>(reads.size());
        reads.stream().forEach(read -> result.put((GATKRead)read, Utils.dupBytes(gapPenalty, read.getLength())));
        return result;
    }

    private void initializePCRErrorModel() {
        PairHMMInputScoreImputator pairHMMInputScoreImputator = this.inputScoreImputator = this.dragstrParams == null ? StandardPairHMMInputScoreImputator.newInstance(this.constantGCP) : DragstrPairHMMInputScoreImputator.of(this.dragstrParams);
        if (!this.pcrErrorModel.hasRateFactor()) {
            return;
        }
        this.pcrIndelErrorModelCache = new byte[21];
        double rateFactor = this.pcrErrorModel.getRateFactor();
        for (int i = 0; i <= 20; ++i) {
            this.pcrIndelErrorModelCache[i] = PairHMMLikelihoodCalculationEngine.getErrorModelAdjustedQual(i, rateFactor);
        }
    }

    static byte getErrorModelAdjustedQual(int repeatLength, double rateFactor) {
        return (byte)Math.max(10, MathUtils.fastRound(40.0 - Math.exp((double)repeatLength / (rateFactor * Math.PI)) + 1.0));
    }

    @VisibleForTesting
    void applyPCRErrorModel(byte[] readBases, byte[] readInsQuals, byte[] readDelQuals) {
        if (this.pcrErrorModel == PCRErrorModel.NONE) {
            return;
        }
        for (int i = 1; i < readBases.length; ++i) {
            int repeatLength = (Integer)PairHMMLikelihoodCalculationEngine.findTandemRepeatUnits(readBases, i - 1).getRight();
            readInsQuals[i - 1] = (byte)Math.min(0xFF & readInsQuals[i - 1], 0xFF & this.pcrIndelErrorModelCache[repeatLength]);
            readDelQuals[i - 1] = (byte)Math.min(0xFF & readDelQuals[i - 1], 0xFF & this.pcrIndelErrorModelCache[repeatLength]);
        }
    }

    @VisibleForTesting
    static Pair<byte[], Integer> findTandemRepeatUnits(byte[] readBases, int offset) {
        int maxBW = 0;
        byte[] bestBWRepeatUnit = new byte[]{readBases[offset]};
        for (int str = 1; str <= 8 && offset + 1 - str >= 0; ++str) {
            maxBW = GATKVariantContextUtils.findNumberOfRepetitions(readBases, offset - str + 1, str, readBases, 0, offset + 1, false);
            if (maxBW <= 1) continue;
            bestBWRepeatUnit = Arrays.copyOfRange(readBases, offset - str + 1, offset + 1);
            break;
        }
        byte[] bestRepeatUnit = bestBWRepeatUnit;
        int maxRL = maxBW;
        if (offset < readBases.length - 1) {
            byte[] bestFWRepeatUnit = new byte[]{readBases[offset + 1]};
            int maxFW = 0;
            for (int str = 1; str <= 8 && offset + str + 1 <= readBases.length; ++str) {
                maxFW = GATKVariantContextUtils.findNumberOfRepetitions(readBases, offset + 1, str, readBases, offset + 1, readBases.length - offset - 1, true);
                if (maxFW <= 1) continue;
                bestFWRepeatUnit = Arrays.copyOfRange(readBases, offset + 1, offset + str + 1);
                break;
            }
            if (Arrays.equals(bestFWRepeatUnit, bestBWRepeatUnit)) {
                maxRL = maxBW + maxFW;
                bestRepeatUnit = bestFWRepeatUnit;
            } else {
                byte[] testString = Arrays.copyOfRange(readBases, 0, offset + 1);
                maxBW = GATKVariantContextUtils.findNumberOfRepetitions(bestFWRepeatUnit, testString, false);
                maxRL = maxFW + maxBW;
                bestRepeatUnit = bestFWRepeatUnit;
            }
        }
        if (maxRL > 20) {
            maxRL = 20;
        }
        return Pair.of((Object)bestRepeatUnit, (Object)maxRL);
    }

    public static enum PCRErrorModel {
        NONE(0.0),
        HOSTILE(1.0),
        AGGRESSIVE(2.0),
        CONSERVATIVE(3.0);

        private final double rateFactor;

        private PCRErrorModel(double rateFactor) {
            this.rateFactor = rateFactor;
        }

        public double getRateFactor() {
            return this.rateFactor;
        }

        public boolean hasRateFactor() {
            return this.rateFactor != 0.0;
        }
    }
}

