/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadErrorCorrector;
import org.broadinstitute.hellbender.tools.walkers.mutect.Mutect2Engine;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.DownsamplingMethod;
import org.broadinstitute.hellbender.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class PileupReadErrorCorrector
implements ReadErrorCorrector {
    private final double logOddsThreshold;
    private final SAMFileHeader header;
    private final List<Byte> altQualBuffer = new ArrayList<Byte>();
    private static final byte GOOD_QUAL = 30;
    private static final int INDEL_SPAN = 15;
    private static final int INDEL_MISMATCHES = 3;

    public PileupReadErrorCorrector(double logOddsThreshold, SAMFileHeader header) {
        this.logOddsThreshold = logOddsThreshold;
        this.header = header;
    }

    @Override
    public final List<GATKRead> correctReads(Collection<GATKRead> originalReads) {
        List<GATKRead> reads = originalReads.stream().map(GATKRead::deepCopy).collect(Collectors.toList());
        LocusIteratorByState locusIterator = new LocusIteratorByState(reads.iterator(), DownsamplingMethod.NONE, false, ReadUtils.getSamplesFromHeader(this.header), this.header, false);
        Map<GATKRead, List> potentialCorrections = reads.stream().collect(Collectors.toMap(read -> read, read -> new ArrayList()));
        Utils.stream(locusIterator).map(AlignmentContext::getBasePileup).forEach(pileup -> {
            Nucleotide.Counter counter = new Nucleotide.Counter();
            pileup.forEach(pe -> counter.add(pe.getBase()));
            Optional<Nucleotide> pluralityBase = Nucleotide.STANDARD_BASES.stream().max(Comparator.comparingLong(counter::get));
            if (!pluralityBase.isPresent()) {
                return;
            }
            byte ref = pluralityBase.get().encodeAsByte();
            this.altQualBuffer.clear();
            int refCount = 0;
            for (PileupElement pe2 : pileup) {
                if (pe2.getBase() == ref) {
                    ++refCount;
                    continue;
                }
                this.altQualBuffer.add(pe2.getQual());
            }
            double logOdds = Mutect2Engine.logLikelihoodRatio(refCount, this.altQualBuffer);
            if (logOdds < this.logOddsThreshold) {
                for (PileupElement pe3 : pileup) {
                    if (pe3.getBase() == ref || pe3.isDeletion() || pe3.isBeforeInsertion() || pe3.isAfterDeletionEnd() || pe3.isBeforeDeletionStart() || pe3.isAfterInsertion() || pe3.isAfterSoftClip()) continue;
                    ((List)potentialCorrections.get(pe3.getRead())).add(ImmutablePair.of((Object)pe3.getOffset(), (Object)ref));
                }
            }
        });
        potentialCorrections.entrySet().forEach(entry -> {
            int n;
            GATKRead read = (GATKRead)entry.getKey();
            byte[] bases = read.getBasesNoCopy();
            int length = bases.length;
            byte[] quals = read.getBaseQualitiesNoCopy();
            List edits = (List)entry.getValue();
            int size = edits.size();
            int firstEdit = 0;
            int n2 = 0;
            while (n2 + 3 < size && (Integer)((Pair)edits.get(n2 + 3 - 1)).getLeft() - (Integer)((Pair)edits.get(n2)).getLeft() < 15) {
                firstEdit = n2 + 3;
                ++n2;
            }
            int lastEdit = size - 1;
            for (n = size - 1; n >= 2 && (Integer)((Pair)edits.get(n)).getLeft() - (Integer)((Pair)edits.get(n - 3 + 1)).getLeft() < 15; --n) {
                lastEdit = n - 3;
            }
            for (n = firstEdit; n <= lastEdit; ++n) {
                bases[((Integer)((Pair)edits.get((int)n)).getLeft()).intValue()] = (Byte)((Pair)edits.get(n)).getRight();
                quals[((Integer)((Pair)edits.get((int)n)).getLeft()).intValue()] = 30;
            }
        });
        return reads;
    }
}

