/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;
import org.broadinstitute.hellbender.utils.MathUtils;

public abstract class ReadThreadingAssemblerArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_PRUNING_LOG_ODDS_THRESHOLD = MathUtils.log10ToLog(1.0);
    public static final double DEFAULT_PRUNING_SEEDING_LOG_ODDS_THRESHOLD = MathUtils.log10ToLog(4.0);
    public static final String ERROR_CORRECT_READS_LONG_NAME = "error-correct-reads";
    public static final String PILEUP_ERROR_CORRECTION_LOG_ODDS_NAME = "error-correction-log-odds";
    public static final String CAPTURE_ASSEMBLY_FAILURE_BAM_LONG_NAME = "capture-assembly-failure-bam";
    public static final String KMER_SIZE_LONG_NAME = "kmer-size";
    public static final String DONT_INCREASE_KMER_SIZE_LONG_NAME = "dont-increase-kmer-sizes-for-cycles";
    public static final String LINKED_DE_BRUIJN_GRAPH_LONG_NAME = "linked-de-bruijn-graph";
    @Advanced
    @Argument(fullName="kmer-size", doc="Kmer size to use in the read threading assembler", optional=true)
    public List<Integer> kmerSizes = Lists.newArrayList((Object[])new Integer[]{10, 25});
    @Advanced
    @Argument(fullName="dont-increase-kmer-sizes-for-cycles", doc="Disable iterating over kmer sizes when graph cycles are detected", optional=true)
    public boolean dontIncreaseKmerSizesForCycles = false;
    @Advanced
    @Argument(fullName="allow-non-unique-kmers-in-ref", doc="Allow graphs that have non-unique kmers in the reference", optional=true)
    public boolean allowNonUniqueKmersInRef = false;
    @Advanced
    @Argument(fullName="num-pruning-samples", doc="Number of samples that must pass the minPruning threshold", optional=true)
    public int numPruningSamples = 1;
    @Advanced
    @Argument(fullName="min-dangling-branch-length", doc="Minimum length of a dangling branch to attempt recovery", optional=true)
    public int minDanglingBranchLength = 4;
    @Advanced
    @Argument(fullName="recover-all-dangling-branches", doc="Recover all dangling branches", optional=true)
    public boolean recoverAllDanglingBranches = false;
    @Advanced
    @Argument(fullName="max-num-haplotypes-in-population", doc="Maximum number of haplotypes to consider for your population", optional=true)
    public int maxNumHaplotypesInPopulation = 128;
    @Advanced
    @Argument(fullName="min-pruning", doc="Minimum support to not prune paths in the graph", optional=true)
    public int minPruneFactor = 2;
    @Advanced
    @Argument(fullName="adaptive-pruning-initial-error-rate", doc="Initial base error rate estimate for adaptive pruning", optional=true)
    public double initialErrorRateForPruning = 0.001;
    @Advanced
    @Argument(fullName="pruning-lod-threshold", doc="Ln likelihood ratio threshold for adaptive pruning algorithm", optional=true)
    public double pruningLogOddsThreshold = DEFAULT_PRUNING_LOG_ODDS_THRESHOLD;
    @Advanced
    @Argument(fullName="pruning-seeding-lod-threshold", doc="Ln likelihood ratio threshold for seeding subgraph of good variation in adaptive pruning algorithm", optional=true)
    public double pruningSeedingLogOddsThreshold = DEFAULT_PRUNING_SEEDING_LOG_ODDS_THRESHOLD;
    @Advanced
    @Argument(fullName="max-unpruned-variants", doc="Maximum number of variants in graph the adaptive pruner will allow", optional=true)
    public int maxUnprunedVariants = 100;
    @Advanced
    @Argument(fullName="linked-de-bruijn-graph", doc="If enabled, the Assembly Engine will construct a Linked De Bruijn graph to recover better haplotypes", optional=true)
    public boolean useLinkedDeBruijnGraph = false;
    @Hidden
    @Argument(fullName="disable-artificial-haplotype-recovery", doc="If in 'linked-de-bruijn-graph' mode, disable recovery of haplotypes based on graph edges that are not in junction trees", optional=true)
    public boolean disableArtificialHaplotypeRecovery = false;
    @Hidden
    @Argument(fullName="enable-legacy-graph-cycle-detection", doc="Use to revert the change to assembly graph code that moved pruning to before cycle detection")
    public boolean enableLegacyGraphCycleDetection = false;
    @Advanced
    @Argument(fullName="debug-assembly", shortName="debug", doc="Print out verbose debug information about each assembly region", optional=true)
    public boolean debugAssembly;
    @Hidden
    @Argument(fullName="debug-graph-transformations", doc="Write DOT formatted graph files out of the assembler for only this graph size", optional=true)
    public boolean debugGraphTransformations = false;
    @Argument(fullName="graph-output", shortName="graph", doc="Write debug assembly graph information to this file", optional=true)
    public String graphOutput = null;
    @Hidden
    @Argument(fullName="haplotype-debug-histogram-output", doc="Write debug assembly graph information to this file", optional=true)
    public String haplotypeHistogramOutput = null;
    @Hidden
    @Argument(fullName="capture-assembly-failure-bam", doc="Write a BAM called assemblyFailure.bam capturing all of the reads that were in the active region when the assembler failed for any reason", optional=true)
    public boolean captureAssemblyFailureBAM = false;
    @Hidden
    @Argument(fullName="num-matching-bases-in-dangling-end-to-recover", doc="Sets the number of exactly matching bases in the suffix of a dangling tail and the prefix for a dangling head necessary in order to recover the path. (-1 indicates legacy behavior)", optional=true)
    public int minMatchingBasesToDanglingEndRecovery = -1;
    @Hidden
    @Argument(fullName="error-correction-log-odds", doc="Log odds threshold for pileup error correction.  Off by default", optional=true)
    public double pileupErrorCorrectionLogOdds = Double.NEGATIVE_INFINITY;
    @Hidden
    @Argument(fullName="error-correct-reads", doc="Use an exploratory algorithm to error correct the kmers used during assembly", optional=true)
    public boolean errorCorrectReads = false;
    @Hidden
    @Argument(fullName="kmer-length-for-read-error-correction", doc="Use an exploratory algorithm to error correct the kmers used during assembly", optional=true)
    public int kmerLengthForReadErrorCorrection = 25;
    @Hidden
    @Argument(fullName="min-observations-for-kmer-to-be-solid", doc="A k-mer must be seen at least these times for it considered to be solid", optional=true)
    public int minObservationsForKmerToBeSolid = 20;

    public abstract ReadThreadingAssembler makeReadThreadingAssembler();
}

