/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceResult;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class RefVsAnyResult
extends ReferenceConfidenceResult {
    final double[] genotypeLikelihoods;
    int[] finalPhredScaledGenotypeLikelihoods;

    public RefVsAnyResult(int likelihoodCapacity) {
        ParamUtils.isPositiveOrZero(likelihoodCapacity, "likelihood capacity is negative");
        this.genotypeLikelihoods = new double[likelihoodCapacity];
        this.finalPhredScaledGenotypeLikelihoods = new int[likelihoodCapacity];
    }

    double[] getGenotypeLikelihoodsCappedByHomRefLikelihood() {
        double[] output = new double[this.genotypeLikelihoods.length];
        for (int i = 0; i < this.genotypeLikelihoods.length; ++i) {
            output[i] = Math.min(this.genotypeLikelihoods[i], this.genotypeLikelihoods[0]);
        }
        return output;
    }
}

