/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.tools.walkers.genotyper.PloidyModel;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.RefVsAnyResult;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceResult;
import org.broadinstitute.hellbender.tools.walkers.variantutils.PosteriorProbabilitiesUtils;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class ReferenceConfidenceModel {
    public static final String INDEL_INFORMATIVE_BASES_CACHE_ATTRIBUTE_NAME = "IDL";
    public static final boolean USE_CACHED_READ_INDEL_INFORMATIVENESS_VALUES = true;
    private final SampleList samples;
    private final int indelInformativeDepthIndelSize;
    private final int numRefSamplesForPrior;
    @VisibleForTesting
    protected static final String NON_REF_ALLELE_DESCRIPTION = "Represents any possible alternative allele not already represented at this location by REF and ALT";
    private final PosteriorProbabilitiesUtils.PosteriorProbabilitiesOptions options;
    private static final byte REF_MODEL_DELETION_QUAL = 30;
    private static final byte BASE_QUAL_THRESHOLD = 6;
    private static final byte HQ_BASE_QUALITY_SOFTCLIP_THRESHOLD = 28;
    protected static final int MAX_N_INDEL_INFORMATIVE_READS = 40;
    private static final int INITIAL_INDEL_LK_CACHE_PLOIDY_CAPACITY = 20;
    private static GenotypeLikelihoods[][] indelPLCache = new GenotypeLikelihoods[21][];
    private static final double INDEL_ERROR_RATE = -4.5;
    private static final byte INDEL_QUAL = (byte)Math.round(45.0);
    private static final double NO_INDEL_LIKELIHOOD = QualityUtils.qualToProbLog10(INDEL_QUAL);
    private static final double INDEL_LIKELIHOOD = QualityUtils.qualToErrorProbLog10(INDEL_QUAL);
    private static final int IDX_HOM_REF = 0;
    private static final boolean useInputSamplesAlleleCounts = false;
    private static final boolean useMLEAC = true;
    private static final boolean ignoreInputSamplesForMissingVariants = true;
    private static final boolean useFlatPriorsForIndels = false;

    public ReferenceConfidenceModel(SampleList samples, SAMFileHeader header, int indelInformativeDepthIndelSize, int numRefForPrior) {
        Utils.nonNull(samples, "samples cannot be null");
        Utils.validateArg(samples.numberOfSamples() > 0, "samples cannot be empty");
        Utils.nonNull(header, "header cannot be empty");
        Utils.validateArg(indelInformativeDepthIndelSize >= 0, () -> "indelInformativeDepthIndelSize must be >= 1 but got " + indelInformativeDepthIndelSize);
        this.samples = samples;
        this.indelInformativeDepthIndelSize = indelInformativeDepthIndelSize;
        this.numRefSamplesForPrior = numRefForPrior;
        this.options = new PosteriorProbabilitiesUtils.PosteriorProbabilitiesOptions(0.001, 1.25E-4, false, true, true, false);
    }

    public Set<VCFHeaderLine> getVCFHeaderLines() {
        LinkedHashSet<VCFHeaderLine> headerLines = new LinkedHashSet<VCFHeaderLine>();
        headerLines.add((VCFHeaderLine)new VCFSimpleHeaderLine("ALT", "NON_REF", NON_REF_ALLELE_DESCRIPTION));
        return headerLines;
    }

    public List<VariantContext> calculateRefConfidence(Haplotype refHaplotype, Collection<Haplotype> calledHaplotypes, SimpleInterval paddedReferenceLoc, AssemblyRegion activeRegion, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods, PloidyModel ploidyModel, List<VariantContext> variantCalls) {
        return this.calculateRefConfidence(refHaplotype, calledHaplotypes, paddedReferenceLoc, activeRegion, readLikelihoods, ploidyModel, variantCalls, false, Collections.emptyList());
    }

    public List<VariantContext> calculateRefConfidence(Haplotype refHaplotype, Collection<Haplotype> calledHaplotypes, SimpleInterval paddedReferenceLoc, AssemblyRegion activeRegion, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods, PloidyModel ploidyModel, List<VariantContext> variantCalls, boolean applyPriors, List<VariantContext> VCpriors) {
        Utils.nonNull(refHaplotype, "refHaplotype cannot be null");
        Utils.nonNull(calledHaplotypes, "calledHaplotypes cannot be null");
        Utils.validateArg(calledHaplotypes.contains((Object)refHaplotype), "calledHaplotypes must contain the refHaplotype");
        Utils.nonNull(paddedReferenceLoc, "paddedReferenceLoc cannot be null");
        Utils.nonNull(activeRegion, "activeRegion cannot be null");
        Utils.nonNull(readLikelihoods, "readLikelihoods cannot be null");
        Utils.validateArg(readLikelihoods.numberOfSamples() == 1, () -> "readLikelihoods must contain exactly one sample but it contained " + readLikelihoods.numberOfSamples());
        Utils.validateArg(refHaplotype.length() == activeRegion.getPaddedSpan().size(), () -> "refHaplotype " + refHaplotype.length() + " and activeRegion location size " + activeRegion.getSpan().size() + " are different");
        Utils.nonNull(ploidyModel, "the ploidy model cannot be null");
        int ploidy = ploidyModel.samplePloidy(0);
        SimpleInterval refSpan = activeRegion.getSpan();
        List<ReadPileup> refPileups = AssemblyBasedCallerUtils.getPileupsOverReference(activeRegion.getHeader(), refSpan, readLikelihoods, this.samples);
        byte[] ref = refHaplotype.getBases();
        ArrayList<VariantContext> results = new ArrayList<VariantContext>(refSpan.size());
        String sampleName = readLikelihoods.getSample(0);
        int globalRefOffset = refSpan.getStart() - activeRegion.getPaddedSpan().getStart();
        int refPileupsSize = refPileups.size();
        for (int i = 0; i < refPileupsSize; ++i) {
            List<VariantContext> currentPriors;
            ReadPileup pileup = refPileups.get(i);
            Locatable curPos = pileup.getLocation();
            int offset = curPos.getStart() - refSpan.getStart();
            VariantContext overlappingSite = GATKVariantContextUtils.getOverlappingVariantContext(curPos, variantCalls);
            List<VariantContext> list = currentPriors = VCpriors.isEmpty() ? Collections.emptyList() : this.getMatchingPriors(curPos, overlappingSite, VCpriors);
            if (overlappingSite != null && overlappingSite.getStart() == curPos.getStart()) {
                if (applyPriors) {
                    results.add(PosteriorProbabilitiesUtils.calculatePosteriorProbs(overlappingSite, currentPriors, this.numRefSamplesForPrior, this.options));
                    continue;
                }
                results.add(overlappingSite);
                continue;
            }
            results.add(this.makeReferenceConfidenceVariantContext(ploidy, ref, sampleName, globalRefOffset, pileup, curPos, offset, applyPriors, currentPriors));
        }
        readLikelihoods.sampleEvidence(0).forEach(r -> r.clearTransientAttribute(INDEL_INFORMATIVE_BASES_CACHE_ATTRIBUTE_NAME));
        return results;
    }

    public VariantContext makeReferenceConfidenceVariantContext(int ploidy, byte[] ref, String sampleName, int globalRefOffset, ReadPileup pileup, Locatable curPos, int offset, boolean applyPriors, List<VariantContext> VCpriors) {
        int refOffset = offset + globalRefOffset;
        byte refBase = ref[refOffset];
        ReferenceConfidenceResult homRefCalc = this.calcGenotypeLikelihoodsOfRefVsAny(ploidy, pileup, refBase, (byte)6, null, true);
        Allele refAllele = Allele.create((byte)refBase, (boolean)true);
        List<Allele> refSiteAlleles = Arrays.asList(refAllele, Allele.NON_REF_ALLELE);
        VariantContextBuilder vcb = new VariantContextBuilder("HC", curPos.getContig(), (long)curPos.getStart(), (long)curPos.getStart(), refSiteAlleles);
        GenotypeBuilder gb = new GenotypeBuilder(sampleName, GATKVariantContextUtils.homozygousAlleleList(refAllele, ploidy));
        gb.AD(homRefCalc.getAD());
        gb.DP(homRefCalc.getDP());
        this.doIndelRefConfCalc(ploidy, ref, pileup, refOffset, homRefCalc);
        this.addGenotypeData(homRefCalc, gb);
        if (!applyPriors) {
            return vcb.genotypes(new Genotype[]{gb.make()}).make();
        }
        return PosteriorProbabilitiesUtils.calculatePosteriorProbs(vcb.genotypes(new Genotype[]{gb.make()}).make(), VCpriors, this.numRefSamplesForPrior, this.options);
    }

    public void doIndelRefConfCalc(int ploidy, byte[] ref, ReadPileup pileup, int refOffset, ReferenceConfidenceResult refResult) {
        RefVsAnyResult homRefCalc = (RefVsAnyResult)refResult;
        GenotypeLikelihoods snpGLs = GenotypeLikelihoods.fromLog10Likelihoods((double[])homRefCalc.getGenotypeLikelihoodsCappedByHomRefLikelihood());
        int nIndelInformativeReads = this.calcNReadsWithNoPlausibleIndelsReads(pileup, refOffset, ref, this.indelInformativeDepthIndelSize);
        GenotypeLikelihoods indelGLs = this.getIndelPLs(ploidy, nIndelInformativeReads);
        GenotypeLikelihoods leastConfidenceGLs = this.getGLwithWorstGQ(indelGLs, snpGLs);
        homRefCalc.finalPhredScaledGenotypeLikelihoods = leastConfidenceGLs.getAsPLs();
    }

    public void addGenotypeData(ReferenceConfidenceResult result, GenotypeBuilder gb) {
        int[] pls = ((RefVsAnyResult)result).finalPhredScaledGenotypeLikelihoods;
        gb.PL(pls);
        gb.GQ(GATKVariantContextUtils.calculateGQFromPLs(pls));
    }

    @VisibleForTesting
    GenotypeLikelihoods getGLwithWorstGQ(GenotypeLikelihoods gl1, GenotypeLikelihoods gl2) {
        if (this.getGQForHomRef(gl1) > this.getGQForHomRef(gl2)) {
            return gl1;
        }
        return gl2;
    }

    private double getGQForHomRef(GenotypeLikelihoods gls) {
        return GenotypeLikelihoods.getGQLog10FromLikelihoods((int)0, (double[])gls.getAsVector());
    }

    @VisibleForTesting
    GenotypeLikelihoods getIndelPLs(int ploidy, int nInformativeReads) {
        return this.indelPLCache(ploidy, nInformativeReads > 40 ? 40 : nInformativeReads);
    }

    private GenotypeLikelihoods indelPLCache(int ploidy, int nInformativeReads) {
        return this.initializeIndelPLCache(ploidy)[nInformativeReads];
    }

    private GenotypeLikelihoods[] initializeIndelPLCache(int ploidy) {
        if (indelPLCache.length <= ploidy) {
            indelPLCache = (GenotypeLikelihoods[][])Arrays.copyOf(indelPLCache, ploidy << 1);
        }
        if (indelPLCache[ploidy] != null) {
            return indelPLCache[ploidy];
        }
        double denominator = -MathUtils.log10(ploidy);
        GenotypeLikelihoods[] result = new GenotypeLikelihoods[41];
        result[0] = GenotypeLikelihoods.fromLog10Likelihoods((double[])new double[ploidy + 1]);
        for (int nInformativeReads = 1; nInformativeReads <= 40; ++nInformativeReads) {
            double[] PLs = new double[ploidy + 1];
            PLs[0] = (double)nInformativeReads * NO_INDEL_LIKELIHOOD;
            for (int altCount = 1; altCount <= ploidy; ++altCount) {
                double refLikelihoodAccum = NO_INDEL_LIKELIHOOD + MathUtils.log10(ploidy - altCount);
                double altLikelihoodAccum = INDEL_LIKELIHOOD + MathUtils.log10(altCount);
                PLs[altCount] = (double)nInformativeReads * (MathUtils.approximateLog10SumLog10(refLikelihoodAccum, altLikelihoodAccum) + denominator);
            }
            result[nInformativeReads] = GenotypeLikelihoods.fromLog10Likelihoods((double[])PLs);
        }
        ReferenceConfidenceModel.indelPLCache[ploidy] = result;
        return result;
    }

    public ReferenceConfidenceResult calcGenotypeLikelihoodsOfRefVsAny(int ploidy, ReadPileup pileup, byte refBase, byte minBaseQual, MathUtils.RunningAverage hqSoftClips, boolean readsWereRealigned) {
        int likelihoodCount = ploidy + 1;
        double log10Ploidy = MathUtils.log10(ploidy);
        RefVsAnyResult result = new RefVsAnyResult(likelihoodCount);
        int readCount = 0;
        for (PileupElement p : pileup) {
            byte qual;
            byte by = qual = p.isDeletion() ? (byte)30 : (byte)p.getQual();
            if (!p.isDeletion() && qual <= minBaseQual) continue;
            ++readCount;
            this.applyPileupElementRefVsNonRefLikelihoodAndCount(refBase, likelihoodCount, log10Ploidy, result, p, qual, hqSoftClips, readsWereRealigned);
        }
        double denominator = (double)readCount * log10Ploidy;
        int i = 0;
        while (i < likelihoodCount) {
            int n = i++;
            result.genotypeLikelihoods[n] = result.genotypeLikelihoods[n] - denominator;
        }
        return result;
    }

    private void applyPileupElementRefVsNonRefLikelihoodAndCount(byte refBase, int likelihoodCount, double log10Ploidy, RefVsAnyResult result, PileupElement element, byte qual, MathUtils.RunningAverage hqSoftClips, boolean readsWereRealigned) {
        double referenceLikelihood;
        double nonRefLikelihood;
        boolean isAlt;
        boolean bl = isAlt = readsWereRealigned ? ReferenceConfidenceModel.isAltAfterAssembly(element, refBase) : ReferenceConfidenceModel.isAltBeforeAssembly(element, refBase);
        if (isAlt) {
            nonRefLikelihood = QualityUtils.qualToProbLog10(qual);
            referenceLikelihood = QualityUtils.qualToErrorProbLog10(qual) + MathUtils.LOG10_ONE_THIRD;
            ++result.nonRefDepth;
        } else {
            referenceLikelihood = QualityUtils.qualToProbLog10(qual);
            nonRefLikelihood = QualityUtils.qualToErrorProbLog10(qual) + MathUtils.LOG10_ONE_THIRD;
            ++result.refDepth;
        }
        result.genotypeLikelihoods[0] = result.genotypeLikelihoods[0] + (referenceLikelihood + log10Ploidy);
        int n = likelihoodCount - 1;
        result.genotypeLikelihoods[n] = result.genotypeLikelihoods[n] + (nonRefLikelihood + log10Ploidy);
        int i = 1;
        int j = likelihoodCount - 2;
        while (i < likelihoodCount - 1) {
            int n2 = i;
            result.genotypeLikelihoods[n2] = result.genotypeLikelihoods[n2] + MathUtils.approximateLog10SumLog10(referenceLikelihood + MathUtils.log10(j), nonRefLikelihood + MathUtils.log10(i));
            ++i;
            --j;
        }
        if (isAlt && hqSoftClips != null && element.isNextToSoftClip()) {
            hqSoftClips.add(AlignmentUtils.countHighQualitySoftClips(element.getRead(), (byte)28));
        }
    }

    protected static boolean isAltBeforeAssembly(PileupElement element, byte refBase) {
        return element.getBase() != refBase || element.isDeletion() || element.isBeforeDeletionStart() || element.isAfterDeletionEnd() || element.isBeforeInsertion() || element.isAfterInsertion() || element.isNextToSoftClip();
    }

    protected static boolean isAltAfterAssembly(PileupElement element, byte refBase) {
        return element.getBase() != refBase || element.isDeletion();
    }

    private List<VariantContext> getMatchingPriors(Locatable curPos, VariantContext call, List<VariantContext> priorList) {
        int position = call != null ? call.getStart() : curPos.getStart();
        ArrayList<VariantContext> matchedPriors = new ArrayList<VariantContext>(priorList.size());
        int priorsListSize = priorList.size();
        for (int i = 0; i < priorsListSize; ++i) {
            if (position != priorList.get(i).getStart()) continue;
            matchedPriors.add(priorList.get(i));
        }
        return matchedPriors;
    }

    private static int[] calculateBaselineMMQualities(byte[] readBases, byte[] readQuals, int readStart, byte[] refBases, int refStart) {
        int n = Math.min(readBases.length - readStart, refBases.length - refStart);
        int[] results = new int[n];
        int sum = 0;
        for (int i = n - 1; i >= 0; --i) {
            byte readBase = readBases[readStart + i];
            byte refBase = refBases[refStart + i];
            if (ReferenceConfidenceModel.isMismatchAndNotAnAlignmentGap(readBase, refBase)) {
                sum += readQuals[readStart + i];
            }
            results[i] = sum;
        }
        return results;
    }

    private static boolean readHasNoPlausibleIdealsOfSize(GATKRead read, int readStart, byte[] refBases, int refStart, int maxIndelSize, boolean useCachedResults) {
        BitSet cachedResult = (BitSet)read.getTransientAttribute(INDEL_INFORMATIVE_BASES_CACHE_ATTRIBUTE_NAME);
        if (cachedResult == null || !useCachedResults) {
            Utils.validate(readStart >= 0, "readStart must >= 0");
            Utils.validate(refStart >= 0, "refStart must >= 0");
            BitSet informativeBases = new BitSet(read.getLength());
            if (read.getLength() - readStart >= maxIndelSize && refBases.length - refStart >= maxIndelSize) {
                int secondaryReadBreakPosition = read.getLength() - maxIndelSize;
                Pair<byte[], byte[]> readBasesAndBaseQualities = AlignmentUtils.getBasesAndBaseQualitiesAlignedOneToOne(read);
                byte[] readBases = (byte[])readBasesAndBaseQualities.getLeft();
                byte[] readQualities = (byte[])readBasesAndBaseQualities.getRight();
                if (readBases.length - readStart > maxIndelSize) {
                    boolean referenceWasShorter;
                    int lastReadBaseToMarkAsIndelRelevant;
                    if (readBases.length < refBases.length - refStart + readStart + 1) {
                        lastReadBaseToMarkAsIndelRelevant = readBases.length - maxIndelSize;
                        referenceWasShorter = false;
                    } else {
                        lastReadBaseToMarkAsIndelRelevant = refBases.length - refStart + readStart - maxIndelSize + 1;
                        referenceWasShorter = true;
                    }
                    int[] baselineMisMatchSums = ReferenceConfidenceModel.calculateBaselineMMQualities(readBases, readQualities, readStart, refBases, refStart);
                    for (int indelSize = 1; indelSize <= maxIndelSize; ++indelSize) {
                        ReferenceConfidenceModel.traverseEndOfReadForIndelMismatches(informativeBases, readStart, readBases, readQualities, lastReadBaseToMarkAsIndelRelevant, secondaryReadBreakPosition, refStart, refBases, baselineMisMatchSums, indelSize, false);
                        ReferenceConfidenceModel.traverseEndOfReadForIndelMismatches(informativeBases, readStart, readBases, readQualities, lastReadBaseToMarkAsIndelRelevant, secondaryReadBreakPosition, refStart, refBases, baselineMisMatchSums, indelSize, true);
                    }
                    if (lastReadBaseToMarkAsIndelRelevant <= secondaryReadBreakPosition) {
                        informativeBases.flip(0, lastReadBaseToMarkAsIndelRelevant);
                        if (referenceWasShorter) {
                            informativeBases.set(lastReadBaseToMarkAsIndelRelevant - 1, false);
                        }
                    } else {
                        informativeBases.flip(0, secondaryReadBreakPosition + 1);
                    }
                }
            }
            cachedResult = informativeBases;
            read.setTransientAttribute(INDEL_INFORMATIVE_BASES_CACHE_ATTRIBUTE_NAME, informativeBases);
        }
        return cachedResult.get(readStart);
    }

    private static void traverseEndOfReadForIndelMismatches(BitSet informativeBases, int readStart, byte[] readBases, byte[] readQuals, int lastReadBaseToMarkAsIndelRelevant, int secondaryReadBreakPosition, int refStart, byte[] refBases, int[] baselineMMSums, int indelSize, boolean insertion) {
        byte refBase;
        byte readBase;
        int globalMismatchCostForReadAlignedToReference = baselineMMSums[0];
        int baseQualitySum = 0;
        int insertionLength = !insertion ? 0 : indelSize;
        int deletionLength = insertion ? 0 : indelSize;
        int numberOfBasesToDirectlyCompare = Math.min(readBases.length - readStart - insertionLength, refBases.length - refStart - deletionLength);
        int readOffset = numberOfBasesToDirectlyCompare + insertionLength - 1;
        for (int refOffset = numberOfBasesToDirectlyCompare + deletionLength - 1; !(readOffset < 0 || refOffset < 0 || ReferenceConfidenceModel.isMismatchAndNotAnAlignmentGap(readBase = readBases[readStart + readOffset], refBase = refBases[refStart + refOffset]) && (baseQualitySum += readQuals[readStart + readOffset]) > globalMismatchCostForReadAlignedToReference); --readOffset, --refOffset) {
            int siteOfRealComparisonPoint = Math.min(readOffset, refOffset);
            if (readBases[readStart + siteOfRealComparisonPoint] == 45 || readStart + siteOfRealComparisonPoint >= lastReadBaseToMarkAsIndelRelevant || readStart + siteOfRealComparisonPoint > secondaryReadBreakPosition || baselineMMSums[siteOfRealComparisonPoint] < baseQualitySum) continue;
            informativeBases.set(readStart + siteOfRealComparisonPoint, true);
        }
    }

    private static boolean isMismatchAndNotAnAlignmentGap(byte readBase, byte refBase) {
        return !Nucleotide.intersect(readBase, refBase) && readBase != 45;
    }

    @VisibleForTesting
    int calcNReadsWithNoPlausibleIndelsReads(ReadPileup pileup, int pileupOffsetIntoRef, byte[] ref, int maxIndelSize) {
        int nInformative = 0;
        for (PileupElement p : pileup) {
            if (p.isBeforeDeletionStart() || p.isBeforeInsertion() || p.isDeletion()) continue;
            int offset = this.getCigarModifiedOffset(p);
            if (!ReferenceConfidenceModel.readHasNoPlausibleIdealsOfSize(p.getRead(), offset, ref, pileupOffsetIntoRef, maxIndelSize, true) || ++nInformative <= 40) continue;
            return 40;
        }
        return nInformative;
    }

    @VisibleForTesting
    protected int getCigarModifiedOffset(PileupElement p) {
        GATKRead read = p.getRead();
        int offset = p.getCurrentCigarElement().getOperator().consumesReferenceBases() || p.getCurrentCigarElement().getOperator() == CigarOperator.S ? p.getOffsetInCurrentCigar() : 0;
        for (int i = 0; i < p.getCurrentCigarOffset(); ++i) {
            CigarElement elem = read.getCigarElement(i);
            if (!elem.getOperator().consumesReferenceBases() && elem.getOperator() != CigarOperator.S) continue;
            offset += elem.getLength();
        }
        return offset;
    }

    public static Haplotype createReferenceHaplotype(AssemblyRegion activeRegion, byte[] refBases, SimpleInterval paddedReferenceLoc) {
        Utils.nonNull(activeRegion, "null region");
        Utils.nonNull(refBases, "null refBases");
        Utils.nonNull(paddedReferenceLoc, "null paddedReferenceLoc");
        int alignmentStart = activeRegion.getPaddedSpan().getStart() - paddedReferenceLoc.getStart();
        if (alignmentStart < 0) {
            throw new IllegalStateException("Bad alignment start in createReferenceHaplotype " + alignmentStart);
        }
        Haplotype refHaplotype = new Haplotype(refBases, true);
        refHaplotype.setAlignmentStartHapwrtRef(alignmentStart);
        Cigar c = new Cigar();
        c.add(new CigarElement(refHaplotype.getBases().length, CigarOperator.M));
        refHaplotype.setCigar(c);
        return refHaplotype;
    }
}

