/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller;

import java.util.Arrays;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputation;
import org.broadinstitute.hellbender.utils.pairhmm.PairHMMInputScoreImputator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public class StandardPairHMMInputScoreImputator
implements PairHMMInputScoreImputator {
    private final byte constantGCP;

    private StandardPairHMMInputScoreImputator(byte constantGCP) {
        this.constantGCP = constantGCP;
    }

    public static StandardPairHMMInputScoreImputator newInstance(byte constantGCP) {
        return new StandardPairHMMInputScoreImputator(constantGCP);
    }

    @Override
    public PairHMMInputScoreImputation impute(final GATKRead read) {
        return new PairHMMInputScoreImputation(){

            @Override
            public byte[] delOpenPenalties() {
                return ReadUtils.getBaseDeletionQualities(read);
            }

            @Override
            public byte[] insOpenPenalties() {
                return ReadUtils.getBaseInsertionQualities(read);
            }

            @Override
            public byte[] gapContinuationPenalties() {
                byte[] result = new byte[read.getLength()];
                Arrays.fill(result, StandardPairHMMInputScoreImputator.this.constantGCP);
                return result;
            }
        };
    }
}

