/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Collection;
import java.util.Comparator;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class BaseEdge {
    private int multiplicity;
    private boolean isRef;
    public static final Comparator<BaseEdge> EDGE_MULTIPLICITY_ORDER = Comparator.comparingInt(BaseEdge::getMultiplicity).reversed();

    public BaseEdge(boolean isRef, int multiplicity) {
        Utils.validateArg(multiplicity >= 0, () -> "multiplicity must be >= 0 but got " + multiplicity);
        this.multiplicity = multiplicity;
        this.isRef = isRef;
    }

    public BaseEdge copy() {
        return new BaseEdge(this.isRef(), this.getMultiplicity());
    }

    public final int getMultiplicity() {
        return this.multiplicity;
    }

    public String getDotLabel() {
        return Integer.toString(this.getMultiplicity());
    }

    public void incMultiplicity(int incr) {
        Utils.validateArg(incr >= 0, () -> "incr must be >= 0 but got " + incr);
        this.multiplicity += incr;
    }

    public int getPruningMultiplicity() {
        return this.getMultiplicity();
    }

    public final void setMultiplicity(int value) {
        ParamUtils.isPositiveOrZero(this.multiplicity, "multiplicity must be >= 0");
        this.multiplicity = value;
    }

    public final boolean isRef() {
        return this.isRef;
    }

    public final void setIsRef(boolean isRef) {
        this.isRef = isRef;
    }

    public final BaseEdge add(BaseEdge edge) {
        Utils.nonNull(edge, "edge cannot be null");
        this.multiplicity += edge.getMultiplicity();
        this.isRef = this.isRef || edge.isRef();
        return this;
    }

    public static BaseEdge makeOREdge(Collection<BaseEdge> edges, int multiplicity) {
        Utils.nonNull(edges);
        boolean anyRef = edges.stream().anyMatch(e -> e.isRef());
        return new BaseEdge(anyRef, multiplicity);
    }

    public final String toString() {
        return String.format("BaseEdge{multiplicity=%d, isRef=%b}", this.multiplicity, this.isRef);
    }
}

