/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.broadinstitute.hellbender.utils.Utils;

public class BaseVertex {
    private String additionalInfo = "";
    protected final byte[] sequence;
    private final int cachedHashCode;

    public BaseVertex(byte[] sequence) {
        Utils.nonNull(sequence, "Sequence cannot be null");
        this.sequence = sequence;
        this.cachedHashCode = Arrays.hashCode(sequence);
    }

    @VisibleForTesting
    BaseVertex(String sequence) {
        this(sequence.getBytes());
    }

    public final boolean isEmpty() {
        return this.length() == 0;
    }

    public final int length() {
        return this.sequence.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseVertex that = (BaseVertex)o;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        return this.seqEquals(that);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public final boolean seqEquals(BaseVertex b) {
        return Arrays.equals(this.getSequence(), b.getSequence());
    }

    public String toString() {
        return this.getSequenceString();
    }

    public final byte[] getSequence() {
        return this.sequence;
    }

    public final String getSequenceString() {
        return new String(this.sequence);
    }

    public byte[] getAdditionalSequence(boolean source) {
        return this.getSequence();
    }

    public final void setAdditionalInfo(String info) {
        Utils.nonNull(info, "info cannot be null");
        this.additionalInfo = info;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public final boolean hasAmbiguousSequence() {
        block3: for (byte base : this.sequence) {
            switch (Character.toUpperCase(base)) {
                case 65: 
                case 67: 
                case 71: 
                case 84: {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }
}

