/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.Path;

public abstract class ChainPruner<V extends BaseVertex, E extends BaseEdge> {
    public void pruneLowWeightChains(BaseGraph<V, E> graph) {
        List<Path<V, E>> chains = this.findAllChains(graph);
        Collection<Path<V, E>> chainsToRemove = this.chainsToRemove(chains);
        chainsToRemove.forEach(c -> graph.removeAllEdges(c.getEdges()));
        graph.removeSingletonOrphanVertices();
    }

    @VisibleForTesting
    List<Path<V, E>> findAllChains(BaseGraph<V, E> graph) {
        LinkedList<V> chainStarts = new LinkedList<V>(graph.getSources());
        LinkedList<Path<V, Path<V, BaseEdge>>> chains = new LinkedList<Path<V, Path<V, BaseEdge>>>();
        HashSet<V> alreadySeen = new HashSet<V>(chainStarts);
        while (!chainStarts.isEmpty()) {
            BaseVertex chainStart = (BaseVertex)chainStarts.pop();
            for (BaseEdge outEdge : graph.outgoingEdgesOf(chainStart)) {
                Path<V, BaseEdge> chain = this.findChain(outEdge, graph);
                chains.add(chain);
                V chainEnd = chain.getLastVertex();
                if (alreadySeen.contains(chainEnd)) continue;
                chainStarts.add(chainEnd);
                alreadySeen.add(chainEnd);
            }
        }
        return chains;
    }

    private Path<V, E> findChain(E startEdge, BaseGraph<V, E> graph) {
        Set outEdges;
        ArrayList<E> edges = new ArrayList<E>();
        edges.add(startEdge);
        BaseVertex firstVertex = (BaseVertex)graph.getEdgeSource(startEdge);
        BaseVertex lastVertex = (BaseVertex)graph.getEdgeTarget(startEdge);
        while ((outEdges = graph.outgoingEdgesOf(lastVertex)).size() == 1 && graph.inDegreeOf(lastVertex) <= 1 && !lastVertex.equals(firstVertex)) {
            BaseEdge nextEdge = (BaseEdge)outEdges.iterator().next();
            edges.add(nextEdge);
            lastVertex = (BaseVertex)graph.getEdgeTarget(nextEdge);
        }
        return new Path(edges, lastVertex, graph);
    }

    protected abstract Collection<Path<V, E>> chainsToRemove(List<Path<V, E>> var1);
}

