/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.GraphUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.utils.Utils;

public final class CommonSuffixSplitter {
    private CommonSuffixSplitter() {
    }

    public static boolean split(SeqGraph graph, SeqVertex v) {
        Utils.nonNull(graph, "graph cannot be null");
        Utils.nonNull(v, "v cannot be null");
        Utils.validateArg(graph.vertexSet().contains(v), () -> "graph doesn't contain vertex v " + v);
        Set<SeqVertex> toSplit = graph.incomingVerticesOf(v);
        SeqVertex suffixVTemplate = CommonSuffixSplitter.commonSuffix(graph, v, toSplit);
        if (suffixVTemplate == null) {
            return false;
        }
        LinkedList edgesToRemove = new LinkedList();
        for (SeqVertex mid : toSplit) {
            SeqVertex incomingTarget;
            SeqVertex suffixV = new SeqVertex(suffixVTemplate.getSequence());
            graph.addVertex(suffixV);
            SeqVertex prefixV = mid.withoutSuffix(suffixV.getSequence());
            Object out = graph.outgoingEdgeOf(mid);
            if (prefixV == null) {
                incomingTarget = suffixV;
            } else {
                incomingTarget = prefixV;
                graph.addVertex(prefixV);
                graph.addEdge(prefixV, suffixV, new BaseEdge(((BaseEdge)out).isRef(), 1));
                edgesToRemove.add(out);
            }
            graph.addEdge(suffixV, graph.getEdgeTarget(out), ((BaseEdge)out).copy());
            for (BaseEdge in : graph.incomingEdgesOf(mid)) {
                graph.addEdge(graph.getEdgeSource(in), incomingTarget, in.copy());
                edgesToRemove.add(in);
            }
        }
        graph.removeAllVertices(toSplit);
        graph.removeAllEdges(edgesToRemove);
        return true;
    }

    private static SeqVertex commonSuffix(SeqGraph graph, SeqVertex v, Collection<SeqVertex> toSplit) {
        if (toSplit.size() < 2) {
            return null;
        }
        if (!CommonSuffixSplitter.safeToSplit(graph, v, toSplit)) {
            return null;
        }
        SeqVertex suffixVTemplate = CommonSuffixSplitter.commonSuffix(toSplit);
        if (suffixVTemplate.isEmpty()) {
            return null;
        }
        if (CommonSuffixSplitter.wouldEliminateRefSource(graph, suffixVTemplate, toSplit)) {
            return null;
        }
        if (CommonSuffixSplitter.allVerticesAreTheCommonSuffix(suffixVTemplate, toSplit)) {
            return null;
        }
        return suffixVTemplate;
    }

    private static boolean wouldEliminateRefSource(SeqGraph graph, SeqVertex commonSuffix, Collection<SeqVertex> toSplits) {
        for (SeqVertex toSplit : toSplits) {
            if (!graph.isRefSource(toSplit)) continue;
            return toSplit.length() == commonSuffix.length();
        }
        return false;
    }

    private static boolean allVerticesAreTheCommonSuffix(SeqVertex commonSuffix, Collection<SeqVertex> toSplits) {
        for (SeqVertex toSplit : toSplits) {
            if (toSplit.length() == commonSuffix.length()) continue;
            return false;
        }
        return true;
    }

    private static boolean safeToSplit(SeqGraph graph, SeqVertex bot, Collection<SeqVertex> toMerge) {
        HashSet<SeqVertex> outgoingOfBot = new HashSet<SeqVertex>(graph.outgoingVerticesOf(bot));
        for (SeqVertex m : toMerge) {
            Set outs = graph.outgoingEdgesOf(m);
            if (m == bot || outs.size() != 1 || !graph.outgoingVerticesOf(m).contains(bot)) {
                return false;
            }
            if (!outgoingOfBot.contains(m)) continue;
            return false;
        }
        return true;
    }

    private static SeqVertex commonSuffix(Collection<SeqVertex> middleVertices) {
        List<byte[]> kmers = GraphUtils.getKmers(middleVertices);
        int min = GraphUtils.minKmerLength(kmers);
        int suffixLen = GraphUtils.commonMaximumSuffixLength(kmers, min);
        byte[] kmer = kmers.get(0);
        byte[] suffix = Arrays.copyOfRange(kmer, kmer.length - suffixLen, kmer.length);
        return new SeqVertex(suffix);
    }
}

