/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KBestHaplotype;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KBestHaplotypeFinder;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.Path;
import org.broadinstitute.hellbender.utils.BaseUtils;

public class GraphBasedKBestHaplotypeFinder<V extends BaseVertex, E extends BaseEdge>
extends KBestHaplotypeFinder<V, E> {
    public final Comparator<KBestHaplotype<V, E>> K_BEST_HAPLOTYPE_COMPARATOR = Comparator.comparingDouble(KBestHaplotype::score).reversed().thenComparing(Path::getBases, BaseUtils.BASES_COMPARATOR.reversed());

    public GraphBasedKBestHaplotypeFinder(BaseGraph<V, E> graph, Set<V> sources, Set<V> sinks) {
        super(sinks, sources, graph);
    }

    public GraphBasedKBestHaplotypeFinder(BaseGraph<V, E> graph, V source, V sink) {
        this((BaseGraph<Set<V>, E>)graph, Collections.singleton(source), Collections.singleton(sink));
    }

    public GraphBasedKBestHaplotypeFinder(BaseGraph<V, E> graph) {
        this(graph, graph.getSources(), graph.getSinks());
    }

    @Override
    public boolean keepCycles() {
        return false;
    }

    @Override
    public List<KBestHaplotype<V, E>> findBestHaplotypes(int maxNumberOfHaplotypes) {
        ArrayList<KBestHaplotype<V, KBestHaplotype<V, E>>> result = new ArrayList<KBestHaplotype<V, KBestHaplotype<V, E>>>();
        PriorityQueue<KBestHaplotype<V, KBestHaplotype<V, BaseEdge>>> queue = new PriorityQueue<KBestHaplotype<V, KBestHaplotype<V, BaseEdge>>>(this.K_BEST_HAPLOTYPE_COMPARATOR);
        this.sources.forEach(source -> queue.add(new KBestHaplotype((BaseVertex)source, this.graph)));
        Map<BaseVertex, MutableInt> vertexCounts = this.graph.vertexSet().stream().collect(Collectors.toMap(v -> v, v -> new MutableInt(0)));
        while (!queue.isEmpty() && result.size() < maxNumberOfHaplotypes) {
            KBestHaplotype<V, E> pathToExtend = queue.poll();
            Object vertexToExtend = pathToExtend.getLastVertex();
            if (this.sinks.contains(vertexToExtend)) {
                result.add(pathToExtend);
                continue;
            }
            if (vertexCounts.get(vertexToExtend).getAndIncrement() >= maxNumberOfHaplotypes) continue;
            Set outgoingEdges = this.graph.outgoingEdgesOf(vertexToExtend);
            int totalOutgoingMultiplicity = 0;
            for (BaseEdge edge : outgoingEdges) {
                totalOutgoingMultiplicity += edge.getMultiplicity();
            }
            for (BaseEdge edge : outgoingEdges) {
                queue.add(new KBestHaplotype<V, BaseEdge>(pathToExtend, edge, totalOutgoingMultiplicity));
            }
        }
        return result;
    }
}

