/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.utils.Utils;

public final class GraphUtils {
    private GraphUtils() {
    }

    public static int commonMaximumPrefixLength(List<byte[]> listOfBytes) {
        int minLength = GraphUtils.minKmerLength(listOfBytes);
        for (int i = 0; i < minLength; ++i) {
            byte b = listOfBytes.get(0)[i];
            for (int j = 1; j < listOfBytes.size(); ++j) {
                if (b == listOfBytes.get(j)[i]) continue;
                return i;
            }
        }
        return minLength;
    }

    public static int commonMaximumSuffixLength(List<byte[]> listOfBytes, int minLength) {
        for (int suffixLen = 0; suffixLen < minLength; ++suffixLen) {
            byte b = listOfBytes.get(0)[listOfBytes.get(0).length - suffixLen - 1];
            for (int j = 1; j < listOfBytes.size(); ++j) {
                if (b == listOfBytes.get(j)[listOfBytes.get(j).length - suffixLen - 1]) continue;
                return suffixLen;
            }
        }
        return minLength;
    }

    public static List<byte[]> getKmers(Collection<SeqVertex> vertices) {
        return Utils.nonNull(vertices).stream().map(v -> v.getSequence()).collect(Collectors.toList());
    }

    public static int minKmerLength(Collection<byte[]> kmers) {
        return Utils.nonNull(kmers).stream().mapToInt(kmer -> ((byte[])kmer).length).min().orElse(0);
    }
}

