/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KBestHaplotype;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MultiSampleEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.JunctionTreeLinkedDeBruijnGraph;

public class JTBestHaplotype<V extends BaseVertex, E extends BaseEdge>
extends KBestHaplotype<V, E> {
    private JunctionTreeManager junctionTreeManager;
    private int decisionEdgesTakenSinceLastJunctionTreeEvidence;
    private int maxReferenceSpan;
    private boolean wasPoorlyRecovered = false;

    public boolean isWasPoorlyRecovered() {
        return this.wasPoorlyRecovered;
    }

    public JTBestHaplotype(JTBestHaplotype<V, E> previousPath, List<E> edgesToExtend, double edgePenalty) {
        super(previousPath, edgesToExtend, edgePenalty);
        this.junctionTreeManager = new JunctionTreeManager(previousPath.junctionTreeManager);
        this.decisionEdgesTakenSinceLastJunctionTreeEvidence = this.junctionTreeManager.hasJunctionTreeEvidence() ? 0 : previousPath.decisionEdgesTakenSinceLastJunctionTreeEvidence;
    }

    private JTBestHaplotype(JTBestHaplotype<V, E> previousPath, List<E> chain, int edgeMultiplicity, int totalOutgoingMultiplicity, boolean thisPathBasedOnJT) {
        super(previousPath, chain, JTBestHaplotype.computeLogPenaltyScore(edgeMultiplicity, totalOutgoingMultiplicity));
        this.junctionTreeManager = new JunctionTreeManager(previousPath.junctionTreeManager);
        this.junctionTreeManager.traverseEdgeForAllTrees((BaseEdge)chain.get(chain.size() - 1));
        this.decisionEdgesTakenSinceLastJunctionTreeEvidence = thisPathBasedOnJT ? 0 : previousPath.decisionEdgesTakenSinceLastJunctionTreeEvidence + 1;
    }

    public JTBestHaplotype(V initialVertex, BaseGraph<V, E> graph) {
        super(initialVertex, graph);
        this.junctionTreeManager = new JunctionTreeManager();
        this.decisionEdgesTakenSinceLastJunctionTreeEvidence = 0;
    }

    public boolean hasJunctionTreeEvidence() {
        return this.junctionTreeManager.hasJunctionTreeEvidence();
    }

    public boolean wasLastEdgeFollowedBasedOnJTEvidence() {
        return this.decisionEdgesTakenSinceLastJunctionTreeEvidence == 0;
    }

    public boolean hasStoppingEvidence(int weightThreshold) {
        for (JunctionTreeLinkedDeBruijnGraph.ThreadingNode tree : this.junctionTreeManager.removeEmptyNodesAndReturnIterator()) {
            int totalOut = JTBestHaplotype.getTotalOutForBranch(tree);
            if (tree.getChildrenNodes().values().stream().anyMatch(JunctionTreeLinkedDeBruijnGraph.ThreadingNode::isSymbolicEnd)) {
                return true;
            }
            if (totalOut < weightThreshold) continue;
            return false;
        }
        return true;
    }

    private static int getTotalOutForBranch(JunctionTreeLinkedDeBruijnGraph.ThreadingNode eldestTree) {
        return eldestTree == null ? 0 : eldestTree.getChildrenNodes().values().stream().mapToInt(JunctionTreeLinkedDeBruijnGraph.ThreadingNode::getEvidenceCount).sum();
    }

    public void markTreesAsVisited(List<JunctionTreeLinkedDeBruijnGraph.ThreadingTree> trees) {
        this.junctionTreeManager.visitedTrees.addAll(trees);
    }

    public List<JTBestHaplotype<V, E>> getApplicableNextEdgesBasedOnJunctionTrees(List<E> chain, Set<E> outgoingEdges, int weightThreshold) {
        HashSet<MultiSampleEdge> edgesAccountedForByJunctionTrees = new HashSet<MultiSampleEdge>();
        ArrayList<JTBestHaplotype<V, JTBestHaplotype<V, E>>> output = new ArrayList<JTBestHaplotype<V, JTBestHaplotype<V, E>>>();
        for (JunctionTreeLinkedDeBruijnGraph.ThreadingNode tree : this.junctionTreeManager.removeEmptyNodesAndReturnIterator()) {
            int totalOut = JTBestHaplotype.getTotalOutForBranch(tree);
            for (Map.Entry<MultiSampleEdge, JunctionTreeLinkedDeBruijnGraph.ThreadingNode> childNode : tree.getChildrenNodes().entrySet()) {
                if (!outgoingEdges.contains(childNode.getKey())) {
                    throw new GATKException("While constructing graph, there was an incongruity between a JunctionTree edge and the edge present on graph traversal");
                }
                if (childNode.getValue().isSymbolicEnd() || edgesAccountedForByJunctionTrees.contains(childNode.getKey())) continue;
                edgesAccountedForByJunctionTrees.add(childNode.getKey());
                JunctionTreeLinkedDeBruijnGraph.ThreadingNode child = childNode.getValue();
                ArrayList<BaseEdge> chainCopy = new ArrayList<BaseEdge>(chain);
                chainCopy.add(childNode.getKey());
                output.add(new JTBestHaplotype<V, E>(this, chainCopy, child.getEvidenceCount(), totalOut, true));
            }
            if (totalOut < weightThreshold) continue;
            return output;
        }
        int totalOutgoingMultiplicity = 0;
        for (BaseEdge edge : outgoingEdges) {
            totalOutgoingMultiplicity += edge.getMultiplicity();
        }
        for (BaseEdge edge : outgoingEdges) {
            if (edgesAccountedForByJunctionTrees.contains((MultiSampleEdge)edge) || totalOutgoingMultiplicity == 0 || edge.getMultiplicity() == 0 || edge.isRef() && edge.getMultiplicity() == 1 && (!edgesAccountedForByJunctionTrees.isEmpty() || outgoingEdges.size() >= 2)) continue;
            ArrayList<BaseEdge> chainCopy = new ArrayList<BaseEdge>(chain);
            chainCopy.add(edge);
            output.add(new JTBestHaplotype<V, E>(this, chainCopy, edge.getMultiplicity(), totalOutgoingMultiplicity, false));
        }
        return output;
    }

    public int getDecisionEdgesTakenSinceLastJunctionTreeEvidence() {
        return this.decisionEdgesTakenSinceLastJunctionTreeEvidence;
    }

    public void addJunctionTree(JunctionTreeLinkedDeBruijnGraph.ThreadingTree junctionTreeForNode) {
        if (this.junctionTreeManager.addJunctionTree(junctionTreeForNode)) {
            this.decisionEdgesTakenSinceLastJunctionTreeEvidence = 0;
        }
    }

    public void setWasPoorlyRecovered(boolean b) {
        this.wasPoorlyRecovered = b;
    }

    private class JunctionTreeManager {
        Set<JunctionTreeLinkedDeBruijnGraph.ThreadingTree> visitedTrees;
        List<JunctionTreeLinkedDeBruijnGraph.ThreadingNode> activeNodes;

        protected JunctionTreeManager() {
            this.visitedTrees = new HashSet<JunctionTreeLinkedDeBruijnGraph.ThreadingTree>();
            this.activeNodes = new ArrayList<JunctionTreeLinkedDeBruijnGraph.ThreadingNode>(5);
        }

        protected JunctionTreeManager(JunctionTreeManager toCopy) {
            this.visitedTrees = new HashSet<JunctionTreeLinkedDeBruijnGraph.ThreadingTree>(toCopy.visitedTrees);
            this.activeNodes = new ArrayList<JunctionTreeLinkedDeBruijnGraph.ThreadingNode>(toCopy.activeNodes);
        }

        public boolean addJunctionTree(JunctionTreeLinkedDeBruijnGraph.ThreadingTree junctionTreeForNode) {
            if (!this.visitedTrees.contains(junctionTreeForNode) && !junctionTreeForNode.getRootNode().hasNoEvidence()) {
                this.visitedTrees.add(junctionTreeForNode);
                this.activeNodes.add(junctionTreeForNode.getRootNode());
                return true;
            }
            return false;
        }

        public void traverseEdgeForAllTrees(E edgeTaken) {
            this.activeNodes = this.activeNodes.stream().filter(node -> node.getChildrenNodes().containsKey(edgeTaken)).map(node -> node.getChildrenNodes().get(edgeTaken)).filter(node -> !node.hasNoEvidence()).collect(Collectors.toList());
        }

        public Iterable<JunctionTreeLinkedDeBruijnGraph.ThreadingNode> removeEmptyNodesAndReturnIterator() {
            this.activeNodes = this.activeNodes.stream().filter(node -> JTBestHaplotype.getTotalOutForBranch(node) > 0).collect(Collectors.toList());
            return this.activeNodes;
        }

        private JunctionTreeLinkedDeBruijnGraph.ThreadingNode get(int i) {
            return this.activeNodes.get(i);
        }

        private int size() {
            return this.activeNodes == null ? 0 : this.activeNodes.size();
        }

        private void removeOldestTree() {
            this.activeNodes.remove(0);
        }

        public boolean hasJunctionTreeEvidence() {
            return !this.activeNodes.isEmpty();
        }
    }
}

