/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.JTBestHaplotype;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KBestHaplotype;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KBestHaplotypeFinder;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MultiSampleEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.JunctionTreeLinkedDeBruijnGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.MultiDeBruijnVertex;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public class JunctionTreeKBestHaplotypeFinder<V extends BaseVertex, E extends BaseEdge>
extends KBestHaplotypeFinder<V, E> {
    private Logger logger = LogManager.getLogger(this.getClass());
    public static final int DEFAULT_MAX_UPSTREAM_REFERENCE_JUMP_TO_ALLOW = 40;
    public static final int DEFAULT_NUM_UPSTREAM_REFERENCE_EDGES_TO_TOLERATE = 10;
    public static final int DEFAULT_OUTGOING_JT_EVIDENCE_THRESHOLD_TO_BELEIVE = 3;
    public static final int DEFAULT_MINIMUM_WEIGHT_FOR_JT_BRANCH_TO_NOT_BE_PRUNED = 1;
    public static final int DEFAULT_MAX_ACCEPTABLE_DECISION_EDGES_WITHOUT_JT_GUIDANCE = 5;
    public static final int DEFAULT_MAX_ACCEPTABLE_REPETITIONS_OF_A_KMER_IN_A_PATH = 1;
    public static final int DEFAULT_MAX_PATHS_TO_CONSIDER_WITHOUT_RESULT = 1000;
    public static final int DEFAULT_MAX_PATHS_TO_EVER_CONSIDER = 10000;
    private int junctionTreeEvidenceWeightThreshold = 3;
    private Map<V, List<E>> graphKmerChainCache = new HashMap<V, List<E>>();
    private JunctionTreeLinkedDeBruijnGraph junctionTreeLinkedDeBruijnGraph;
    private final boolean experimentalEndRecoveryMode;

    public JunctionTreeKBestHaplotypeFinder(BaseGraph<V, E> graph, Set<V> sources, Set<V> sinks, int branchWeightThreshold, boolean experimentalEndRecoveryMode) {
        super(sinks, sources, graph);
        Utils.validate(graph instanceof JunctionTreeLinkedDeBruijnGraph, "JunctionTreeKBestHaplotypeFinder requires an JunctionTreeLinkedDeBruijnGraph be provided");
        this.junctionTreeLinkedDeBruijnGraph = (JunctionTreeLinkedDeBruijnGraph)graph;
        this.experimentalEndRecoveryMode = experimentalEndRecoveryMode;
        ParamUtils.isPositive(this.junctionTreeEvidenceWeightThreshold, "Pruning Weight Threshold must be a positive number greater than 0");
    }

    public JunctionTreeKBestHaplotypeFinder(BaseGraph<V, E> graph, V source, V sink) {
        this((BaseGraph<Set<V>, E>)graph, Collections.singleton(source), Collections.singleton(sink), 3, true);
    }

    public JunctionTreeKBestHaplotypeFinder(BaseGraph<V, E> graph, V source, V sink, int branchWeightThreshold, boolean endRecoveryMode) {
        this((BaseGraph<Set<V>, E>)graph, Collections.singleton(source), Collections.singleton(sink), branchWeightThreshold, endRecoveryMode);
    }

    public JunctionTreeKBestHaplotypeFinder(BaseGraph<V, E> graph) {
        this(graph, graph.getReferenceSourceVertex(), graph.getReferenceSinkVertex());
    }

    @Override
    public boolean keepCycles() {
        return true;
    }

    @VisibleForTesting
    public JunctionTreeKBestHaplotypeFinder<V, E> setJunctionTreeEvidenceWeightThreshold(int outgoingWeight) {
        Utils.validate(this.junctionTreeEvidenceWeightThreshold > 0, "Pruning Weight Threshold must be a positive number greater than 0");
        this.junctionTreeEvidenceWeightThreshold = outgoingWeight;
        return this;
    }

    @Override
    public List<KBestHaplotype<V, E>> findBestHaplotypes(int maxNumberOfHaplotypes) {
        LinkedHashSet unvisitedPivotalEdges = this.experimentalEndRecoveryMode ? this.createMapOfPivotalEdgesInTopologicalOrder() : new LinkedHashSet();
        ArrayList<JTBestHaplotype<V, JTBestHaplotype<V, E>>> result = new ArrayList<JTBestHaplotype<V, JTBestHaplotype<V, E>>>();
        PriorityQueue<KBestHaplotype> queue = new PriorityQueue<KBestHaplotype>(Comparator.comparingDouble(KBestHaplotype::score).reversed());
        this.sources.forEach(source -> queue.add(new JTBestHaplotype((BaseVertex)source, this.graph)));
        while (!(result.size() >= maxNumberOfHaplotypes || queue.isEmpty() && unvisitedPivotalEdges.isEmpty() || queue.size() > (result.isEmpty() ? 1000 : 10000))) {
            if (queue.isEmpty()) {
                this.enqueueNextPivotalEdge(unvisitedPivotalEdges, result, queue);
                continue;
            }
            JTBestHaplotype pathToExtend = (JTBestHaplotype)queue.poll();
            if (pathToExtend.getDecisionEdgesTakenSinceLastJunctionTreeEvidence() > 5) continue;
            Object vertexToExtend = pathToExtend.getLastVertex();
            Set outgoingEdges = this.graph.outgoingEdgesOf(vertexToExtend);
            List chain = this.graphKmerChainCache.computeIfAbsent((List)vertexToExtend, (Function<List, List<E>>)((Function<BaseVertex, List>)k -> new ArrayList()));
            if (chain.isEmpty()) {
                BaseEdge edge;
                while (!(outgoingEdges.size() != 1 || this.junctionTreeLinkedDeBruijnGraph.getJunctionTreeForNode((MultiDeBruijnVertex)vertexToExtend).isPresent() || this.sinks.contains(vertexToExtend) || chain.contains(edge = (BaseEdge)outgoingEdges.iterator().next()))) {
                    chain.add(edge);
                    vertexToExtend = (BaseVertex)this.graph.getEdgeTarget(edge);
                    outgoingEdges = this.graph.outgoingEdgesOf(vertexToExtend);
                }
                this.graphKmerChainCache.put((List)pathToExtend.getLastVertex(), chain);
            } else {
                vertexToExtend = (BaseVertex)this.graph.getEdgeTarget(chain.get(chain.size() - 1));
                outgoingEdges = this.graph.outgoingEdgesOf(vertexToExtend);
            }
            this.junctionTreeLinkedDeBruijnGraph.getJunctionTreeForNode((MultiDeBruijnVertex)vertexToExtend).ifPresent(pathToExtend::addJunctionTree);
            if (this.sinks.contains(vertexToExtend) && pathToExtend.hasStoppingEvidence(this.junctionTreeEvidenceWeightThreshold)) {
                JTBestHaplotype<V, E> newPath = this.reconcilePathMissingReferenceStartPositions(chain.isEmpty() ? pathToExtend : new JTBestHaplotype(pathToExtend, chain, 0.0));
                if (newPath != null) {
                    result.add(newPath);
                }
                pathToExtend.getEdges().forEach(unvisitedPivotalEdges::remove);
            }
            if (outgoingEdges.size() > 1) {
                List jTPaths = pathToExtend.getApplicableNextEdgesBasedOnJunctionTrees(chain, outgoingEdges, this.junctionTreeEvidenceWeightThreshold);
                if (jTPaths.isEmpty() && !this.sinks.contains(vertexToExtend)) {
                    this.logger.debug("Found nothing Queue has this many: " + queue.size() + "\nPath that failed to extend was junction tree: " + pathToExtend.getVertices());
                }
                List filteredPaths = jTPaths.stream().filter(path -> path.hasJunctionTreeEvidence() || path.wasLastEdgeFollowedBasedOnJTEvidence() || path.getVertices().stream().filter(v -> v.equals(path.getLastVertex())).count() <= 1L).collect(Collectors.toList());
                if (jTPaths.isEmpty() && !this.sinks.contains(vertexToExtend)) {
                    this.logger.debug("A path was filtered because it was looping without junction tree support");
                }
                queue.addAll(filteredPaths);
                continue;
            }
            if (outgoingEdges.size() <= 0) continue;
            Object finalVertexToExtend = vertexToExtend;
            if (!pathToExtend.hasJunctionTreeEvidence() && pathToExtend.getVertices().stream().filter(v -> v.equals(finalVertexToExtend)).count() > 1L) continue;
            ArrayList chainCopy = new ArrayList(chain);
            chainCopy.add(outgoingEdges.iterator().next());
            queue.add(new JTBestHaplotype(pathToExtend, chainCopy, 0.0));
        }
        return result.stream().map(n -> n).collect(Collectors.toList());
    }

    private void enqueueNextPivotalEdge(LinkedHashSet<E> unvisitedPivotalEdges, List<JTBestHaplotype<V, E>> result, PriorityQueue<JTBestHaplotype<V, E>> queue) {
        BaseEdge firstEdge = (BaseEdge)unvisitedPivotalEdges.stream().findFirst().get();
        BaseVertex pivotalVerex = (BaseVertex)this.graph.getEdgeSource(firstEdge);
        unvisitedPivotalEdges.remove(firstEdge);
        Optional<JTBestHaplotype> bestMatchingHaplotype = result.stream().filter(path -> path.containsVertex(pivotalVerex)).max(Comparator.comparingDouble(KBestHaplotype::score));
        if (bestMatchingHaplotype.isPresent()) {
            List bestMatchingHaplotypeEdges = bestMatchingHaplotype.get().getEdges();
            List edgesIncomingToSplitPoint = bestMatchingHaplotypeEdges.stream().filter(edge -> ((BaseVertex)this.graph.getEdgeTarget(edge)).equals(pivotalVerex)).collect(Collectors.toList());
            if (edgesIncomingToSplitPoint.isEmpty()) {
                return;
            }
            ArrayList<BaseEdge> edgesBeforeSplit = new ArrayList<BaseEdge>(bestMatchingHaplotypeEdges.subList(0, bestMatchingHaplotypeEdges.lastIndexOf(edgesIncomingToSplitPoint.get(edgesIncomingToSplitPoint.size() - 1)) + 1));
            edgesBeforeSplit.add(firstEdge);
            JTBestHaplotype pathToAdd = new JTBestHaplotype(new JTBestHaplotype(bestMatchingHaplotype.get().getFirstVertex(), this.graph), edgesBeforeSplit, bestMatchingHaplotype.get().score());
            List<JunctionTreeLinkedDeBruijnGraph.ThreadingTree> treesPassed = pathToAdd.getVertices().stream().map(v -> this.junctionTreeLinkedDeBruijnGraph.getJunctionTreeForNode((MultiDeBruijnVertex)v)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            pathToAdd.markTreesAsVisited(treesPassed);
            queue.add(pathToAdd);
        }
    }

    private void annotatePathBasedOnGraph(JTBestHaplotype<V, E> newPath, JunctionTreeLinkedDeBruijnGraph graph) {
        int farthestReferenceEdgeReached = 0;
        int numUpstreamRefEdgesEncountered = 0;
        int lastReferenceEdgeVisited = 0;
        for (BaseEdge edge : newPath.getEdges()) {
            Integer index;
            List<Integer> refOccurances = ((MultiSampleEdge)edge).getReferencePathIndexes();
            if (refOccurances.isEmpty()) continue;
            int refIndex = 0;
            Iterator<Integer> iterator = refOccurances.iterator();
            while (iterator.hasNext() && (refIndex = (index = iterator.next()).intValue()) <= lastReferenceEdgeVisited) {
            }
            if (farthestReferenceEdgeReached > refIndex + 40) {
                ++numUpstreamRefEdgesEncountered;
            } else if (refIndex > farthestReferenceEdgeReached) {
                farthestReferenceEdgeReached = refIndex;
            }
            lastReferenceEdgeVisited = refIndex;
        }
        if (numUpstreamRefEdgesEncountered > 10) {
            newPath.setWasPoorlyRecovered(true);
        }
    }

    private JTBestHaplotype<V, E> reconcilePathMissingReferenceStartPositions(JTBestHaplotype<V, E> pathToReconcile) {
        if (this.sources.contains(pathToReconcile.getVertices().get(0))) {
            return pathToReconcile;
        }
        throw new GATKException.ShouldNeverReachHereException("It looks like we have tried to merge a haplotype to the output that does not start on the reference source. This should not have happened");
    }

    @VisibleForTesting
    LinkedHashSet<E> createMapOfPivotalEdgesInTopologicalOrder() {
        HashSet visitedEdges = new HashSet();
        PriorityQueue<TinyEdgeHelper> edgesToVisit = new PriorityQueue<TinyEdgeHelper>(Comparator.comparingDouble(rec$ -> ((TinyEdgeHelper)rec$).score()));
        LinkedHashSet outputEdgesInOrder = new LinkedHashSet();
        edgesToVisit.addAll(this.sources.stream().flatMap(s -> this.graph.outgoingEdgesOf(s).stream()).map(e -> new TinyEdgeHelper((BaseEdge)e, 0)).collect(Collectors.toList()));
        while (!edgesToVisit.isEmpty()) {
            TinyEdgeHelper nextEdge = edgesToVisit.poll();
            ArrayList outgoingEdges = new ArrayList(this.graph.outgoingEdgesOf(this.graph.getEdgeTarget(nextEdge.edge)));
            if (outgoingEdges.size() > 1) {
                outputEdgesInOrder.addAll(outgoingEdges.stream().filter(e -> (!e.isRef() || e.getMultiplicity() != 1) && !visitedEdges.contains(e)).collect(Collectors.toList()));
            }
            outgoingEdges.stream().filter(e -> !visitedEdges.contains(e)).forEach(e -> {
                edgesToVisit.add(new TinyEdgeHelper((BaseEdge)e, nextEdge.score + 1));
                visitedEdges.add(e);
            });
        }
        return outputEdgesInOrder;
    }

    private class TinyEdgeHelper {
        E edge;
        int score;

        private TinyEdgeHelper(int e2) {
            this.edge = e2;
            this.score = this.score();
        }

        private int score() {
            return this.score;
        }
    }
}

