/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.Path;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;

public class KBestHaplotype<V extends BaseVertex, E extends BaseEdge>
extends Path<V, E> {
    private double score;
    private boolean isReference;

    public double score() {
        return this.score;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public KBestHaplotype(V initialVertex, BaseGraph<V, E> graph) {
        super(initialVertex, graph);
        this.score = 0.0;
    }

    public KBestHaplotype(KBestHaplotype<V, E> p, E edge, int totalOutgoingMultiplicity) {
        super(p, edge);
        this.score = p.score + KBestHaplotype.computeLogPenaltyScore(((BaseEdge)edge).getMultiplicity(), totalOutgoingMultiplicity);
        this.isReference &= ((BaseEdge)edge).isRef();
    }

    public static double computeLogPenaltyScore(int edgeMultiplicity, int totalOutgoingMultiplicity) {
        return MathUtils.log10(edgeMultiplicity) - MathUtils.log10(totalOutgoingMultiplicity);
    }

    public KBestHaplotype(KBestHaplotype<V, E> p, List<E> edgesToExtend, double edgePenalty) {
        super(p, edgesToExtend);
        this.score = p.score() + edgePenalty;
        this.isReference &= ((BaseEdge)edgesToExtend.get(edgesToExtend.size() - 1)).isRef();
    }

    public final Haplotype haplotype() {
        Haplotype haplotype = new Haplotype(this.getBases(), this.isReference());
        haplotype.setScore(this.score());
        return haplotype;
    }
}

