/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KBestHaplotype;
import org.broadinstitute.hellbender.utils.Utils;
import org.jgrapht.alg.CycleDetector;

public abstract class KBestHaplotypeFinder<V extends BaseVertex, E extends BaseEdge> {
    protected final BaseGraph<V, E> graph;
    final Set<V> sinks;
    final Set<V> sources;

    public KBestHaplotypeFinder(Set<V> sinks, Set<V> sources, BaseGraph<V, E> graph) {
        Utils.nonNull(graph, "graph cannot be null");
        Utils.nonNull(sources, "sources cannot be null");
        Utils.nonNull(sinks, "sinks cannot be null");
        Utils.validateArg(graph.containsAllVertices(sources), "source does not belong to the graph");
        Utils.validateArg(graph.containsAllVertices(sinks), "sink does not belong to the graph");
        this.sinks = sinks;
        this.sources = sources;
        this.graph = this.removeCyclesIfNecessary(graph, sources, sinks);
    }

    private BaseGraph<V, E> removeCyclesIfNecessary(BaseGraph<V, E> graph, Set<V> sources, Set<V> sinks) {
        if (this.keepCycles()) {
            return graph;
        }
        return new CycleDetector(graph).detectCycles() ? this.removeCyclesAndVerticesThatDontLeadToSinks(graph, sources, sinks) : graph;
    }

    private BaseGraph<V, E> removeCyclesAndVerticesThatDontLeadToSinks(BaseGraph<V, E> original, Collection<V> sources, Set<V> sinks) {
        HashSet edgesToRemove = new HashSet(original.edgeSet().size());
        HashSet vertexToRemove = new HashSet(original.vertexSet().size());
        boolean foundSomePath = false;
        for (BaseVertex source : sources) {
            HashSet parentVertices;
            foundSomePath = this.findGuiltyVerticesAndEdgesToRemoveCycles(original, source, sinks, edgesToRemove, vertexToRemove, parentVertices = new HashSet(original.vertexSet().size())) || foundSomePath;
        }
        Utils.validate(foundSomePath, () -> "could not find any path from the source vertex to the sink vertex after removing cycles: " + Arrays.toString(sources.toArray()) + " => " + Arrays.toString(sinks.toArray()));
        Utils.validate(!edgesToRemove.isEmpty() || !vertexToRemove.isEmpty(), "cannot find a way to remove the cycles");
        BaseGraph<V, E> result = original.clone();
        result.removeAllEdges(edgesToRemove);
        result.removeAllVertices(vertexToRemove);
        return result;
    }

    private boolean findGuiltyVerticesAndEdgesToRemoveCycles(BaseGraph<V, E> graph, V currentVertex, Set<V> sinks, Set<E> edgesToRemove, Set<V> verticesToRemove, Set<V> parentVertices) {
        if (sinks.contains(currentVertex)) {
            return true;
        }
        Set outgoingEdges = graph.outgoingEdgesOf(currentVertex);
        parentVertices.add(currentVertex);
        boolean reachesSink = false;
        for (BaseEdge edge : outgoingEdges) {
            BaseVertex child = (BaseVertex)graph.getEdgeTarget(edge);
            if (parentVertices.contains(child)) {
                edgesToRemove.add(edge);
                continue;
            }
            boolean childReachSink = this.findGuiltyVerticesAndEdgesToRemoveCycles(graph, child, sinks, edgesToRemove, verticesToRemove, parentVertices);
            reachesSink = reachesSink || childReachSink;
        }
        if (!reachesSink) {
            verticesToRemove.add(currentVertex);
        }
        return reachesSink;
    }

    public abstract boolean keepCycles();

    public abstract List<KBestHaplotype<V, E>> findBestHaplotypes(int var1);

    @VisibleForTesting
    public List<KBestHaplotype<V, E>> findBestHaplotypes() {
        return this.findBestHaplotypes(Integer.MAX_VALUE);
    }
}

