/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.ChainPruner;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.Path;
import org.broadinstitute.hellbender.utils.Utils;

public final class LowWeightChainPruner<V extends BaseVertex, E extends BaseEdge>
extends ChainPruner<V, E> {
    private final int pruneFactor;

    public LowWeightChainPruner(int pruneFactor) {
        Utils.validateArg(pruneFactor >= 0, "pruneFactor must be >= 0 but got " + pruneFactor);
        this.pruneFactor = pruneFactor;
    }

    @Override
    protected Collection<Path<V, E>> chainsToRemove(List<Path<V, E>> chains) {
        return chains.stream().filter(this::needsPruning).collect(Collectors.toList());
    }

    private boolean needsPruning(Path<V, E> chain) {
        return chain.getEdges().stream().allMatch(e -> e.getPruningMultiplicity() < this.pruneFactor && !e.isRef());
    }
}

