/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SharedVertexSequenceSplitter;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.VertexBasedTransformer;
import org.broadinstitute.hellbender.utils.Utils;

final class MergeDiamonds
extends VertexBasedTransformer {
    MergeDiamonds(SeqGraph graph) {
        super(graph);
    }

    @Override
    protected boolean tryToTransform(SeqVertex top) {
        Utils.nonNull(top);
        Set<SeqVertex> middles = this.getGraph().outgoingVerticesOf(top);
        if (middles.size() <= 1) {
            return false;
        }
        SeqVertex bottom = null;
        for (SeqVertex mi : middles) {
            if (this.getGraph().outDegreeOf(mi) < 1) {
                return false;
            }
            if (this.getGraph().inDegreeOf(mi) != 1) {
                return false;
            }
            for (SeqVertex mt : this.getGraph().outgoingVerticesOf(mi)) {
                if (bottom == null) {
                    bottom = mt;
                    continue;
                }
                if (bottom.equals(mt)) continue;
                return false;
            }
        }
        if (this.getGraph().inDegreeOf(bottom) != middles.size()) {
            return false;
        }
        if (this.dontModifyGraphEvenIfPossible()) {
            return true;
        }
        SharedVertexSequenceSplitter splitter = new SharedVertexSequenceSplitter(this.getGraph(), middles);
        return splitter.meetsMinMergableSequenceForEitherPrefixOrSuffix(1) && splitter.splitAndUpdate(top, bottom);
    }
}

