/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SharedVertexSequenceSplitter;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.VertexBasedTransformer;
import org.broadinstitute.hellbender.utils.Utils;

final class MergeTails
extends VertexBasedTransformer {
    static final int MIN_COMMON_SEQUENCE_TO_MERGE_SOURCE_SINK_VERTICES = 10;

    MergeTails(SeqGraph graph) {
        super(graph);
    }

    @Override
    protected boolean tryToTransform(SeqVertex top) {
        Utils.nonNull(top);
        Set<SeqVertex> tails = this.getGraph().outgoingVerticesOf(top);
        if (tails.size() <= 1) {
            return false;
        }
        for (SeqVertex t : tails) {
            if (this.getGraph().isSink(t) && this.getGraph().inDegreeOf(t) <= 1) continue;
            return false;
        }
        if (this.dontModifyGraphEvenIfPossible()) {
            return true;
        }
        SharedVertexSequenceSplitter splitter = new SharedVertexSequenceSplitter(this.getGraph(), tails);
        return splitter.meetsMinMergableSequenceForSuffix(10) && splitter.splitAndUpdate(top, null);
    }
}

