/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.utils.Utils;

public final class MultiSampleEdge
extends BaseEdge {
    private int currentSingleSampleMultiplicity;
    private final int singleSampleCapacity;
    private final PriorityQueue<Integer> singleSampleMultiplicities;
    private final List<Integer> referencePathIndexes = new ArrayList<Integer>(2);

    public MultiSampleEdge(boolean isRef, int multiplicity, int singleSampleCapacity) {
        super(isRef, multiplicity);
        Utils.validateArg(singleSampleCapacity > 0, () -> "singleSampleCapacity must be > 0 but found: " + singleSampleCapacity);
        this.singleSampleMultiplicities = new PriorityQueue(singleSampleCapacity);
        this.singleSampleMultiplicities.add(multiplicity);
        this.currentSingleSampleMultiplicity = multiplicity;
        this.singleSampleCapacity = singleSampleCapacity;
    }

    @Override
    public MultiSampleEdge copy() {
        return new MultiSampleEdge(this.isRef(), this.getMultiplicity(), this.singleSampleCapacity);
    }

    public void flushSingleSampleMultiplicity() {
        this.singleSampleMultiplicities.add(this.currentSingleSampleMultiplicity);
        if (this.singleSampleMultiplicities.size() == this.singleSampleCapacity + 1) {
            this.singleSampleMultiplicities.poll();
        } else if (this.singleSampleMultiplicities.size() > this.singleSampleCapacity + 1) {
            throw new IllegalStateException("Somehow the per sample multiplicity list has grown too big: " + this.singleSampleMultiplicities);
        }
        this.currentSingleSampleMultiplicity = 0;
    }

    @Override
    public void incMultiplicity(int incr) {
        super.incMultiplicity(incr);
        this.currentSingleSampleMultiplicity += incr;
    }

    @Override
    public int getPruningMultiplicity() {
        return this.singleSampleMultiplicities.peek();
    }

    @Override
    public String getDotLabel() {
        return super.getDotLabel() + '/' + this.getPruningMultiplicity();
    }

    @VisibleForTesting
    int getCurrentSingleSampleMultiplicity() {
        return this.currentSingleSampleMultiplicity;
    }

    public void addReferenceIndex(int i) {
        this.referencePathIndexes.add(i);
    }

    public List<Integer> getReferencePathIndexes() {
        return this.referencePathIndexes;
    }
}

