/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.Cigar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.ArrayUtils;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;

public class Path<V extends BaseVertex, E extends BaseEdge> {
    private final V lastVertex;
    private final List<E> edgesInOrder;
    private final BaseGraph<V, E> graph;

    public Path(V initialVertex, BaseGraph<V, E> graph) {
        this.lastVertex = (BaseVertex)Utils.nonNull(initialVertex, "initialVertex cannot be null");
        this.graph = Utils.nonNull(graph, "graph cannot be null");
        Utils.validateArg(graph.containsVertex(initialVertex), () -> "Vertex " + initialVertex + " must be part of graph " + (Object)graph);
        this.edgesInOrder = new ArrayList(0);
    }

    public Path(List<E> edgesInOrder, V lastVertex, BaseGraph<V, E> graph) {
        this.lastVertex = lastVertex;
        this.graph = graph;
        this.edgesInOrder = edgesInOrder;
    }

    public Path(Path<V, E> p, E edge) {
        Utils.nonNull(p, "Path cannot be null");
        Utils.nonNull(edge, "Edge cannot be null");
        Utils.validateArg(p.graph.containsEdge(edge), () -> "Graph must contain edge " + edge + " but it doesn't");
        Utils.validate(((BaseVertex)p.graph.getEdgeSource(edge)).equals(p.lastVertex), "Edges added to path must be contiguous.");
        this.graph = p.graph;
        this.lastVertex = (BaseVertex)p.graph.getEdgeTarget(edge);
        this.edgesInOrder = new ArrayList(p.length() + 1);
        this.edgesInOrder.addAll(p.edgesInOrder);
        this.edgesInOrder.add(edge);
    }

    public Path(Path<V, E> p, List<E> edges) {
        Utils.nonNull(p, "Path cannot be null");
        Utils.nonEmpty(edges, "Edge cannot be null");
        edges.forEach(edge -> Utils.validateArg(p.graph.containsEdge(edge), () -> "Graph must contain edge " + edge + " but it doesn't"));
        Object tmpVertex = p.lastVertex;
        for (int i = 0; i < edges.size(); ++i) {
            if (!((BaseVertex)p.graph.getEdgeSource(edges.get(i))).equals(tmpVertex)) {
                throw new IllegalStateException("Edges added to path must be contiguous.");
            }
            tmpVertex = (BaseVertex)p.graph.getEdgeTarget(edges.get(i));
        }
        this.graph = p.graph;
        this.lastVertex = tmpVertex;
        this.edgesInOrder = new ArrayList(p.length() + 1);
        this.edgesInOrder.addAll(p.edgesInOrder);
        this.edgesInOrder.addAll(edges);
    }

    public int length() {
        return this.edgesInOrder.size();
    }

    public Path(E edge, Path<V, E> p) {
        Utils.nonNull(p, "Path cannot be null");
        Utils.nonNull(edge, "Edge cannot be null");
        Utils.validateArg(p.graph.containsEdge(edge), () -> "Graph must contain edge " + edge + " but it doesn't");
        if (!((BaseVertex)p.graph.getEdgeTarget(edge)).equals(p.getFirstVertex())) {
            throw new IllegalStateException("Edges added to path must be contiguous.");
        }
        this.graph = p.graph;
        this.lastVertex = p.lastVertex;
        this.edgesInOrder = new ArrayList(p.length() + 1);
        this.edgesInOrder.add(edge);
        this.edgesInOrder.addAll(p.getEdges());
    }

    @VisibleForTesting
    boolean pathsAreTheSame(Path<V, E> path) {
        return this.edgesInOrder.equals(path.edgesInOrder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsVertex(V v) {
        Utils.nonNull(v, "Vertex cannot be null");
        if (((BaseVertex)v).equals(this.getFirstVertex())) return true;
        if (!this.edgesInOrder.stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).anyMatch(arg_0 -> v.equals(arg_0))) return false;
        return true;
    }

    public String toString() {
        String joinedPath = Strings.join((Iterable)this.getVertices().stream().map(v -> v.getSequenceString()).collect(Collectors.toList()), (String)"->");
        return String.format("Path{path=%s}", joinedPath);
    }

    public BaseGraph<V, E> getGraph() {
        return this.graph;
    }

    public List<E> getEdges() {
        return Collections.unmodifiableList(this.edgesInOrder);
    }

    public E getLastEdge() {
        return (E)((BaseEdge)this.edgesInOrder.get(this.length() - 1));
    }

    public List<V> getVertices() {
        ArrayList<V> result = new ArrayList<V>(this.edgesInOrder.size() + 1);
        result.add(this.getFirstVertex());
        result.addAll(this.edgesInOrder.stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).collect(Collectors.toList()));
        return result;
    }

    public V getLastVertex() {
        return this.lastVertex;
    }

    public V getFirstVertex() {
        if (this.edgesInOrder.isEmpty()) {
            return this.lastVertex;
        }
        return (V)((BaseVertex)this.getGraph().getEdgeSource(this.edgesInOrder.get(0)));
    }

    public byte[] getBases() {
        if (this.getEdges().isEmpty()) {
            return BaseGraph.getAdditionalSequence(this.lastVertex, true);
        }
        byte[] bases = BaseGraph.getAdditionalSequence((BaseVertex)this.graph.getEdgeSource(this.edgesInOrder.get(0)), true);
        for (BaseEdge e : this.edgesInOrder) {
            bases = ArrayUtils.addAll((byte[])bases, (byte[])BaseGraph.getAdditionalSequence((BaseVertex)this.graph.getEdgeTarget(e), false));
        }
        return bases;
    }

    public Cigar calculateCigar(byte[] refSeq, SmithWatermanAligner aligner) {
        return CigarUtils.calculateCigar(refSeq, this.getBases(), aligner, SWOverhangStrategy.SOFTCLIP);
    }
}

