/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Bytes;
import java.io.File;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MergeCommonSuffices;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MergeDiamonds;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MergeTails;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SplitCommonSuffices;
import org.broadinstitute.hellbender.utils.Utils;
import org.jgrapht.EdgeFactory;

public class SeqGraph
extends BaseGraph<SeqVertex, BaseEdge> {
    private final Logger logger = LogManager.getLogger(SeqGraph.class);
    private static final long serialVersionUID = 1L;
    private static final boolean PRINT_SIMPLIFY_GRAPHS = false;
    private static final int MAX_REASONABLE_SIMPLIFICATION_CYCLES = 100;

    public SeqGraph clone() {
        return (SeqGraph)super.clone();
    }

    public SeqGraph(int kmer) {
        super(kmer, new MyEdgeFactory());
    }

    public void simplifyGraph() {
        this.simplifyGraph(Integer.MAX_VALUE);
    }

    @VisibleForTesting
    void simplifyGraph(int maxCycles) {
        this.zipLinearChains();
        SeqGraph prevGraph = null;
        for (int i = 0; i < maxCycles; ++i) {
            if (i > 100) {
                this.logger.warn("Infinite loop detected in simpliciation routines.  Writing current graph to debugMeMark.dot");
                this.printGraph(new File("debugMeMark.dot"), 0);
                throw new IllegalStateException("Infinite loop detected in simplification routines for kmer graph " + this.getKmerSize());
            }
            boolean didSomeWork = this.simplifyGraphOnce(i);
            if (!didSomeWork) break;
            if (i <= 5) continue;
            if (prevGraph != null && SeqGraph.graphEquals(prevGraph, this)) break;
            prevGraph = this.clone();
        }
    }

    private boolean simplifyGraphOnce(int iteration) {
        this.printGraphSimplification(new File("simplifyGraph." + iteration + ".1.dot"));
        boolean didSomeWork = false;
        didSomeWork |= new MergeDiamonds(this).transformUntilComplete();
        didSomeWork |= new MergeTails(this).transformUntilComplete();
        this.printGraphSimplification(new File("simplifyGraph." + iteration + ".2.diamonds_and_tails.dot"));
        didSomeWork |= new SplitCommonSuffices(this).transformUntilComplete();
        this.printGraphSimplification(new File("simplifyGraph." + iteration + ".3.split_suffix.dot"));
        didSomeWork |= new MergeCommonSuffices(this).transformUntilComplete();
        this.printGraphSimplification(new File("simplifyGraph." + iteration + ".4.merge_suffix.dot"));
        return didSomeWork |= this.zipLinearChains();
    }

    private void printGraphSimplification(File file) {
    }

    public boolean zipLinearChains() {
        LinkedList<SeqVertex> zipStarts = new LinkedList<SeqVertex>();
        for (SeqVertex source : this.vertexSet()) {
            if (!this.isLinearChainStart(source)) continue;
            zipStarts.add(source);
        }
        if (zipStarts.isEmpty()) {
            return false;
        }
        boolean mergedOne = false;
        for (SeqVertex zipStart : zipStarts) {
            LinkedList<SeqVertex> linearChain = this.traceLinearChain(zipStart);
            mergedOne |= this.mergeLinearChain(linearChain);
        }
        return mergedOne;
    }

    protected boolean isLinearChainStart(SeqVertex source) {
        return this.outDegreeOf(source) == 1 && (this.inDegreeOf(source) != 1 || this.outDegreeOf(this.incomingVerticesOf(source).iterator().next()) > 1);
    }

    protected LinkedList<SeqVertex> traceLinearChain(SeqVertex zipStart) {
        boolean targetIsRef;
        SeqVertex target;
        LinkedList<SeqVertex> linearChain = new LinkedList<SeqVertex>();
        linearChain.add(zipStart);
        boolean lastIsRef = this.isReferenceNode(zipStart);
        SeqVertex last = zipStart;
        while (this.outDegreeOf(last) == 1 && this.inDegreeOf(target = (SeqVertex)this.getEdgeTarget(this.outgoingEdgeOf(last))) == 1 && !last.equals(target) && lastIsRef == (targetIsRef = this.isReferenceNode(target))) {
            linearChain.add(target);
            last = target;
            lastIsRef = targetIsRef;
        }
        return linearChain;
    }

    private boolean mergeLinearChain(LinkedList<SeqVertex> linearChain) {
        return null != this.mergeLinearChainVertex(linearChain);
    }

    @VisibleForTesting
    protected SeqVertex mergeLinearChainVertex(LinkedList<SeqVertex> linearChain) {
        Utils.validateArg(!linearChain.isEmpty(), () -> "BUG: cannot have linear chain with 0 elements but got " + linearChain);
        SeqVertex first = linearChain.getFirst();
        SeqVertex last = linearChain.getLast();
        if (first == last) {
            return null;
        }
        SeqVertex addedVertex = SeqGraph.mergeLinearChainVertices(linearChain);
        this.addVertex(addedVertex);
        for (BaseEdge edge : this.outgoingEdgesOf(last)) {
            this.addEdge(addedVertex, this.getEdgeTarget(edge), edge.copy());
        }
        for (BaseEdge edge : this.incomingEdgesOf(first)) {
            this.addEdge(this.getEdgeSource(edge), addedVertex, edge.copy());
        }
        this.removeAllVertices(linearChain);
        return addedVertex;
    }

    private static SeqVertex mergeLinearChainVertices(Iterable<SeqVertex> vertices) {
        LinkedList<byte[]> seqs = new LinkedList<byte[]>();
        for (SeqVertex v : vertices) {
            seqs.add(v.getSequence());
        }
        byte[] seqsCat = Bytes.concat((byte[][])((byte[][])seqs.toArray((T[])new byte[0][])));
        return new SeqVertex(seqsCat);
    }

    private static class MyEdgeFactory
    implements EdgeFactory<SeqVertex, BaseEdge> {
        private MyEdgeFactory() {
        }

        public BaseEdge createEdge(SeqVertex sourceVertex, SeqVertex targetVertex) {
            return new BaseEdge(false, 1);
        }
    }
}

