/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Arrays;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;

public final class SeqVertex
extends BaseVertex {
    public SeqVertex(byte[] sequence) {
        super(sequence);
    }

    public SeqVertex(String sequence) {
        super(sequence);
    }

    public int getId() {
        return this.hashCode();
    }

    @Override
    public String toString() {
        return "SeqVertex_id_" + this.hashCode() + "_seq_" + this.getSequenceString();
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public SeqVertex withoutSuffix(byte[] suffix) {
        int prefixSize = this.sequence.length - suffix.length;
        return prefixSize > 0 ? new SeqVertex(Arrays.copyOf(this.sequence, prefixSize)) : null;
    }

    public SeqVertex withoutPrefixAndSuffix(byte[] prefix, byte[] suffix) {
        int start = prefix.length;
        int length = this.sequence.length - suffix.length - prefix.length;
        int stop = start + length;
        return length > 0 ? new SeqVertex(Arrays.copyOfRange(this.sequence, start, stop)) : null;
    }
}

