/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.utils.Utils;

public final class SharedSequenceMerger {
    private SharedSequenceMerger() {
    }

    public static boolean merge(SeqGraph graph, SeqVertex v) {
        Utils.nonNull(graph, "graph cannot be null");
        Utils.validateArg(graph.vertexSet().contains(v), () -> "graph doesn't contain vertex " + v);
        Set<SeqVertex> prevs = graph.incomingVerticesOf(v);
        if (!SharedSequenceMerger.canMerge(graph, v, prevs)) {
            return false;
        }
        LinkedList<BaseEdge> edgesToRemove = new LinkedList<BaseEdge>();
        byte[] prevSeq = prevs.iterator().next().getSequence();
        SeqVertex newV = new SeqVertex(ArrayUtils.addAll((byte[])prevSeq, (byte[])v.getSequence()));
        graph.addVertex(newV);
        for (SeqVertex prev : prevs) {
            for (BaseEdge prevIn : graph.incomingEdgesOf(prev)) {
                graph.addEdge(graph.getEdgeSource(prevIn), newV, prevIn.copy());
                edgesToRemove.add(prevIn);
            }
        }
        for (BaseEdge e : graph.outgoingEdgesOf(v)) {
            graph.addEdge(newV, graph.getEdgeTarget(e), e.copy());
        }
        graph.removeAllVertices(prevs);
        graph.removeVertex(v);
        graph.removeAllEdges(edgesToRemove);
        return true;
    }

    private static boolean canMerge(SeqGraph graph, SeqVertex v, Collection<SeqVertex> incomingVertices) {
        if (incomingVertices.isEmpty()) {
            return false;
        }
        SeqVertex first = incomingVertices.iterator().next();
        for (SeqVertex prev : incomingVertices) {
            if (!prev.seqEquals(first)) {
                return false;
            }
            Set<SeqVertex> prevOuts = graph.outgoingVerticesOf(prev);
            if (prevOuts.size() != 1) {
                return false;
            }
            if (prevOuts.iterator().next() != v) {
                return false;
            }
            if (graph.inDegreeOf(prev) != 0) continue;
            return false;
        }
        return true;
    }
}

