/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.GraphUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.utils.Utils;

public final class SharedVertexSequenceSplitter {
    private final SeqGraph outer;
    private final SeqVertex prefixV;
    private final SeqVertex suffixV;
    private final Collection<SeqVertex> toSplits;
    private SeqGraph splitGraph = null;
    private Collection<SeqVertex> newMiddles = null;
    private List<BaseEdge> edgesToRemove = null;

    public SharedVertexSequenceSplitter(SeqGraph graph, Collection<SeqVertex> toSplitsArg) {
        Utils.nonNull(graph, "graph cannot be null");
        Utils.nonNull(toSplitsArg, "toSplitsArg cannot be null");
        Utils.validateArg(toSplitsArg.size() > 1, () -> "Can only split at least 2 vertices but only got " + toSplitsArg);
        Utils.validateArg(graph.vertexSet().containsAll(toSplitsArg), "graph doesn't contain all of the vertices to split");
        this.outer = graph;
        this.toSplits = toSplitsArg;
        Pair<SeqVertex, SeqVertex> prefixAndSuffix = SharedVertexSequenceSplitter.commonPrefixAndSuffixOfVertices(this.toSplits);
        this.prefixV = (SeqVertex)prefixAndSuffix.getLeft();
        this.suffixV = (SeqVertex)prefixAndSuffix.getRight();
    }

    public boolean splitAndUpdate(SeqVertex top, SeqVertex bottom) {
        this.split();
        this.updateGraph(top, bottom);
        return true;
    }

    public boolean meetsMinMergableSequenceForEitherPrefixOrSuffix(int minCommonSequence) {
        return this.meetsMinMergableSequenceForPrefix(minCommonSequence) || this.meetsMinMergableSequenceForSuffix(minCommonSequence);
    }

    public boolean meetsMinMergableSequenceForPrefix(int minCommonSequence) {
        return this.getPrefixV().length() >= minCommonSequence;
    }

    public boolean meetsMinMergableSequenceForSuffix(int minCommonSequence) {
        return this.getSuffixV().length() >= minCommonSequence;
    }

    public void split() {
        this.splitGraph = new SeqGraph(this.outer.getKmerSize());
        this.newMiddles = new LinkedList<SeqVertex>();
        this.edgesToRemove = new LinkedList<BaseEdge>();
        this.splitGraph.addVertices(new SeqVertex[]{this.getPrefixV(), this.getSuffixV()});
        for (SeqVertex mid : this.toSplits) {
            BaseEdge toMid = this.processEdgeToRemove(mid, (BaseEdge)this.outer.incomingEdgeOf(mid));
            BaseEdge fromMid = this.processEdgeToRemove(mid, (BaseEdge)this.outer.outgoingEdgeOf(mid));
            SeqVertex remaining = mid.withoutPrefixAndSuffix(this.getPrefixV().getSequence(), this.getSuffixV().getSequence());
            if (remaining != null) {
                this.splitGraph.addVertex(remaining);
                this.getNewMiddles().add(remaining);
                this.splitGraph.addEdge(this.getPrefixV(), remaining, toMid);
                this.splitGraph.addEdge(remaining, this.getSuffixV(), fromMid);
                continue;
            }
            this.splitGraph.addOrUpdateEdge(this.getPrefixV(), this.getSuffixV(), toMid.copy().add(fromMid));
        }
    }

    public void updateGraph(SeqVertex top, SeqVertex bot) {
        SeqVertex botForConnect;
        Utils.validateArg(this.outer.vertexSet().containsAll(this.toSplits), "graph doesn't contain all of the original vertices to split");
        Utils.validateArg(top != null || bot != null, "Cannot update graph without at least one top or bot vertex, but both were null");
        Utils.validateArg(top == null || this.outer.containsVertex(top), () -> "top " + top + " not found in graph " + (Object)((Object)this.outer));
        Utils.validateArg(bot == null || this.outer.containsVertex(bot), () -> "bot " + bot + " not found in graph " + (Object)((Object)this.outer));
        if (this.splitGraph == null) {
            throw new IllegalStateException("Cannot call updateGraph until split() has been called");
        }
        this.outer.removeAllVertices(this.toSplits);
        this.outer.removeAllEdges(this.edgesToRemove);
        this.outer.addVertices(this.getNewMiddles());
        boolean hasPrefixSuffixEdge = this.splitGraph.getEdge(this.getPrefixV(), this.getSuffixV()) != null;
        boolean hasOnlyPrefixSuffixEdges = hasPrefixSuffixEdge && this.splitGraph.outDegreeOf(this.getPrefixV()) == 1;
        boolean needPrefixNode = !this.getPrefixV().isEmpty() || top == null && !hasOnlyPrefixSuffixEdges;
        boolean needSuffixNode = !this.getSuffixV().isEmpty() || bot == null && !hasOnlyPrefixSuffixEdges;
        SeqVertex topForConnect = needPrefixNode ? this.getPrefixV() : top;
        SeqVertex seqVertex = botForConnect = needSuffixNode ? this.getSuffixV() : bot;
        if (needPrefixNode) {
            this.addPrefixNodeAndEdges(top);
        }
        if (needSuffixNode) {
            this.addSuffixNodeAndEdges(bot);
        }
        if (topForConnect != null) {
            this.addEdgesFromTopNode(topForConnect, botForConnect);
        }
        if (botForConnect != null) {
            this.addEdgesToBottomNode(botForConnect);
        }
    }

    private void addEdgesToBottomNode(SeqVertex botForConnect) {
        for (BaseEdge e : this.splitGraph.incomingEdgesOf(this.getSuffixV())) {
            this.outer.addEdge(this.splitGraph.getEdgeSource(e), botForConnect, e);
        }
    }

    private void addEdgesFromTopNode(SeqVertex topForConnect, SeqVertex botForConnect) {
        for (BaseEdge e : this.splitGraph.outgoingEdgesOf(this.getPrefixV())) {
            SeqVertex target = (SeqVertex)this.splitGraph.getEdgeTarget(e);
            if (target == this.getSuffixV()) {
                if (botForConnect == null) continue;
                this.outer.addEdge(topForConnect, botForConnect, e);
                continue;
            }
            this.outer.addEdge(topForConnect, target, e);
        }
    }

    private void addSuffixNodeAndEdges(SeqVertex bot) {
        this.outer.addVertex(this.getSuffixV());
        if (bot != null) {
            this.outer.addEdge(this.getSuffixV(), bot, BaseEdge.makeOREdge(this.splitGraph.incomingEdgesOf(this.getSuffixV()), 1));
        }
    }

    private void addPrefixNodeAndEdges(SeqVertex top) {
        this.outer.addVertex(this.getPrefixV());
        if (top != null) {
            this.outer.addEdge(top, this.getPrefixV(), BaseEdge.makeOREdge(this.splitGraph.outgoingEdgesOf(this.getPrefixV()), 1));
        }
    }

    @VisibleForTesting
    static Pair<SeqVertex, SeqVertex> commonPrefixAndSuffixOfVertices(Collection<SeqVertex> middleVertices) {
        ArrayList<byte[]> kmers = new ArrayList<byte[]>(middleVertices.size());
        int min = Integer.MAX_VALUE;
        for (SeqVertex v : middleVertices) {
            kmers.add(v.getSequence());
            min = Math.min(min, v.getSequence().length);
        }
        int prefixLen = GraphUtils.commonMaximumPrefixLength(kmers);
        int suffixLen = GraphUtils.commonMaximumSuffixLength(kmers, min - prefixLen);
        byte[] kmer = (byte[])kmers.get(0);
        byte[] prefix = Arrays.copyOfRange(kmer, 0, prefixLen);
        byte[] suffix = Arrays.copyOfRange(kmer, kmer.length - suffixLen, kmer.length);
        return new MutablePair((Object)new SeqVertex(prefix), (Object)new SeqVertex(suffix));
    }

    private BaseEdge processEdgeToRemove(SeqVertex v, BaseEdge e) {
        if (e == null) {
            return new BaseEdge(this.outer.isReferenceNode(v), 0);
        }
        this.edgesToRemove.add(e);
        return e.copy();
    }

    @VisibleForTesting
    SeqVertex getPrefixV() {
        return this.prefixV;
    }

    @VisibleForTesting
    SeqVertex getSuffixV() {
        return this.suffixV;
    }

    @VisibleForTesting
    SeqGraph getSplitGraph() {
        return this.splitGraph;
    }

    @VisibleForTesting
    Collection<SeqVertex> getNewMiddles() {
        return this.newMiddles;
    }
}

