/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import java.util.Collection;
import java.util.HashSet;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.CommonSuffixSplitter;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.VertexBasedTransformer;
import org.broadinstitute.hellbender.utils.Utils;

final class SplitCommonSuffices
extends VertexBasedTransformer {
    private final Collection<SeqVertex> alreadySplit = new HashSet<SeqVertex>();

    SplitCommonSuffices(SeqGraph graph) {
        super(graph);
    }

    @Override
    boolean tryToTransform(SeqVertex bottom) {
        Utils.nonNull(bottom);
        if (this.alreadySplit.contains(bottom)) {
            return false;
        }
        this.alreadySplit.add(bottom);
        return CommonSuffixSplitter.split(this.getGraph(), bottom);
    }
}

