/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs;

import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.utils.Utils;

abstract class VertexBasedTransformer {
    private boolean dontModifyGraphEvenIfPossible = false;
    private final SeqGraph graph;

    public boolean dontModifyGraphEvenIfPossible() {
        return this.dontModifyGraphEvenIfPossible;
    }

    public void setDontModifyGraphEvenIfPossible() {
        this.dontModifyGraphEvenIfPossible = true;
    }

    VertexBasedTransformer(SeqGraph graph) {
        Utils.nonNull(graph);
        this.graph = graph;
    }

    SeqGraph getGraph() {
        return this.graph;
    }

    public boolean transformUntilComplete() {
        boolean didAtLeastOneTransform = false;
        boolean foundNodesToMerge = true;
        block0: while (foundNodesToMerge) {
            foundNodesToMerge = false;
            for (SeqVertex v : this.graph.vertexSet()) {
                foundNodesToMerge = this.tryToTransform(v);
                if (!foundNodesToMerge) continue;
                didAtLeastOneTransform = true;
                continue block0;
            }
        }
        return didAtLeastOneTransform;
    }

    abstract boolean tryToTransform(SeqVertex var1);
}

