/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.Kmer;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.KmerSearchableGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MultiSampleEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.MultiDeBruijnVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingGraph;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAlignment;
import org.jgrapht.EdgeFactory;

public abstract class AbstractReadThreadingGraph
extends BaseGraph<MultiDeBruijnVertex, MultiSampleEdge>
implements KmerSearchableGraph<MultiDeBruijnVertex, MultiSampleEdge> {
    private static final long serialVersionUID = 1L;
    private static final String ANONYMOUS_SAMPLE = "XXX_UNNAMED_XXX";
    private static final boolean WRITE_GRAPH = false;
    private static final boolean DEBUG_NON_UNIQUE_CALC = false;
    private static final int MAX_CIGAR_COMPLEXITY = 3;
    private static final boolean INCREASE_COUNTS_BACKWARDS = true;
    private int minMatchingBasesToDangingEndRecovery = -1;
    private static int counter = 0;
    protected final Map<String, List<SequenceForKmers>> pending = new LinkedHashMap<String, List<SequenceForKmers>>();
    protected final Map<Kmer, MultiDeBruijnVertex> kmerToVertexMap = new LinkedHashMap<Kmer, MultiDeBruijnVertex>();
    protected final boolean debugGraphTransformations;
    protected final byte minBaseQualityToUseInAssembly;
    protected List<MultiDeBruijnVertex> referencePath = null;
    protected boolean alreadyBuilt = false;
    private Kmer refSource = null;
    private boolean startThreadingOnlyAtExistingVertex = false;
    private int maxMismatchesInDanglingHead = -1;
    private boolean increaseCountsThroughBranches = false;

    AbstractReadThreadingGraph(int kmerSize, EdgeFactory<MultiDeBruijnVertex, MultiSampleEdge> edgeFactory) {
        super(kmerSize, edgeFactory);
        this.debugGraphTransformations = false;
        this.minBaseQualityToUseInAssembly = 0;
    }

    public AbstractReadThreadingGraph(int kmerSize, boolean debugGraphTransformations, byte minBaseQualityToUseInAssembly, int numPruningSamples, int numDanglingMatchingPrefixBases) {
        super(kmerSize, new MyEdgeFactory(numPruningSamples));
        Utils.validateArg(kmerSize > 0, () -> "bad minkKmerSize " + kmerSize);
        this.debugGraphTransformations = debugGraphTransformations;
        this.minBaseQualityToUseInAssembly = minBaseQualityToUseInAssembly;
        this.minMatchingBasesToDangingEndRecovery = numDanglingMatchingPrefixBases;
    }

    protected abstract boolean isThreadingStart(Kmer var1, boolean var2);

    protected abstract MultiDeBruijnVertex getNextKmerVertexForChainExtension(Kmer var1, boolean var2, MultiDeBruijnVertex var3);

    protected abstract void preprocessReads();

    public abstract boolean isLowQualityGraph();

    protected abstract boolean shouldRemoveReadsAfterGraphConstruction();

    public abstract void postProcessForHaplotypeFinding(File var1, Locatable var2);

    protected abstract void trackKmer(Kmer var1, MultiDeBruijnVertex var2);

    @VisibleForTesting
    static boolean cigarIsOkayToMerge(Cigar cigar, boolean requireFirstElementM, boolean requireLastElementM) {
        List elements = cigar.getCigarElements();
        int numElements = elements.size();
        if (numElements == 0 || numElements > 3) {
            return false;
        }
        if (requireFirstElementM && ((CigarElement)elements.get(0)).getOperator() != CigarOperator.M) {
            return false;
        }
        return !requireLastElementM || ((CigarElement)elements.get(numElements - 1)).getOperator() == CigarOperator.M;
    }

    @VisibleForTesting
    static int longestSuffixMatch(byte[] seq, byte[] kmer, int seqStart) {
        for (int len = 1; len <= kmer.length; ++len) {
            int seqI = seqStart - len + 1;
            int kmerI = kmer.length - len;
            if (seqI >= 0 && seq[seqI] == kmer[kmerI]) continue;
            return len - 1;
        }
        return kmer.length;
    }

    @VisibleForTesting
    protected void setAlreadyBuilt() {
        this.alreadyBuilt = true;
    }

    @VisibleForTesting
    void setMinMatchingBasesToDangingEndRecovery(int minMatchingBasesToDangingEndRecovery) {
        this.minMatchingBasesToDangingEndRecovery = minMatchingBasesToDangingEndRecovery;
    }

    @VisibleForTesting
    void setMaxMismatchesInDanglingHead(int maxMismatchesInDanglingHead) {
        this.maxMismatchesInDanglingHead = maxMismatchesInDanglingHead;
    }

    protected int findStart(SequenceForKmers seqForKmers) {
        if (seqForKmers.isRef) {
            return 0;
        }
        for (int i = seqForKmers.start; i < seqForKmers.stop - this.kmerSize; ++i) {
            Kmer kmer1 = new Kmer(seqForKmers.sequence, i, this.kmerSize);
            if (!this.isThreadingStart(kmer1, this.startThreadingOnlyAtExistingVertex)) continue;
            return i;
        }
        return -1;
    }

    @VisibleForTesting
    public final void addSequence(byte[] sequence, boolean isRef) {
        this.addSequence("anonymous", sequence, isRef);
    }

    public final void addSequence(String seqName, byte[] sequence, boolean isRef) {
        this.addSequence(seqName, sequence, 1, isRef);
    }

    public final void addSequence(String seqName, byte[] sequence, int count, boolean isRef) {
        this.addSequence(seqName, ANONYMOUS_SAMPLE, sequence, 0, sequence.length, count, isRef);
    }

    protected void addSequence(String seqName, String sampleName, byte[] sequence, int start, int stop, int count, boolean isRef) {
        Utils.validate(!this.alreadyBuilt, "Attempting to add sequence to a graph that has already been built");
        List sampleSequences = this.pending.computeIfAbsent(sampleName, s -> new LinkedList());
        sampleSequences.add(new SequenceForKmers(seqName, sequence, start, stop, count, isRef));
    }

    private void threadSequence(SequenceForKmers seqForKmers) {
        int startPos = this.findStart(seqForKmers);
        if (startPos == -1) {
            return;
        }
        MultiDeBruijnVertex startingVertex = this.getOrCreateKmerVertex(seqForKmers.sequence, startPos);
        this.increaseCountsInMatchedKmers(seqForKmers, startingVertex, startingVertex.getSequence(), this.kmerSize - 2);
        if (this.debugGraphTransformations) {
            startingVertex.addRead(seqForKmers.name);
        }
        if (seqForKmers.isRef) {
            if (this.refSource != null) {
                throw new IllegalStateException("Found two refSources! prev: " + this.refSource + ", new: " + startingVertex);
            }
            this.referencePath = new ArrayList<MultiDeBruijnVertex>(seqForKmers.sequence.length - this.kmerSize);
            this.referencePath.add(startingVertex);
            this.refSource = new Kmer(seqForKmers.sequence, seqForKmers.start, this.kmerSize);
        }
        MultiDeBruijnVertex vertex = startingVertex;
        for (int i = startPos + 1; i <= seqForKmers.stop - this.kmerSize; ++i) {
            vertex = this.extendChainByOne(vertex, seqForKmers.sequence, i, seqForKmers.count, seqForKmers.isRef);
            if (seqForKmers.isRef) {
                this.referencePath.add(vertex);
            }
            if (!this.debugGraphTransformations) continue;
            vertex.addRead(seqForKmers.name);
        }
        if (seqForKmers.isRef) {
            this.referencePath = Collections.unmodifiableList(this.referencePath);
        }
    }

    public final void setThreadingStartOnlyAtExistingVertex(boolean value) {
        this.startThreadingOnlyAtExistingVertex = value;
    }

    public final void buildGraphIfNecessary() {
        if (this.alreadyBuilt) {
            return;
        }
        this.preprocessReads();
        for (List<SequenceForKmers> sequencesForSample : this.pending.values()) {
            for (SequenceForKmers sequenceForKmers : sequencesForSample) {
                this.threadSequence(sequenceForKmers);
            }
            for (MultiSampleEdge e : this.edgeSet()) {
                e.flushSingleSampleMultiplicity();
            }
        }
        if (this.shouldRemoveReadsAfterGraphConstruction()) {
            this.pending.clear();
        }
        this.alreadyBuilt = true;
        for (MultiDeBruijnVertex v : this.kmerToVertexMap.values()) {
            v.setAdditionalInfo(v.getAdditionalInfo() + '+');
        }
    }

    public boolean removeVertex(MultiDeBruijnVertex V) {
        boolean result = super.removeVertex((Object)V);
        if (result) {
            byte[] sequence = V.getSequence();
            Kmer kmer = new Kmer(sequence);
            this.kmerToVertexMap.remove(kmer);
        }
        return result;
    }

    @Override
    public void removeSingletonOrphanVertices() {
        LinkedList<MultiDeBruijnVertex> verticesToRemove = new LinkedList<MultiDeBruijnVertex>();
        for (MultiDeBruijnVertex v : this.vertexSet()) {
            if (this.inDegreeOf(v) != 0 || this.outDegreeOf(v) != 0) continue;
            verticesToRemove.add(v);
        }
        this.removeVertex(null);
        this.removeAllVertices(verticesToRemove);
    }

    @VisibleForTesting
    void setIncreaseCountsThroughBranches(boolean increaseCountsThroughBranches) {
        this.increaseCountsThroughBranches = increaseCountsThroughBranches;
    }

    public void recoverDanglingTails(int pruneFactor, int minDanglingBranchLength, boolean recoverAll, SmithWatermanAligner aligner) {
        Utils.validateArg(pruneFactor >= 0, () -> "pruneFactor must be non-negative but was " + pruneFactor);
        Utils.validateArg(minDanglingBranchLength >= 0, () -> "minDanglingBranchLength must be non-negative but was " + minDanglingBranchLength);
        if (!this.alreadyBuilt) {
            throw new IllegalStateException("recoverDanglingTails requires the graph be already built");
        }
        int attempted = 0;
        int nRecovered = 0;
        for (MultiDeBruijnVertex v : this.vertexSet()) {
            if (this.outDegreeOf(v) != 0 || this.isRefSink(v)) continue;
            ++attempted;
            nRecovered += this.recoverDanglingTail(v, pruneFactor, minDanglingBranchLength, recoverAll, aligner);
        }
        ReadThreadingGraph.logger.debug(String.format("Recovered %d of %d dangling tails", nRecovered, attempted));
    }

    public void recoverDanglingHeads(int pruneFactor, int minDanglingBranchLength, boolean recoverAll, SmithWatermanAligner aligner) {
        Utils.validateArg(pruneFactor >= 0, () -> "pruneFactor must be non-negative but was " + pruneFactor);
        Utils.validateArg(minDanglingBranchLength >= 0, () -> "minDanglingBranchLength must be non-negative but was " + minDanglingBranchLength);
        if (!this.alreadyBuilt) {
            throw new IllegalStateException("recoverDanglingHeads requires the graph be already built");
        }
        Collection danglingHeads = this.vertexSet().stream().filter(v -> this.inDegreeOf(v) == 0 && !this.isRefSource(v)).collect(Collectors.toList());
        int attempted = 0;
        int nRecovered = 0;
        for (MultiDeBruijnVertex v2 : danglingHeads) {
            ++attempted;
            nRecovered += this.recoverDanglingHead(v2, pruneFactor, minDanglingBranchLength, recoverAll, aligner);
        }
        ReadThreadingGraph.logger.debug(String.format("Recovered %d of %d dangling heads", nRecovered, attempted));
    }

    private int recoverDanglingTail(MultiDeBruijnVertex vertex, int pruneFactor, int minDanglingBranchLength, boolean recoverAll, SmithWatermanAligner aligner) {
        if (this.outDegreeOf(vertex) != 0) {
            throw new IllegalStateException("Attempting to recover a dangling tail for " + vertex + " but it has out-degree > 0");
        }
        DanglingChainMergeHelper danglingTailMergeResult = this.generateCigarAgainstDownwardsReferencePath(vertex, pruneFactor, minDanglingBranchLength, recoverAll, aligner);
        if (danglingTailMergeResult == null || !AbstractReadThreadingGraph.cigarIsOkayToMerge(danglingTailMergeResult.cigar, false, true)) {
            return 0;
        }
        return this.mergeDanglingTail(danglingTailMergeResult);
    }

    private Pair<Integer, Integer> bestPrefixMatch(List<CigarElement> cigarElements, byte[] path1, byte[] path2) {
        int matches;
        CigarElement ce2;
        int minMismatchingBases = this.getMinMatchingBases();
        int refIdx = cigarElements.stream().mapToInt(ce -> ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0).sum() - 1;
        int readIdx = path2.length - 1;
        Iterator iterator = Lists.reverse(cigarElements).iterator();
        block0: while (iterator.hasNext() && (ce2 = (CigarElement)iterator.next()).getOperator().consumesReadBases() && ce2.getOperator().consumesReferenceBases()) {
            int j = 0;
            while (j < ce2.getLength()) {
                if (path1[refIdx] != path2[readIdx]) break block0;
                ++j;
                --refIdx;
                --readIdx;
            }
        }
        return (matches = path2.length - 1 - readIdx) < minMismatchingBases ? Pair.of((Object)-1, (Object)-1) : Pair.of((Object)refIdx, (Object)readIdx);
    }

    private int getMinMatchingBases() {
        return this.minMatchingBasesToDangingEndRecovery;
    }

    private int recoverDanglingHead(MultiDeBruijnVertex vertex, int pruneFactor, int minDanglingBranchLength, boolean recoverAll, SmithWatermanAligner aligner) {
        if (this.inDegreeOf(vertex) != 0) {
            throw new IllegalStateException("Attempting to recover a dangling head for " + vertex + " but it has in-degree > 0");
        }
        DanglingChainMergeHelper danglingHeadMergeResult = this.generateCigarAgainstUpwardsReferencePath(vertex, pruneFactor, minDanglingBranchLength, recoverAll, aligner);
        if (danglingHeadMergeResult == null || !AbstractReadThreadingGraph.cigarIsOkayToMerge(danglingHeadMergeResult.cigar, true, false)) {
            return 0;
        }
        return this.minMatchingBasesToDangingEndRecovery >= 0 ? this.mergeDanglingHead(danglingHeadMergeResult) : this.mergeDanglingHeadLegacy(danglingHeadMergeResult);
    }

    @VisibleForTesting
    final int mergeDanglingTail(DanglingChainMergeHelper danglingTailMergeResult) {
        List elements = danglingTailMergeResult.cigar.getCigarElements();
        CigarElement lastElement = (CigarElement)elements.get(elements.size() - 1);
        Utils.validateArg(lastElement.getOperator() == CigarOperator.M, "The last Cigar element must be an M");
        int lastRefIndex = danglingTailMergeResult.cigar.getReferenceLength() - 1;
        int matchingSuffix = Math.min(AbstractReadThreadingGraph.longestSuffixMatch(danglingTailMergeResult.referencePathString, danglingTailMergeResult.danglingPathString, lastRefIndex), lastElement.getLength());
        if (this.minMatchingBasesToDangingEndRecovery >= 0 ? matchingSuffix < this.minMatchingBasesToDangingEndRecovery : matchingSuffix == 0) {
            return 0;
        }
        int altIndexToMerge = Math.max(danglingTailMergeResult.cigar.getReadLength() - matchingSuffix - 1, 0);
        boolean firstElementIsDeletion = ((CigarElement)elements.get(0)).getOperator() == CigarOperator.D;
        boolean mustHandleLeadingDeletionCase = firstElementIsDeletion && ((CigarElement)elements.get(0)).getLength() + matchingSuffix == lastRefIndex + 1;
        int refIndexToMerge = lastRefIndex - matchingSuffix + 1 + (mustHandleLeadingDeletionCase ? 1 : 0);
        if (refIndexToMerge == 0) {
            return 0;
        }
        this.addEdge(danglingTailMergeResult.danglingPath.get(altIndexToMerge), danglingTailMergeResult.referencePath.get(refIndexToMerge), ((MyEdgeFactory)this.getEdgeFactory()).createEdge(false, 1));
        return 1;
    }

    @VisibleForTesting
    int mergeDanglingHeadLegacy(DanglingChainMergeHelper danglingHeadMergeResult) {
        List elements = danglingHeadMergeResult.cigar.getCigarElements();
        CigarElement firstElement = (CigarElement)elements.get(0);
        Utils.validateArg(firstElement.getOperator() == CigarOperator.M, "The first Cigar element must be an M");
        int indexesToMerge = this.bestPrefixMatchLegacy(danglingHeadMergeResult.referencePathString, danglingHeadMergeResult.danglingPathString, firstElement.getLength());
        if (indexesToMerge <= 0) {
            return 0;
        }
        if (indexesToMerge >= danglingHeadMergeResult.referencePath.size() - 1) {
            return 0;
        }
        if (indexesToMerge >= danglingHeadMergeResult.danglingPath.size() && !this.extendDanglingPathAgainstReference(danglingHeadMergeResult, indexesToMerge - danglingHeadMergeResult.danglingPath.size() + 2, elements)) {
            return 0;
        }
        this.addEdge(danglingHeadMergeResult.referencePath.get(indexesToMerge + 1), danglingHeadMergeResult.danglingPath.get(indexesToMerge), ((MyEdgeFactory)this.getEdgeFactory()).createEdge(false, 1));
        return 1;
    }

    @VisibleForTesting
    int mergeDanglingHead(DanglingChainMergeHelper danglingHeadMergeResult) {
        List elements = danglingHeadMergeResult.cigar.getCigarElements();
        CigarElement firstElement = (CigarElement)elements.get(0);
        Utils.validateArg(firstElement.getOperator() == CigarOperator.M, "The first Cigar element must be an M");
        Pair<Integer, Integer> indexesToMerge = this.bestPrefixMatch(elements, danglingHeadMergeResult.referencePathString, danglingHeadMergeResult.danglingPathString);
        if ((Integer)indexesToMerge.getKey() <= 0 || (Integer)indexesToMerge.getValue() <= 0) {
            return 0;
        }
        if ((Integer)indexesToMerge.getKey() >= danglingHeadMergeResult.referencePath.size() - 1) {
            return 0;
        }
        if ((Integer)indexesToMerge.getValue() >= danglingHeadMergeResult.danglingPath.size() && !this.extendDanglingPathAgainstReference(danglingHeadMergeResult, (Integer)indexesToMerge.getValue() - danglingHeadMergeResult.danglingPath.size() + 2, elements)) {
            return 0;
        }
        this.addEdge(danglingHeadMergeResult.referencePath.get((Integer)indexesToMerge.getKey() + 1), danglingHeadMergeResult.danglingPath.get((Integer)indexesToMerge.getValue()), ((MyEdgeFactory)this.getEdgeFactory()).createEdge(false, 1));
        return 1;
    }

    @VisibleForTesting
    DanglingChainMergeHelper generateCigarAgainstDownwardsReferencePath(MultiDeBruijnVertex vertex, int pruneFactor, int minDanglingBranchLength, boolean recoverAll, SmithWatermanAligner aligner) {
        int minTailPathLength = Math.max(1, minDanglingBranchLength);
        List<MultiDeBruijnVertex> altPath = this.findPathUpwardsToLowestCommonAncestor(vertex, pruneFactor, !recoverAll);
        if (altPath == null || this.isRefSource((BaseVertex)altPath.get(0)) || altPath.size() < minTailPathLength + 1) {
            return null;
        }
        List<MultiDeBruijnVertex> refPath = this.getReferencePath(altPath.get(0), TraversalDirection.downwards, Optional.ofNullable(this.getHeaviestIncomingEdge(altPath.get(1))));
        byte[] refBases = this.getBasesForPath(refPath, false);
        byte[] altBases = this.getBasesForPath(altPath, false);
        SmithWatermanAlignment alignment = aligner.align(refBases, altBases, SmithWatermanAligner.STANDARD_NGS, SWOverhangStrategy.LEADING_INDEL);
        return new DanglingChainMergeHelper(altPath, refPath, altBases, refBases, AlignmentUtils.removeTrailingDeletions(alignment.getCigar()));
    }

    @VisibleForTesting
    DanglingChainMergeHelper generateCigarAgainstUpwardsReferencePath(MultiDeBruijnVertex vertex, int pruneFactor, int minDanglingBranchLength, boolean recoverAll, SmithWatermanAligner aligner) {
        List<MultiDeBruijnVertex> altPath = this.findPathDownwardsToHighestCommonDescendantOfReference(vertex, pruneFactor, !recoverAll);
        if (altPath == null || this.isRefSink((BaseVertex)altPath.get(0)) || altPath.size() < minDanglingBranchLength + 1) {
            return null;
        }
        List<MultiDeBruijnVertex> refPath = this.getReferencePath(altPath.get(0), TraversalDirection.upwards, Optional.empty());
        byte[] refBases = this.getBasesForPath(refPath, true);
        byte[] altBases = this.getBasesForPath(altPath, true);
        SmithWatermanAlignment alignment = aligner.align(refBases, altBases, SmithWatermanAligner.STANDARD_NGS, SWOverhangStrategy.LEADING_INDEL);
        return new DanglingChainMergeHelper(altPath, refPath, altBases, refBases, AlignmentUtils.removeTrailingDeletions(alignment.getCigar()));
    }

    private List<MultiDeBruijnVertex> findPathUpwardsToLowestCommonAncestor(MultiDeBruijnVertex vertex, int pruneFactor, boolean giveUpAtBranch) {
        return giveUpAtBranch ? this.findPath(vertex, pruneFactor, v -> this.inDegreeOf(v) != 1 || this.outDegreeOf(v) >= 2, v -> this.outDegreeOf(v) > 1, v -> (MultiSampleEdge)this.incomingEdgeOf(v), e -> (MultiDeBruijnVertex)this.getEdgeSource(e)) : this.findPath(vertex, pruneFactor, v -> this.hasIncidentRefEdge((MultiDeBruijnVertex)v) || this.inDegreeOf(v) == 0, v -> this.outDegreeOf(v) > 1 && this.hasIncidentRefEdge((MultiDeBruijnVertex)v), this::getHeaviestIncomingEdge, e -> (MultiDeBruijnVertex)this.getEdgeSource(e));
    }

    private boolean hasIncidentRefEdge(MultiDeBruijnVertex v) {
        for (MultiSampleEdge edge : this.incomingEdgesOf(v)) {
            if (!edge.isRef()) continue;
            return true;
        }
        return false;
    }

    private MultiSampleEdge getHeaviestIncomingEdge(MultiDeBruijnVertex v) {
        Set incomingEdges = this.incomingEdgesOf(v);
        return incomingEdges.size() == 1 ? (MultiSampleEdge)incomingEdges.iterator().next() : incomingEdges.stream().max(Comparator.comparingInt(BaseEdge::getMultiplicity)).get();
    }

    private List<MultiDeBruijnVertex> findPathDownwardsToHighestCommonDescendantOfReference(MultiDeBruijnVertex vertex, int pruneFactor, boolean giveUpAtBranch) {
        return giveUpAtBranch ? this.findPath(vertex, pruneFactor, v -> this.isReferenceNode(v) || this.outDegreeOf(v) != 1, v -> this.isReferenceNode(v), v -> (MultiSampleEdge)this.outgoingEdgeOf(v), e -> (MultiDeBruijnVertex)this.getEdgeTarget(e)) : this.findPath(vertex, pruneFactor, v -> this.isReferenceNode(v) || this.outDegreeOf(v) == 0, v -> this.isReferenceNode(v), this::getHeaviestOutgoingEdge, e -> (MultiDeBruijnVertex)this.getEdgeTarget(e));
    }

    private MultiSampleEdge getHeaviestOutgoingEdge(MultiDeBruijnVertex v) {
        Set outgoing = this.outgoingEdgesOf(v);
        return outgoing.size() == 1 ? (MultiSampleEdge)outgoing.iterator().next() : outgoing.stream().max(Comparator.comparingInt(BaseEdge::getMultiplicity)).get();
    }

    private List<MultiDeBruijnVertex> findPath(MultiDeBruijnVertex vertex, int pruneFactor, Predicate<MultiDeBruijnVertex> done, Predicate<MultiDeBruijnVertex> returnPath, Function<MultiDeBruijnVertex, MultiSampleEdge> nextEdge, Function<MultiSampleEdge, MultiDeBruijnVertex> nextNode) {
        LinkedList<MultiDeBruijnVertex> path = new LinkedList<MultiDeBruijnVertex>();
        HashSet<MultiDeBruijnVertex> visitedNodes = new HashSet<MultiDeBruijnVertex>();
        MultiDeBruijnVertex v = vertex;
        while (!done.test(v)) {
            MultiSampleEdge edge = nextEdge.apply(v);
            if (edge.getPruningMultiplicity() < pruneFactor) {
                visitedNodes.addAll(path);
                path.clear();
            } else {
                path.addFirst(v);
            }
            if (!path.contains(v = nextNode.apply(edge)) && !visitedNodes.contains(v)) continue;
            System.err.println("Dangling End recovery killed because of a loop (findPath)");
            return null;
        }
        path.addFirst(v);
        return returnPath.test(v) ? path : null;
    }

    protected List<MultiDeBruijnVertex> getReferencePath(MultiDeBruijnVertex start, TraversalDirection direction, Optional<MultiSampleEdge> blacklistedEdge) {
        ArrayList<MultiDeBruijnVertex> path = new ArrayList<MultiDeBruijnVertex>();
        MultiDeBruijnVertex v = start;
        while (v != null) {
            path.add(v);
            v = direction == TraversalDirection.downwards ? this.getNextReferenceVertex(v, true, blacklistedEdge) : this.getPrevReferenceVertex(v);
        }
        return path;
    }

    @VisibleForTesting
    byte[] getBasesForPath(List<MultiDeBruijnVertex> path, boolean expandSource) {
        Utils.nonNull(path, "Path cannot be null");
        StringBuilder sb = new StringBuilder();
        for (MultiDeBruijnVertex v : path) {
            if (expandSource && this.isSource(v)) {
                String seq = v.getSequenceString();
                sb.append(new StringBuilder(seq).reverse().toString());
                continue;
            }
            sb.append((char)v.getSuffix());
        }
        return sb.toString().getBytes();
    }

    private int bestPrefixMatchLegacy(byte[] path1, byte[] path2, int maxIndex) {
        int maxMismatches = this.getMaxMismatchesLegacy(maxIndex);
        int mismatches = 0;
        int lastGoodIndex = -1;
        for (int index = 0; index < maxIndex; ++index) {
            if (path1[index] == path2[index]) continue;
            if (++mismatches > maxMismatches) {
                return -1;
            }
            lastGoodIndex = index;
        }
        return lastGoodIndex;
    }

    private int getMaxMismatchesLegacy(int lengthOfDanglingBranch) {
        return this.maxMismatchesInDanglingHead > 0 ? this.maxMismatchesInDanglingHead : Math.max(1, lengthOfDanglingBranch / this.kmerSize);
    }

    private boolean extendDanglingPathAgainstReference(DanglingChainMergeHelper danglingHeadMergeResult, int numNodesToExtend, List<CigarElement> elements) {
        int offsetForRefEndToDanglingEnd;
        int indexOfLastDanglingNode = danglingHeadMergeResult.danglingPath.size() - 1;
        int indexOfRefNodeToUse = indexOfLastDanglingNode + (offsetForRefEndToDanglingEnd = elements.stream().mapToInt(ce -> (ce.getOperator().consumesReferenceBases() ? ce.getLength() : 0) - (ce.getOperator().consumesReadBases() ? ce.getLength() : 0)).sum()) + numNodesToExtend;
        if (indexOfRefNodeToUse >= danglingHeadMergeResult.referencePath.size()) {
            return false;
        }
        MultiDeBruijnVertex danglingSource = danglingHeadMergeResult.danglingPath.remove(indexOfLastDanglingNode);
        StringBuilder sb = new StringBuilder();
        byte[] refSourceSequence = danglingHeadMergeResult.referencePath.get(indexOfRefNodeToUse).getSequence();
        for (int i = 0; i < numNodesToExtend; ++i) {
            sb.append((char)refSourceSequence[i]);
        }
        sb.append(danglingSource.getSequenceString());
        byte[] sequenceToExtend = sb.toString().getBytes();
        MultiSampleEdge sourceEdge = this.getHeaviestOutgoingEdge(danglingSource);
        MultiDeBruijnVertex prevV = (MultiDeBruijnVertex)this.getEdgeTarget(sourceEdge);
        this.removeEdge(danglingSource, prevV);
        for (int i = numNodesToExtend; i > 0; --i) {
            MultiDeBruijnVertex newV = new MultiDeBruijnVertex(Arrays.copyOfRange(sequenceToExtend, i, i + this.kmerSize));
            this.addVertex(newV);
            MultiSampleEdge newE = (MultiSampleEdge)this.addEdge(newV, prevV);
            newE.setMultiplicity(sourceEdge.getMultiplicity());
            danglingHeadMergeResult.danglingPath.add(newV);
            prevV = newV;
        }
        return true;
    }

    private void increaseCountsInMatchedKmers(SequenceForKmers seqForKmers, MultiDeBruijnVertex vertex, byte[] originalKmer, int offset) {
        if (offset == -1) {
            return;
        }
        for (MultiSampleEdge edge : this.incomingEdgesOf(vertex)) {
            byte seqBase;
            MultiDeBruijnVertex prev = (MultiDeBruijnVertex)this.getEdgeSource(edge);
            byte suffix = prev.getSuffix();
            if (suffix != (seqBase = originalKmer[offset]) || !this.increaseCountsThroughBranches && this.inDegreeOf(vertex) != 1) continue;
            edge.incMultiplicity(seqForKmers.count);
            this.increaseCountsInMatchedKmers(seqForKmers, prev, originalKmer, offset - 1);
        }
    }

    private MultiDeBruijnVertex getOrCreateKmerVertex(byte[] sequence, int start) {
        Kmer kmer = new Kmer(sequence, start, this.kmerSize);
        MultiDeBruijnVertex vertex = this.getKmerVertex(kmer, true);
        return vertex != null ? vertex : this.createVertex(kmer);
    }

    protected MultiDeBruijnVertex getKmerVertex(Kmer kmer, boolean allowRefSource) {
        if (!allowRefSource && kmer.equals(this.refSource)) {
            return null;
        }
        return this.kmerToVertexMap.get(kmer);
    }

    private MultiDeBruijnVertex createVertex(Kmer kmer) {
        MultiDeBruijnVertex newVertex = new MultiDeBruijnVertex(kmer.bases());
        int prevSize = this.vertexSet().size();
        this.addVertex(newVertex);
        if (this.vertexSet().size() != prevSize + 1) {
            throw new IllegalStateException("Adding vertex " + newVertex + " to graph didn't increase the graph size");
        }
        this.trackKmer(kmer, newVertex);
        return newVertex;
    }

    protected MultiDeBruijnVertex extendChainByOne(MultiDeBruijnVertex prevVertex, byte[] sequence, int kmerStart, int count, boolean isRef) {
        Set outgoingEdges = this.outgoingEdgesOf(prevVertex);
        int nextPos = kmerStart + this.kmerSize - 1;
        for (MultiSampleEdge outgoingEdge : outgoingEdges) {
            MultiDeBruijnVertex target = (MultiDeBruijnVertex)this.getEdgeTarget(outgoingEdge);
            if (target.getSuffix() != sequence[nextPos]) continue;
            outgoingEdge.incMultiplicity(count);
            return target;
        }
        Kmer kmer = new Kmer(sequence, kmerStart, this.kmerSize);
        MultiDeBruijnVertex mergeVertex = this.getNextKmerVertexForChainExtension(kmer, isRef, prevVertex);
        MultiDeBruijnVertex nextVertex = mergeVertex == null ? this.createVertex(kmer) : mergeVertex;
        this.addEdge(prevVertex, nextVertex, ((MyEdgeFactory)this.getEdgeFactory()).createEdge(isRef, count));
        return nextVertex;
    }

    @VisibleForTesting
    void addRead(GATKRead read, SAMFileHeader header) {
        byte[] sequence = read.getBases();
        byte[] qualities = read.getBaseQualities();
        int lastGood = -1;
        for (int end = 0; end <= sequence.length; ++end) {
            if (end == sequence.length || !this.baseIsUsableForAssembly(sequence[end], qualities[end])) {
                int start = lastGood;
                int len = end - start;
                if (start != -1 && len >= this.kmerSize) {
                    String name = read.getName() + '_' + start + '_' + end;
                    this.addSequence(name, ReadUtils.getSampleName(read, header), sequence, start, end, 1, false);
                }
                lastGood = -1;
                continue;
            }
            if (lastGood != -1) continue;
            lastGood = end;
        }
    }

    protected boolean baseIsUsableForAssembly(byte base, byte qual) {
        return base != BaseUtils.Base.N.base && qual >= this.minBaseQualityToUseInAssembly;
    }

    @Override
    public MultiDeBruijnVertex findKmer(Kmer k) {
        return this.kmerToVertexMap.get(k);
    }

    static final class SequenceForKmers {
        final String name;
        final byte[] sequence;
        final int start;
        final int stop;
        final int count;
        final boolean isRef;

        SequenceForKmers(String name, byte[] sequence, int start, int stop, int count, boolean ref) {
            Utils.nonNull(sequence, "Sequence is null ");
            Utils.validateArg(start >= 0, () -> "Invalid start " + start);
            Utils.validateArg(stop >= start, () -> "Invalid stop " + stop);
            Utils.validateArg(count > 0, "Invalid count " + count);
            this.name = name;
            this.sequence = sequence;
            this.start = start;
            this.stop = stop;
            this.count = count;
            this.isRef = ref;
        }
    }

    static final class DanglingChainMergeHelper {
        final List<MultiDeBruijnVertex> danglingPath;
        final List<MultiDeBruijnVertex> referencePath;
        final byte[] danglingPathString;
        final byte[] referencePathString;
        final Cigar cigar;

        DanglingChainMergeHelper(List<MultiDeBruijnVertex> danglingPath, List<MultiDeBruijnVertex> referencePath, byte[] danglingPathString, byte[] referencePathString, Cigar cigar) {
            this.danglingPath = danglingPath;
            this.referencePath = referencePath;
            this.danglingPathString = danglingPathString;
            this.referencePathString = referencePathString;
            this.cigar = cigar;
        }
    }

    protected static final class MyEdgeFactory
    implements EdgeFactory<MultiDeBruijnVertex, MultiSampleEdge> {
        final int numPruningSamples;

        MyEdgeFactory(int numPruningSamples) {
            this.numPruningSamples = numPruningSamples;
        }

        public MultiSampleEdge createEdge(MultiDeBruijnVertex sourceVertex, MultiDeBruijnVertex targetVertex) {
            return new MultiSampleEdge(false, 1, this.numPruningSamples);
        }

        MultiSampleEdge createEdge(boolean isRef, int multiplicity) {
            return new MultiSampleEdge(isRef, multiplicity, this.numPruningSamples);
        }
    }

    protected static enum TraversalDirection {
        downwards,
        upwards;

    }
}

