/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.Kmer;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MultiSampleEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqVertex;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.AbstractReadThreadingGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.MultiDeBruijnVertex;
import org.broadinstitute.hellbender.utils.Utils;

public class JunctionTreeLinkedDeBruijnGraph
extends AbstractReadThreadingGraph {
    private static final long serialVersionUID = 1L;
    private static final MultiDeBruijnVertex SYMBOLIC_END_VETEX = new MultiDeBruijnVertex(new byte[]{95});
    private MultiSampleEdge SYMBOLIC_END_EDGE;
    private Map<MultiDeBruijnVertex, ThreadingTree> readThreadingJunctionTrees = new HashMap<MultiDeBruijnVertex, ThreadingTree>();
    private final Set<Kmer> kmers = new HashSet<Kmer>();

    @VisibleForTesting
    public JunctionTreeLinkedDeBruijnGraph(int kmerSize) {
        this(kmerSize, false, 6, 1, -1);
    }

    JunctionTreeLinkedDeBruijnGraph(int kmerSize, boolean debugGraphTransformations, byte minBaseQualityToUseInAssembly, int numPruningSamples, int numDanglingMatchingPrefixBases) {
        super(kmerSize, debugGraphTransformations, minBaseQualityToUseInAssembly, numPruningSamples, numDanglingMatchingPrefixBases);
    }

    protected int findStartForJunctionThreading(AbstractReadThreadingGraph.SequenceForKmers seqForKmers) {
        for (int i = seqForKmers.start; i < seqForKmers.stop - this.kmerSize; ++i) {
            Kmer kmer1 = new Kmer(seqForKmers.sequence, i, this.kmerSize);
            if (!this.kmerToVertexMap.containsKey(kmer1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void preprocessReads() {
    }

    @Override
    protected boolean shouldRemoveReadsAfterGraphConstruction() {
        return false;
    }

    @Override
    public boolean isLowQualityGraph() {
        return false;
    }

    @Override
    protected boolean isThreadingStart(Kmer kmer, boolean startThreadingOnlyAtExistingVertex) {
        Utils.nonNull(kmer);
        return !startThreadingOnlyAtExistingVertex || this.kmers.contains(kmer);
    }

    @Override
    protected List<MultiDeBruijnVertex> getReferencePath(MultiDeBruijnVertex start, AbstractReadThreadingGraph.TraversalDirection direction, Optional<MultiSampleEdge> blacklistedEdge) {
        if (direction == AbstractReadThreadingGraph.TraversalDirection.downwards) {
            return this.getReferencePathForwardFromKmer(start, blacklistedEdge);
        }
        return this.getReferencePathBackwardsForKmer(start);
    }

    @Override
    protected void trackKmer(Kmer kmer, MultiDeBruijnVertex newVertex) {
        this.kmerToVertexMap.putIfAbsent(kmer, newVertex);
    }

    @VisibleForTesting
    List<MultiDeBruijnVertex> getReferencePath(AbstractReadThreadingGraph.TraversalDirection direction) {
        return Collections.unmodifiableList(direction == AbstractReadThreadingGraph.TraversalDirection.downwards ? this.referencePath : Lists.reverse((List)this.referencePath));
    }

    protected MultiDeBruijnVertex extendJunctionThreadingByOne(MultiDeBruijnVertex prevVertex, byte[] sequence, int kmerStart, JunctionTreeThreadingHelper nodesHelper, boolean alterTrees) {
        Set outgoingEdges = this.outgoingEdgesOf(prevVertex);
        int nextPos = kmerStart + this.kmerSize - 1;
        for (MultiSampleEdge outgoingEdge : outgoingEdges) {
            MultiDeBruijnVertex target = (MultiDeBruijnVertex)this.getEdgeTarget(outgoingEdge);
            if (target.getSuffix() != sequence[nextPos]) continue;
            if (alterTrees) {
                nodesHelper.addTreeIfNecessary(prevVertex);
                if (outgoingEdges.size() != 1) {
                    nodesHelper.addEdgeToJunctionTreeNodes(outgoingEdge);
                }
            }
            return target;
        }
        return null;
    }

    @Override
    public final MultiDeBruijnVertex getReferenceSourceVertex() {
        return this.referencePath != null && !this.referencePath.isEmpty() ? (MultiDeBruijnVertex)this.referencePath.get(0) : null;
    }

    @Override
    public final MultiDeBruijnVertex getReferenceSinkVertex() {
        return this.referencePath != null && !this.referencePath.isEmpty() ? (MultiDeBruijnVertex)this.referencePath.get(this.referencePath.size() - 1) : null;
    }

    private List<MultiDeBruijnVertex> getReferencePathForwardFromKmer(MultiDeBruijnVertex targetKmer, Optional<MultiSampleEdge> blacklistedEdge) {
        ArrayList<MultiDeBruijnVertex> extraSequence = new ArrayList<MultiDeBruijnVertex>(2);
        MultiDeBruijnVertex vert = targetKmer;
        int finalIndex = this.referencePath.lastIndexOf(vert);
        while (finalIndex == -1 && vert != null) {
            extraSequence.add(vert);
            Set outgoingEdges = this.outgoingEdgesOf(vert);
            Set blacklistedEdgeSet = blacklistedEdge.isPresent() ? Collections.singleton(blacklistedEdge.get()) : Collections.emptySet();
            List edges = outgoingEdges.stream().filter(e -> !blacklistedEdgeSet.contains(e)).limit(2L).collect(Collectors.toList());
            MultiDeBruijnVertex multiDeBruijnVertex = vert = edges.size() == 1 ? (MultiDeBruijnVertex)this.getEdgeTarget(edges.get(0)) : null;
            if (extraSequence.contains(vert)) {
                System.err.println("Dangling End recovery killed because of a loop (getReferencePathForwardFromKmer)");
                vert = null;
            }
            finalIndex = vert == null ? -1 : this.referencePath.lastIndexOf(vert);
        }
        extraSequence.addAll(finalIndex != -1 ? this.referencePath.subList(finalIndex, this.referencePath.size()) : Collections.emptyList());
        return extraSequence;
    }

    private List<MultiDeBruijnVertex> getReferencePathBackwardsForKmer(MultiDeBruijnVertex targetKmer) {
        int firstIndex = this.referencePath.indexOf(targetKmer);
        if (firstIndex == -1) {
            return Collections.singletonList(targetKmer);
        }
        return Lists.reverse(this.referencePath.subList(0, firstIndex + 1));
    }

    @Override
    public SeqGraph toSequenceGraph() {
        throw new UnsupportedOperationException("Cannot construct a sequence graph using JunctionTreeLinkedDeBruijnGraph");
    }

    @VisibleForTesting
    public final void printSimplifiedGraph(File destination, int pruneFactor) {
        try (PrintStream stream = new PrintStream(new FileOutputStream(destination));){
            this.printSimplifiedGraph(stream, true, pruneFactor);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(destination.getAbsolutePath(), (Exception)e);
        }
    }

    private final void printSimplifiedGraph(PrintStream graphWriter, boolean writeHeader, int pruneFactor) {
        class PrintingSeqGraph
        extends SeqGraph {
            private static final long serialVersionUID = 1L;
            private Map<MultiDeBruijnVertex, SeqVertex> vertexToOrigionalSeqVertex;
            private Map<SeqVertex, SeqVertex> originalSeqVertexToMergedVerex;

            PrintingSeqGraph(int kmerSize) {
                super(kmerSize);
            }

            @Override
            public List<String> getExtraGraphFileLines() {
                ArrayList<String> output = new ArrayList<String>();
                for (Map.Entry entry : JunctionTreeLinkedDeBruijnGraph.this.readThreadingJunctionTrees.entrySet()) {
                    SeqVertex mergedSeqVertex = this.originalSeqVertexToMergedVerex.get(this.vertexToOrigionalSeqVertex.get(entry.getKey()));
                    output.add(String.format("\t%s -> %s ", mergedSeqVertex.toString(), ((ThreadingTree)entry.getValue()).rootNode.getDotName()) + String.format("[color=blue];", new Object[0]));
                    output.add(String.format("\t%s [shape=point];", ((ThreadingTree)entry.getValue()).rootNode.getDotName()));
                    output.addAll(JunctionTreeLinkedDeBruijnGraph.this.edgesForNodeRecursive(((ThreadingTree)entry.getValue()).rootNode));
                }
                return output;
            }

            private Map<SeqVertex, SeqVertex> zipLinearChainsWithVertexMapping() {
                HashMap<SeqVertex, SeqVertex> vertexMapping = new HashMap<SeqVertex, SeqVertex>();
                Collection zipStarts = this.vertexSet().stream().filter(this::isLinearChainStart).collect(Collectors.toList());
                if (zipStarts.isEmpty()) {
                    return vertexMapping;
                }
                for (SeqVertex zipStart : zipStarts) {
                    LinkedList<SeqVertex> linearChain = this.traceLinearChain(zipStart);
                    SeqVertex mergedOne = this.mergeLinearChainVertex(linearChain);
                    if (mergedOne != null) {
                        for (SeqVertex v : linearChain) {
                            vertexMapping.put(v, mergedOne);
                        }
                        continue;
                    }
                    for (SeqVertex v : linearChain) {
                        vertexMapping.put(v, v);
                    }
                }
                return vertexMapping;
            }
        }
        PrintingSeqGraph printingSeqGraph = new PrintingSeqGraph(this.kmerSize);
        HashMap<MultiDeBruijnVertex, SeqVertex> vertexToOrigionalSeqVertex = new HashMap<MultiDeBruijnVertex, SeqVertex>();
        for (MultiDeBruijnVertex dv : this.vertexSet()) {
            SeqVertex sv = new SeqVertex(dv.getAdditionalSequence(this.isSource(dv)));
            sv.setAdditionalInfo(dv.getAdditionalInfo());
            vertexToOrigionalSeqVertex.put(dv, sv);
            printingSeqGraph.addVertex(sv);
        }
        for (MultiSampleEdge e : this.edgeSet()) {
            SeqVertex seqInV = (SeqVertex)vertexToOrigionalSeqVertex.get(this.getEdgeSource(e));
            SeqVertex seqOutV = (SeqVertex)vertexToOrigionalSeqVertex.get(this.getEdgeTarget(e));
            printingSeqGraph.addEdge(seqInV, seqOutV, new BaseEdge(e.isRef(), e.getMultiplicity()));
        }
        Map originalSeqVertexToMergedVerex = printingSeqGraph.zipLinearChainsWithVertexMapping();
        printingSeqGraph.originalSeqVertexToMergedVerex = originalSeqVertexToMergedVerex;
        printingSeqGraph.vertexToOrigionalSeqVertex = vertexToOrigionalSeqVertex;
        printingSeqGraph.printGraph(graphWriter, writeHeader, pruneFactor);
    }

    @Override
    public byte[] getReferenceBytes(MultiDeBruijnVertex fromVertex, MultiDeBruijnVertex toVertex, boolean includeStart, boolean includeStop) {
        Utils.nonNull(fromVertex, "Starting vertex in requested path cannot be null.");
        Utils.nonNull(toVertex, "From vertex in requested path cannot be null.");
        byte[] bytes = null;
        int fromIndex = this.referencePath.indexOf(fromVertex);
        int toIndex = this.referencePath.lastIndexOf(toVertex);
        if (includeStart) {
            bytes = ArrayUtils.addAll(bytes, (byte[])JunctionTreeLinkedDeBruijnGraph.getAdditionalSequence(fromVertex, true));
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            bytes = ArrayUtils.addAll((byte[])bytes, (byte[])this.getAdditionalSequence((BaseVertex)this.referencePath.get(i)));
        }
        if (includeStop) {
            bytes = ArrayUtils.addAll((byte[])bytes, (byte[])this.getAdditionalSequence(toVertex));
        }
        return bytes;
    }

    @Override
    protected MultiDeBruijnVertex getNextKmerVertexForChainExtension(Kmer kmer, boolean isRef, MultiDeBruijnVertex prevVertex) {
        return (MultiDeBruijnVertex)this.kmerToVertexMap.get(kmer);
    }

    @Override
    public void postProcessForHaplotypeFinding(File debugGraphOutputPath, Locatable refHaplotype) {
        this.annotateEdgesWithReferenceIndices();
        this.generateJunctionTrees();
        if (this.debugGraphTransformations) {
            this.printGraph(new File(debugGraphOutputPath, refHaplotype + "-sequenceGraph." + this.kmerSize + ".0.4.JT_unpruned.dot"), 10000);
        }
        this.pruneJunctionTrees(1);
        if (this.debugGraphTransformations) {
            this.printGraph(new File(debugGraphOutputPath, refHaplotype + "-sequenceGraph." + this.kmerSize + ".0.5.JT_pruned.dot"), 10000);
        }
    }

    private void annotateEdgesWithReferenceIndices() {
        List<MultiDeBruijnVertex> referencePath = this.getReferencePath(AbstractReadThreadingGraph.TraversalDirection.downwards);
        MultiDeBruijnVertex lastVert = null;
        int refIndex = 0;
        for (MultiDeBruijnVertex nextVert : referencePath) {
            if (lastVert != null) {
                ((MultiSampleEdge)this.getEdge(lastVert, nextVert)).addReferenceIndex(refIndex++);
            }
            lastVert = nextVert;
        }
    }

    public void generateJunctionTrees() {
        Utils.validate(this.alreadyBuilt, "Assembly graph has not been constructed, please call BuildGraphIfNecessary() before trying to thread reads to the graph");
        this.addVertex(SYMBOLIC_END_VETEX);
        this.SYMBOLIC_END_EDGE = (MultiSampleEdge)this.addEdge(this.getReferenceSinkVertex(), SYMBOLIC_END_VETEX);
        this.readThreadingJunctionTrees = new HashMap<MultiDeBruijnVertex, ThreadingTree>();
        this.pending.values().stream().flatMap(Collection::stream).forEach(this::threadSequenceForJuncitonTree);
    }

    public void pruneJunctionTrees(int minimumEdgeWeight) {
        this.readThreadingJunctionTrees.forEach((key, value) -> value.getRootNode().pruneNode(minimumEdgeWeight));
        this.readThreadingJunctionTrees = Maps.filterValues(this.readThreadingJunctionTrees, rec$ -> ((ThreadingTree)rec$).isEmptyTree());
    }

    private void threadSequenceForJuncitonTree(AbstractReadThreadingGraph.SequenceForKmers seqForKmers) {
        MultiDeBruijnVertex startingVertex;
        if (seqForKmers.isRef) {
            return;
        }
        JunctionTreeThreadingHelper nodeHelper = new JunctionTreeThreadingHelper();
        int startPos = this.findStartForJunctionThreading(seqForKmers);
        if (startPos == -1) {
            return;
        }
        MultiDeBruijnVertex lastVertex = startingVertex = (MultiDeBruijnVertex)this.kmerToVertexMap.get(new Kmer(seqForKmers.sequence, startPos, this.kmerSize));
        boolean hasToRediscoverKmer = false;
        for (int i = startPos + 1; i <= seqForKmers.stop - this.kmerSize; ++i) {
            MultiDeBruijnVertex vertex;
            if (!hasToRediscoverKmer) {
                vertex = this.extendJunctionThreadingByOne(lastVertex, seqForKmers.sequence, i, nodeHelper, true);
            } else {
                Kmer kmer = new Kmer(seqForKmers.sequence, i, this.kmerSize);
                vertex = (MultiDeBruijnVertex)this.kmerToVertexMap.get(kmer);
            }
            if (vertex == null && !hasToRediscoverKmer) {
                Set outgoingEdges = this.outgoingEdgesOf(lastVertex);
                MultiDeBruijnVertex tentativeVertex = null;
                if (outgoingEdges.size() == 1) {
                    tentativeVertex = (MultiDeBruijnVertex)this.getEdgeTarget(outgoingEdges.stream().findFirst().get());
                }
                for (int j = i + 1; j <= seqForKmers.stop - this.kmerSize && j <= i + this.kmerSize && tentativeVertex != null; ++j) {
                    tentativeVertex = this.extendJunctionThreadingByOne(tentativeVertex, seqForKmers.sequence, j, null, false);
                }
                if (tentativeVertex != null) {
                    vertex = (MultiDeBruijnVertex)this.getEdgeTarget(outgoingEdges.stream().findFirst().get());
                }
            }
            if (vertex != null) {
                lastVertex = vertex;
                hasToRediscoverKmer = false;
                continue;
            }
            nodeHelper.clear();
            hasToRediscoverKmer = true;
        }
        if (lastVertex == this.getReferenceSinkVertex()) {
            nodeHelper.addEdgeToJunctionTreeNodes(this.SYMBOLIC_END_EDGE);
        }
    }

    @Override
    public List<String> getExtraGraphFileLines() {
        ArrayList<String> output = new ArrayList<String>();
        for (Map.Entry<MultiDeBruijnVertex, ThreadingTree> entry : this.readThreadingJunctionTrees.entrySet()) {
            output.add(String.format("\t%s -> %s ", entry.getKey().toString(), entry.getValue().rootNode.getDotName()) + String.format("[color=blue];", new Object[0]));
            output.add(String.format("\t%s [shape=point];", entry.getValue().rootNode.getDotName()));
            output.addAll(this.edgesForNodeRecursive(entry.getValue().rootNode));
        }
        return output;
    }

    private List<String> edgesForNodeRecursive(ThreadingNode node) {
        ArrayList<String> output = new ArrayList<String>();
        for (Map.Entry childrenNode : node.childrenNodes.entrySet()) {
            output.add(String.format("\t%s -> %s ", node.getDotName(), ((ThreadingNode)childrenNode.getValue()).getDotName() + String.format("[color=blue,label=\"%d\"];", ((ThreadingNode)childrenNode.getValue()).count)));
            output.add(String.format("\t%s [label=\"%s\",shape=plaintext]", ((ThreadingNode)childrenNode.getValue()).getDotName(), new String(((MultiDeBruijnVertex)this.getEdgeTarget(childrenNode.getKey())).getAdditionalSequence(false))));
            output.addAll(this.edgesForNodeRecursive((ThreadingNode)childrenNode.getValue()));
        }
        return output;
    }

    public Optional<ThreadingTree> getJunctionTreeForNode(MultiDeBruijnVertex vertex) {
        return Optional.ofNullable(this.readThreadingJunctionTrees.get(vertex));
    }

    @VisibleForTesting
    public Map<MultiDeBruijnVertex, ThreadingTree> getReadThreadingJunctionTrees(boolean pruned) {
        return pruned ? Maps.filterValues(Collections.unmodifiableMap(this.readThreadingJunctionTrees), n -> ((ThreadingTree)n).isEmptyTree()) : Collections.unmodifiableMap(this.readThreadingJunctionTrees);
    }

    private class JunctionTreeThreadingHelper {
        final List<ThreadingNode> trackedNodes = new ArrayList<ThreadingNode>(3);

        private JunctionTreeThreadingHelper() {
        }

        private boolean vertexWarrantsJunctionTree(MultiDeBruijnVertex vertex) {
            return JunctionTreeLinkedDeBruijnGraph.this.outgoingEdgesOf(vertex).stream().anyMatch(edge -> JunctionTreeLinkedDeBruijnGraph.this.inDegreeOf(JunctionTreeLinkedDeBruijnGraph.this.getEdgeTarget(edge)) > 1);
        }

        private void addEdgeToJunctionTreeNodes(MultiSampleEdge outgoingEdge) {
            List newNodes = this.trackedNodes.stream().map(n -> ((ThreadingNode)n).addEdge(outgoingEdge)).collect(Collectors.toList());
            this.trackedNodes.clear();
            this.trackedNodes.addAll(newNodes);
        }

        private void clear() {
            this.trackedNodes.clear();
        }

        private void addTreeIfNecessary(MultiDeBruijnVertex prevVertex) {
            if (this.vertexWarrantsJunctionTree(prevVertex)) {
                this.trackedNodes.add(JunctionTreeLinkedDeBruijnGraph.this.readThreadingJunctionTrees.computeIfAbsent(prevVertex, k -> new ThreadingTree(prevVertex)).getAndIncrementRootNode());
            }
        }
    }

    public class ThreadingNode {
        private Map<MultiSampleEdge, ThreadingNode> childrenNodes;
        private final MultiSampleEdge prevEdge;
        private int count = 0;

        private ThreadingNode(MultiSampleEdge edge) {
            this.prevEdge = edge;
            this.childrenNodes = new HashMap<MultiSampleEdge, ThreadingNode>(2);
        }

        private ThreadingNode addEdge(MultiSampleEdge edge) {
            ThreadingNode nextNode = this.childrenNodes.computeIfAbsent(edge, k -> new ThreadingNode(edge));
            nextNode.incrementCount();
            return nextNode;
        }

        void incrementCount() {
            ++this.count;
        }

        private void incrementNode(List<MultiSampleEdge> edges, int index) {
            this.incrementCount();
            if (index < edges.size()) {
                this.getNode(edges.get(index)).incrementNode(edges, index + 1);
            }
        }

        private ThreadingNode getNode(MultiSampleEdge edge) {
            ThreadingNode nextNode = this.childrenNodes.get(edge);
            if (nextNode == null) {
                nextNode = new ThreadingNode(edge);
                this.childrenNodes.put(edge, nextNode);
            }
            return nextNode;
        }

        @VisibleForTesting
        private List<List<MultiSampleEdge>> getEdgesThroughNode() {
            ArrayList<List<MultiSampleEdge>> paths = new ArrayList<List<MultiSampleEdge>>();
            if (this.childrenNodes.isEmpty()) {
                paths.add(this.prevEdge == null ? new ArrayList() : Lists.newArrayList((Object[])new MultiSampleEdge[]{this.prevEdge}));
            }
            for (ThreadingNode childNode : this.childrenNodes.values()) {
                for (List<MultiSampleEdge> subPath : childNode.getEdgesThroughNode()) {
                    ArrayList pathRoot = this.prevEdge == null ? new ArrayList() : Lists.newArrayList((Object[])new MultiSampleEdge[]{this.prevEdge});
                    pathRoot.addAll(subPath);
                    paths.add(pathRoot);
                }
            }
            return paths;
        }

        private void pruneNode(int threshold) {
            this.childrenNodes = Maps.filterValues(this.childrenNodes, node -> node.getEvidenceCount() >= threshold);
            this.childrenNodes.forEach((edge, node) -> node.pruneNode(threshold));
        }

        public String getDotName() {
            return "TreadingNode_" + Integer.toHexString(this.hashCode());
        }

        public Map<MultiSampleEdge, ThreadingNode> getChildrenNodes() {
            return Collections.unmodifiableMap(this.childrenNodes);
        }

        public boolean hasNoEvidence() {
            return this.childrenNodes.isEmpty();
        }

        public int getEvidenceCount() {
            return this.count;
        }

        public boolean isSymbolicEnd() {
            return this.prevEdge == JunctionTreeLinkedDeBruijnGraph.this.SYMBOLIC_END_EDGE;
        }
    }

    public class ThreadingTree {
        private final ThreadingNode rootNode;
        private final MultiDeBruijnVertex treeVertex;

        private ThreadingTree(MultiDeBruijnVertex treeVertex) {
            this.rootNode = new ThreadingNode(null);
            this.treeVertex = treeVertex;
        }

        private ThreadingNode getAndIncrementRootNode() {
            this.rootNode.incrementCount();
            return this.rootNode;
        }

        private boolean isEmptyTree() {
            return !this.rootNode.childrenNodes.isEmpty();
        }

        @VisibleForTesting
        List<String> getPathsPresentAsBaseChoiceStrings() {
            return this.rootNode.getEdgesThroughNode().stream().map(path -> path.stream().map(edge -> ((MultiDeBruijnVertex)JunctionTreeLinkedDeBruijnGraph.this.getEdgeTarget(edge)).getSuffix()).map(b -> Character.toString((char)b.byteValue())).collect(Collectors.joining())).collect(Collectors.toList());
        }

        public String toString() {
            return "ThreadingTree_at_" + this.treeVertex.getSequenceString() + "_with_evidence_" + this.rootNode.count;
        }

        public ThreadingNode getRootNode() {
            return this.rootNode;
        }
    }
}

