/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading;

import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.BaseVertex;
import org.broadinstitute.hellbender.utils.Utils;

public final class MultiDeBruijnVertex
extends BaseVertex {
    private static final byte[][] sufficesAsByteArray = new byte[256][];
    private static final boolean KEEP_TRACK_OF_READS = false;
    private final List<String> reads = new LinkedList<String>();
    private final boolean mergeIdenticalNodes;
    private final int hashCode;

    public MultiDeBruijnVertex(byte[] sequence, boolean mergeIdenticalNodes) {
        super(sequence);
        this.mergeIdenticalNodes = mergeIdenticalNodes;
        this.hashCode = mergeIdenticalNodes ? super.hashCode() : System.identityHashCode(this);
    }

    public MultiDeBruijnVertex(byte[] sequence) {
        this(sequence, false);
    }

    @Override
    public boolean equals(Object o) {
        if (this.mergeIdenticalNodes) {
            return super.equals(o);
        }
        return o == this;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return "MultiDeBruijnVertex_id_" + this.hashCode() + "_seq_" + this.getSequenceString();
    }

    public void addRead(String name) {
        Utils.nonNull(name, "name cannot be null");
    }

    @Override
    public String getAdditionalInfo() {
        if (this.reads.contains("ref")) {
            return super.getAdditionalInfo();
        }
        return super.getAdditionalInfo() + "";
    }

    public int getKmerSize() {
        return this.sequence.length;
    }

    public String getSuffixString() {
        return new String(this.getSuffixAsArray());
    }

    public byte getSuffix() {
        return this.sequence[this.getKmerSize() - 1];
    }

    private byte[] getSuffixAsArray() {
        return sufficesAsByteArray[this.getSuffix()];
    }

    @Override
    public byte[] getAdditionalSequence(boolean source) {
        return source ? super.getAdditionalSequence(source) : this.getSuffixAsArray();
    }

    static {
        for (int i = 0; i < sufficesAsByteArray.length; ++i) {
            MultiDeBruijnVertex.sufficesAsByteArray[i] = new byte[]{(byte)(i & 0xFF)};
        }
    }
}

