/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.Kmer;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.MultiSampleEdge;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.graphs.SeqGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.AbstractReadThreadingGraph;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.MultiDeBruijnVertex;
import org.broadinstitute.hellbender.utils.Utils;
import org.jgrapht.EdgeFactory;

public class ReadThreadingGraph
extends AbstractReadThreadingGraph {
    protected static final Logger logger = LogManager.getLogger(ReadThreadingGraph.class);
    private static final long serialVersionUID = 1L;
    protected Set<Kmer> nonUniqueKmers = null;

    public ReadThreadingGraph(int kmerSize) {
        this(kmerSize, false, 6, 1, -1);
    }

    @VisibleForTesting
    protected ReadThreadingGraph(int kmerSizeFromString, EdgeFactory<MultiDeBruijnVertex, MultiSampleEdge> edgeFactory) {
        super(kmerSizeFromString, new AbstractReadThreadingGraph.MyEdgeFactory(1));
    }

    ReadThreadingGraph(int kmerSize, boolean debugGraphTransformations, byte minBaseQualityToUseInAssembly, int numPruningSamples, int numDanglingMatchingPrefixBases) {
        super(kmerSize, debugGraphTransformations, minBaseQualityToUseInAssembly, numPruningSamples, numDanglingMatchingPrefixBases);
    }

    @Override
    protected void preprocessReads() {
        this.nonUniqueKmers = ReadThreadingGraph.determineNonUniques(this.kmerSize, this.getAllPendingSequences());
    }

    @Override
    protected boolean shouldRemoveReadsAfterGraphConstruction() {
        return true;
    }

    @Override
    public boolean isLowQualityGraph() {
        return this.nonUniqueKmers.size() * 4 > this.kmerToVertexMap.size();
    }

    @Override
    protected void trackKmer(Kmer kmer, MultiDeBruijnVertex newVertex) {
        if (!this.nonUniqueKmers.contains(kmer) && !this.kmerToVertexMap.containsKey(kmer)) {
            this.kmerToVertexMap.put(kmer, newVertex);
        }
    }

    @Override
    public ReadThreadingGraph clone() {
        return (ReadThreadingGraph)super.clone();
    }

    @Override
    protected boolean isThreadingStart(Kmer kmer, boolean startThreadingOnlyAtExistingVertex) {
        Utils.nonNull(kmer);
        return startThreadingOnlyAtExistingVertex ? this.kmerToVertexMap.containsKey(kmer) : !this.nonUniqueKmers.contains(kmer);
    }

    private static Set<Kmer> determineNonUniques(int kmerSize, Collection<AbstractReadThreadingGraph.SequenceForKmers> withNonUniques) {
        HashSet<Kmer> nonUniqueKmers = new HashSet<Kmer>();
        Iterator<AbstractReadThreadingGraph.SequenceForKmers> it = withNonUniques.iterator();
        while (it.hasNext()) {
            AbstractReadThreadingGraph.SequenceForKmers sequenceForKmers = it.next();
            Collection<Kmer> nonUniquesFromSeq = ReadThreadingGraph.determineNonUniqueKmers(sequenceForKmers, kmerSize);
            if (nonUniquesFromSeq.isEmpty()) {
                it.remove();
                continue;
            }
            nonUniqueKmers.addAll(nonUniquesFromSeq);
        }
        return nonUniqueKmers;
    }

    private Collection<AbstractReadThreadingGraph.SequenceForKmers> getAllPendingSequences() {
        return this.pending.values().stream().flatMap(oneSampleWorth -> oneSampleWorth.stream()).collect(Collectors.toList());
    }

    static Collection<Kmer> determineNonUniqueKmers(AbstractReadThreadingGraph.SequenceForKmers seqForKmers, int kmerSize) {
        LinkedHashSet<Kmer> allKmers = new LinkedHashSet<Kmer>();
        ArrayList<Kmer> nonUniqueKmers = new ArrayList<Kmer>();
        int stopPosition = seqForKmers.stop - kmerSize;
        for (int i = 0; i <= stopPosition; ++i) {
            Kmer kmer = new Kmer(seqForKmers.sequence, i, kmerSize);
            if (allKmers.add(kmer)) continue;
            nonUniqueKmers.add(kmer);
        }
        return nonUniqueKmers;
    }

    @Override
    public SeqGraph toSequenceGraph() {
        this.buildGraphIfNecessary();
        return super.toSequenceGraph();
    }

    @VisibleForTesting
    Set<Kmer> getNonUniqueKmers() {
        return this.nonUniqueKmers;
    }

    @Override
    protected MultiDeBruijnVertex getNextKmerVertexForChainExtension(Kmer kmer, boolean isRef, MultiDeBruijnVertex prevVertex) {
        MultiDeBruijnVertex uniqueMergeVertex = this.getKmerVertex(kmer, false);
        Utils.validate(!isRef || uniqueMergeVertex == null, "Found a unique vertex to merge into the reference graph " + prevVertex + " -> " + uniqueMergeVertex);
        return uniqueMergeVertex;
    }

    @Override
    public void postProcessForHaplotypeFinding(File debugGraphOutputPath, Locatable refHaplotype) {
    }

    @Override
    public String toString() {
        return "ReadThreadingAssembler{kmerSize=" + this.kmerSize + '}';
    }
}

