/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.HashSet;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.tools.walkers.readorientation.BetaDistributionShape;
import org.broadinstitute.hellbender.tools.walkers.validation.basicshortmutpileup.BetaBinomialDistribution;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.OptimizationUtils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;

@CommandLineProgramProperties(summary="Make a panel of normals (PoN) for use with Mutect2", oneLineSummary="Make a panel of normals for use with Mutect2", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
@BetaFeature
public class CreateSomaticPanelOfNormals
extends VariantWalker {
    public static final String MIN_SAMPLE_COUNT_LONG_NAME = "min-sample-count";
    public static final int DEFAULT_MIN_SAMPLE_COUNT = 2;
    public static final String MAX_GERMLINE_PROBABILITY_LONG_NAME = "max-germline-probability";
    public static final double DEFAULT_MAX_GERMLINE_PROBABILITY = 0.5;
    public static final String FRACTION_INFO_FIELD = "FRACTION";
    public static final String BETA_SHAPE_INFO_FIELD = "BETA";
    private static final double ARTIFACT_PRIOR = 0.001;
    private static final double ARTIFACT_ALPHA = 1.0;
    private static final double ARTIFACT_BETA = 7.0;
    private static final double NEGLIGIBLE_ALLELE_FREQUENCY = 1.0E-8;
    @Argument(fullName="min-sample-count", doc="Number of samples containing a variant site required to include it in the panel of normals.", optional=true)
    private int minSampleCount = 2;
    @Argument(fullName="output", shortName="O", doc="Output vcf")
    private String outputVcf;
    @Argument(fullName="germline-resource", doc="Population vcf of germline sequencing containing allele fractions.", optional=true)
    public FeatureInput<VariantContext> germlineResource;
    @Argument(fullName="max-germline-probability", doc="Skip genotypes with germline probability greater than this value", optional=true)
    public double maxGermlineProbability = 0.5;
    private VariantContextWriter vcfWriter;
    private int numSamples;

    @Override
    public void onTraversalStart() {
        HashSet<VCFHeaderLine> headerInfo = new HashSet<VCFHeaderLine>(this.getDefaultToolVCFHeaderLines());
        headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine(FRACTION_INFO_FIELD, 1, VCFHeaderLineType.Float, "Fraction of samples exhibiting artifact"));
        headerInfo.add((VCFHeaderLine)new VCFInfoHeaderLine(BETA_SHAPE_INFO_FIELD, 2, VCFHeaderLineType.Float, "Beta distribution parameters to fit artifact allele fractions"));
        this.getHeaderForVariants().getGenotypeSamples().forEach(sample -> headerInfo.add(new VCFHeaderLine("normal_sample", sample)));
        this.vcfWriter = this.createVCFWriter(IOUtils.getPath(this.outputVcf));
        VCFHeader outputHeader = new VCFHeader(headerInfo);
        outputHeader.setSequenceDictionary(this.getHeaderForVariants().getSequenceDictionary());
        this.vcfWriter.writeHeader(outputHeader);
        this.numSamples = this.getHeaderForVariants().getNGenotypeSamples();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void apply(VariantContext vc, ReadsContext rc, ReferenceContext ref, FeatureContext fc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final boolean hasArtifact(Genotype g, double populationAlleleFrequency) {
        int altCount = CreateSomaticPanelOfNormals.altCount(g);
        if (altCount == 0) {
            return false;
        }
        int totalCount = (int)MathUtils.sum(g.getAD());
        return CreateSomaticPanelOfNormals.germlineProbability(populationAlleleFrequency, altCount, totalCount) < this.maxGermlineProbability;
    }

    private static final int altCount(Genotype g) {
        return g.hasAD() ? (int)MathUtils.sum(g.getAD()) - g.getAD()[0] : 0;
    }

    private static final double germlineProbability(double alleleFrequency, int altCount, int totalCount) {
        if (alleleFrequency < 1.0E-8 || alleleFrequency > 1.0) {
            return 0.0;
        }
        double hetPrior = alleleFrequency * (1.0 - alleleFrequency) * 2.0;
        double homPrior = MathUtils.square(alleleFrequency);
        double hetLikelihood = MathUtils.binomialProbability(totalCount, altCount, 0.5);
        double homLikelihood = MathUtils.binomialProbability(totalCount, altCount, 0.98);
        double artifactLikelihood = new BetaBinomialDistribution(null, 1.0, 7.0, totalCount).probability(altCount);
        double[] relativeProbsOfHetHomArtifact = new double[]{hetPrior * hetLikelihood + homPrior * homLikelihood, 0.001 * artifactLikelihood};
        return MathUtils.sum(relativeProbsOfHetHomArtifact) < 0.0 ? 0.0 : MathUtils.normalizeSumToOne(relativeProbsOfHetHomArtifact)[0];
    }

    private BetaDistributionShape fitBeta(List<int[]> altAndRefCounts) {
        int totalAltCount = altAndRefCounts.stream().mapToInt(pair -> pair[0]).sum();
        int totalRefCount = altAndRefCounts.stream().mapToInt(pair -> pair[1]).sum();
        int min = Math.min(totalAltCount, totalRefCount);
        double baseAlpha = ((double)totalAltCount + 1.0) / (double)(min + 1);
        double baseBeta = ((double)totalRefCount + 1.0) / (double)(min + 1);
        DoubleUnaryOperator logLikelihood = s -> {
            double alpha = baseAlpha * s;
            double beta = baseBeta * s;
            return altAndRefCounts.stream().mapToDouble(pair -> {
                int n = pair[0] + pair[1];
                int k = pair[0];
                return new BetaBinomialDistribution(null, alpha, beta, n).logProbability(k);
            }).sum();
        };
        double scale = OptimizationUtils.max(logLikelihood, 0.01, 100.0, 1.0, 0.01, 0.1, 100).getPoint();
        return new BetaDistributionShape(baseAlpha * scale, baseBeta * scale);
    }

    @Override
    public Object onTraversalSuccess() {
        return "SUCCESS";
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

