/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.MutectReadThreadingAssemblerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadThreadingAssemblerArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;
import org.broadinstitute.hellbender.tools.walkers.readorientation.CollectF1R2CountsArgumentCollection;
import org.broadinstitute.hellbender.utils.MathUtils;

public class M2ArgumentCollection
extends AssemblyBasedCallerArgumentCollection
implements Serializable {
    private static final long serialVersionUID = 9341L;
    public static final String TUMOR_SAMPLE_LONG_NAME = "tumor-sample";
    public static final String TUMOR_SAMPLE_SHORT_NAME = "tumor";
    public static final String NORMAL_SAMPLE_LONG_NAME = "normal-sample";
    public static final String NORMAL_SAMPLE_SHORT_NAME = "normal";
    public static final String PANEL_OF_NORMALS_LONG_NAME = "panel-of-normals";
    public static final String PANEL_OF_NORMALS_SHORT_NAME = "pon";
    public static final String GENOTYPE_PON_SITES_LONG_NAME = "genotype-pon-sites";
    public static final String GENOTYPE_GERMLINE_SITES_LONG_NAME = "genotype-germline-sites";
    public static final String GERMLINE_RESOURCE_LONG_NAME = "germline-resource";
    public static final String DEFAULT_AF_LONG_NAME = "af-of-alleles-not-in-resource";
    public static final String DEFAULT_AF_SHORT_NAME = "default-af";
    public static final String EMISSION_LOD_LONG_NAME = "tumor-lod-to-emit";
    public static final String EMISSION_LOG_SHORT_NAME = "emit-lod";
    public static final String INITIAL_TUMOR_LOG_10_ODDS_LONG_NAME = "initial-tumor-lod";
    public static final String INITIAL_TUMOR_LOG_10_ODDS_SHORT_NAME = "init-lod";
    public static final String MAX_POPULATION_AF_LONG_NAME = "max-population-af";
    public static final String MAX_POPULATION_AF_SHORT_NAME = "max-af";
    public static final String DOWNSAMPLING_STRIDE_LONG_NAME = "downsampling-stride";
    public static final String DOWNSAMPLING_STRIDE_SHORT_NAME = "stride";
    public static final String MAX_SUSPICIOUS_READS_PER_ALIGNMENT_START_LONG_NAME = "max-suspicious-reads-per-alignment-start";
    public static final String NORMAL_LOG_10_ODDS_LONG_NAME = "normal-lod";
    public static final String IGNORE_ITR_ARTIFACTS_LONG_NAME = "ignore-itr-artifacts";
    public static final String MITOCHONDRIA_MODE_LONG_NAME = "mitochondria-mode";
    public static final String CALLABLE_DEPTH_LONG_NAME = "callable-depth";
    public static final String PCR_SNV_QUAL_LONG_NAME = "pcr-snv-qual";
    public static final String PCR_INDEL_QUAL_LONG_NAME = "pcr-indel-qual";
    public static final String F1R2_TAR_GZ_NAME = "f1r2-tar-gz";
    public static final double DEFAULT_AF_FOR_TUMOR_ONLY_CALLING = 5.0E-8;
    public static final double DEFAULT_AF_FOR_TUMOR_NORMAL_CALLING = 1.0E-6;
    public static final double DEFAULT_AF_FOR_MITO_CALLING = 0.004;
    public static final double DEFAULT_EMISSION_LOG_10_ODDS = 3.0;
    public static final double DEFAULT_MITO_EMISSION_LOD = 0.0;
    public static final double DEFAULT_INITIAL_LOG_10_ODDS = 2.0;
    public static final double DEFAULT_NORMAL_LOG_10_ODDS = 2.2;
    public static final double DEFAULT_MITO_INITIAL_LOG_10_ODDS = 0.0;
    public static final double DEFAULT_GVCF_LOG_10_ODDS = Double.NEGATIVE_INFINITY;
    public static final int DEFAULT_CALLABLE_DEPTH = 10;
    public static final double DEFAULT_MITO_PRUNING_LOG_ODDS_THRESHOLD = MathUtils.log10ToLog(-4.0);
    public static final String INDEPENDENT_MATES_LONG_NAME = "independent-mates";
    public static final String MINIMUM_ALLELE_FRACTION_LONG_NAME = "minimum-allele-fraction";
    public static final String MINIMUM_ALLELE_FRACTION_SHORT_NAME = "min-AF";
    public static final String LOD_BAND_LONG_NAME = "gvcf-lod-band";
    public static final String LOD_BAND_SHORT_NAME = "LODB";
    @ArgumentCollection
    public CollectF1R2CountsArgumentCollection f1r2Args = new CollectF1R2CountsArgumentCollection();
    @Argument(fullName="f1r2-tar-gz", doc="If specified, collect F1R2 counts and output files into this tar.gz file", optional=true)
    public File f1r2TarGz;
    @Deprecated
    @Argument(fullName="tumor-sample", shortName="tumor", doc="BAM sample name of tumor.  May be URL-encoded as output by GetSampleName with -encode argument.", optional=true)
    protected String tumorSample = null;
    @Argument(fullName="normal-sample", shortName="normal", doc="BAM sample name of normal(s), if any.  May be URL-encoded as output by GetSampleName with -encode argument.", optional=true)
    protected List<String> normalSamples = new ArrayList<String>();
    @Argument(fullName="panel-of-normals", shortName="pon", doc="VCF file of sites observed in normal.", optional=true)
    public FeatureInput<VariantContext> pon;
    @Argument(fullName="genotype-pon-sites", doc="Call sites in the PoN even though they will ultimately be filtered.", optional=true)
    public boolean genotypePonSites = false;
    @Argument(fullName="genotype-germline-sites", doc="(EXPERIMENTAL) Call all apparent germline site even though they will ultimately be filtered.", optional=true)
    public boolean genotypeGermlineSites = false;
    @Argument(fullName="germline-resource", doc="Population vcf of germline sequencing containing allele fractions.", optional=true)
    public FeatureInput<VariantContext> germlineResource;
    @Argument(fullName="af-of-alleles-not-in-resource", shortName="default-af", doc="Population allele fraction assigned to alleles not found in germline resource.  Please see docs/mutect/mutect2.pdf fora derivation of the default value.", optional=true)
    private double afOfAllelesNotInGermlineResource = -1.0;
    @Argument(fullName="mitochondria-mode", optional=true, doc="Mitochondria mode sets emission and initial LODs to 0.")
    public Boolean mitochondria = false;
    @Argument(fullName="tumor-lod-to-emit", shortName="emit-lod", optional=true, doc="Log 10 odds threshold to emit variant to VCF.")
    private double emissionLog10Odds = 3.0;
    @Argument(fullName="initial-tumor-lod", shortName="init-lod", optional=true, doc="Log 10 odds threshold to consider pileup active.")
    private double initialLog10Odds = 2.0;
    @Argument(fullName="pcr-snv-qual", optional=true, doc="Phred-scaled PCR SNV qual for overlapping fragments")
    public int pcrSnvQual = 40;
    @Argument(fullName="pcr-indel-qual", optional=true, doc="Phred-scaled PCR indel qual for overlapping fragments")
    public int pcrIndelQual = 40;
    @Argument(fullName="max-population-af", shortName="max-af", optional=true, doc="Maximum population allele frequency in tumor-only mode.")
    public double maxPopulationAlleleFrequency = 0.01;
    @Argument(fullName="downsampling-stride", shortName="stride", optional=true, doc="Downsample a pool of reads starting within a range of one or more bases.")
    public int downsamplingStride = 1;
    @Argument(fullName="callable-depth", optional=true, doc="Minimum depth to be considered callable for Mutect stats.  Does not affect genotyping.")
    public int callableDepth = 10;
    @Advanced
    @Argument(fullName="max-suspicious-reads-per-alignment-start", optional=true, doc="Maximum number of suspicious reads (mediocre mapping quality or too many substitutions) allowed in a downsampling stride.  Set to 0 to disable.")
    public int maxSuspiciousReadsPerAlignmentStart = 0;
    @Argument(fullName="normal-lod", optional=true, doc="Log 10 odds threshold for calling normal variant non-germline.")
    public double normalLog10Odds = 2.2;
    @Argument(fullName="ignore-itr-artifacts", doc="Turn off read transformer that clips artifacts associated with end repair insertions near inverted tandem repeats.", optional=true)
    public boolean dontClipITRArtifacts = false;
    @Advanced
    @Argument(fullName="gvcf-lod-band", shortName="LODB", doc="Exclusive upper bounds for reference confidence LOD bands (must be specified in increasing order)", optional=true)
    public List<Double> GVCFGQBands = new ArrayList<Double>(70);
    @Advanced
    @Argument(fullName="minimum-allele-fraction", shortName="min-AF", doc="Lower bound of variant allele fractions to consider when calculating variant LOD", optional=true)
    public double minAF;
    @Advanced
    @Argument(fullName="independent-mates", doc="Allow paired reads to independently support different haplotypes.  Useful for validations with ill-designed synthetic data.", optional=true)
    public boolean independentMates;

    public M2ArgumentCollection() {
        for (double i = -2.5; i <= 1.0; i += 0.5) {
            this.GVCFGQBands.add(i);
        }
        this.minAF = 0.0;
        this.independentMates = false;
    }

    @Override
    protected int getDefaultMaxMnpDistance() {
        return 1;
    }

    @Override
    protected ReadThreadingAssemblerArgumentCollection getReadThreadingAssemblerArgumentCollection() {
        return new MutectReadThreadingAssemblerArgumentCollection();
    }

    @Override
    public ReadThreadingAssembler createReadThreadingAssembler() {
        if (this.mitochondria.booleanValue()) {
            this.assemblerArgs.recoverAllDanglingBranches = true;
            if (this.assemblerArgs.pruningLogOddsThreshold == ReadThreadingAssemblerArgumentCollection.DEFAULT_PRUNING_LOG_ODDS_THRESHOLD) {
                this.assemblerArgs.pruningLogOddsThreshold = DEFAULT_MITO_PRUNING_LOG_ODDS_THRESHOLD;
            }
        }
        return super.createReadThreadingAssembler();
    }

    public double getDefaultAlleleFrequency() {
        return this.afOfAllelesNotInGermlineResource >= 0.0 ? this.afOfAllelesNotInGermlineResource : (this.mitochondria != false ? 0.004 : (this.normalSamples.isEmpty() ? 5.0E-8 : 1.0E-6));
    }

    public double getEmissionLogOdds() {
        if (this.emitReferenceConfidence != ReferenceConfidenceMode.NONE) {
            return MathUtils.log10ToLog(Double.NEGATIVE_INFINITY);
        }
        return MathUtils.log10ToLog(this.mitochondria != false && this.emissionLog10Odds == 3.0 ? 0.0 : this.emissionLog10Odds);
    }

    public double getInitialLogOdds() {
        if (this.emitReferenceConfidence != ReferenceConfidenceMode.NONE) {
            return MathUtils.log10ToLog(Double.NEGATIVE_INFINITY);
        }
        return MathUtils.log10ToLog(this.mitochondria != false && this.initialLog10Odds == 2.0 ? 0.0 : this.initialLog10Odds);
    }
}

