/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.hellbender.cmdline.CommandLineProgram;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.tools.walkers.mutect.MutectStats;
import org.broadinstitute.hellbender.utils.Utils;

@CommandLineProgramProperties(summary="Merge the stats output by scatters of a single Mutect2 job", oneLineSummary="Merge the stats output by scatters of a single Mutect2 job", programGroup=ShortVariantDiscoveryProgramGroup.class)
public class MergeMutectStats
extends CommandLineProgram {
    @Argument(fullName="stats", doc="Stats from Mutect2 scatters of a single tumor or tumor-normal pair")
    private Set<File> stats = new LinkedHashSet<File>(0);
    @Argument(fullName="output", shortName="O", doc="Output stats")
    private File outputStatsTable = null;

    @Override
    public Object doWork() {
        HashMap<String, ToDoubleFunction<List>> aggregations = new HashMap<String, ToDoubleFunction<List>>();
        aggregations.put("callable", list -> list.stream().mapToDouble(x -> x).sum());
        HashMap scatteredStats = new HashMap();
        this.stats.stream().flatMap(file -> MutectStats.readFromFile(file).stream()).forEach(mutectStat -> {
            String key = mutectStat.getStatistic();
            double value = mutectStat.getValue();
            if (!scatteredStats.containsKey(key)) {
                scatteredStats.put(key, new ArrayList());
            }
            ((List)scatteredStats.get(key)).add(value);
        });
        List<MutectStats> aggregatedStats = scatteredStats.entrySet().stream().map(entry -> {
            String stat = (String)entry.getKey();
            List values = (List)entry.getValue();
            Utils.validate(aggregations.containsKey(stat), () -> "aggregations list missing key " + stat);
            double aggregatedValue = ((ToDoubleFunction)aggregations.get(stat)).applyAsDouble(values);
            return new MutectStats(stat, aggregatedValue);
        }).collect(Collectors.toList());
        MutectStats.writeToFile(aggregatedStats, this.outputStatsTable);
        return "SUCCESS";
    }
}

