/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.AssemblyRegionWalker;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.OriginalAlignment;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.tools.walkers.mutect.M2ArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.mutect.Mutect2Engine;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.downsampling.MutectDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.variant.writers.SomaticGVCFWriter;

@CommandLineProgramProperties(summary="Call somatic SNVs and indels via local assembly of haplotypes", oneLineSummary="Call somatic SNVs and indels via local assembly of haplotypes", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
public final class Mutect2
extends AssemblyRegionWalker {
    public static final String MUTECT_STATS_SHORT_NAME = "stats";
    public static final String DEFAULT_STATS_EXTENSION = ".stats";
    @ArgumentCollection
    protected M2ArgumentCollection MTAC = new M2ArgumentCollection();
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written")
    public GATKPath outputVCF;
    private VariantContextWriter vcfWriter;
    private Mutect2Engine m2Engine;

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Mutect2Engine.makeStandardMutect2ReadFilters();
    }

    @Override
    public ReadTransformer makePostReadFilterTransformer() {
        return super.makePostReadFilterTransformer().andThen(Mutect2Engine.makeStandardMutect2PostFilterReadTransformer(this.referenceArguments.getReferencePath(), !this.MTAC.dontClipITRArtifacts));
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return Mutect2Engine.getStandardMutect2AnnotationGroups();
    }

    @Override
    protected ReadsDownsampler createDownsampler() {
        return new MutectDownsampler(this.assemblyRegionArgs.maxReadsPerAlignmentStart, this.MTAC.maxSuspiciousReadsPerAlignmentStart, this.MTAC.downsamplingStride);
    }

    @Override
    public AssemblyRegionEvaluator assemblyRegionEvaluator() {
        return this.m2Engine;
    }

    @Override
    public void onTraversalStart() {
        VariantAnnotatorEngine annotatorEngine = new VariantAnnotatorEngine(this.makeVariantAnnotations(), null, Collections.emptyList(), false, false);
        this.m2Engine = new Mutect2Engine(this.MTAC, this.assemblyRegionArgs, this.createOutputBamIndex, this.createOutputBamMD5, this.getHeaderForReads(), this.referenceArguments.getReferenceSpecifier(), annotatorEngine);
        this.vcfWriter = this.createVCFWriter(this.outputVCF);
        if (this.m2Engine.emitReferenceConfidence()) {
            this.logger.warn("Note that the Mutect2 reference confidence mode is in BETA -- the likelihoods model and output format are subject to change in subsequent versions.");
            if (this.MTAC.emitReferenceConfidence == ReferenceConfidenceMode.GVCF) {
                try {
                    this.vcfWriter = new SomaticGVCFWriter(this.vcfWriter, new ArrayList<Number>(this.MTAC.GVCFGQBands));
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineException.BadArgumentValue("GQBands", "are malformed: " + e.getMessage());
                }
            }
        }
        if (this.MTAC.f1r2TarGz != null && !this.MTAC.f1r2TarGz.getAbsolutePath().endsWith(".tar.gz")) {
            throw new UserException.CouldNotCreateOutputFile(this.MTAC.f1r2TarGz, "f1r2-tar-gz file must end in .tar.gz");
        }
        this.m2Engine.writeHeader(this.vcfWriter, this.getDefaultToolVCFHeaderLines());
    }

    @Override
    public Collection<Annotation> makeVariantAnnotations() {
        Collection<Annotation> annotations = super.makeVariantAnnotations();
        if (this.MTAC.mitochondria.booleanValue()) {
            annotations.add(new OriginalAlignment());
        }
        return annotations;
    }

    @Override
    public Object onTraversalSuccess() {
        this.m2Engine.writeExtraOutputs(new File(this.outputVCF + DEFAULT_STATS_EXTENSION));
        return "SUCCESS";
    }

    @Override
    public void apply(AssemblyRegion region, ReferenceContext referenceContext, FeatureContext featureContext) {
        this.m2Engine.callRegion(region, referenceContext, featureContext).forEach(arg_0 -> ((VariantContextWriter)this.vcfWriter).add(arg_0));
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
        if (this.m2Engine != null) {
            this.m2Engine.shutdown();
        }
    }
}

