/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.AssemblyRegionEvaluator;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.engine.filters.MappingQualityReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.ReadLengthReadFilter;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.engine.spark.AssemblyRegionArgumentCollection;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.HomogeneousPloidyModel;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerUtils;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyRegionTrimmer;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyResultSet;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.CalledHaplotypes;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReadLikelihoodCalculationEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.ReferenceConfidenceMode;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.readthreading.ReadThreadingAssembler;
import org.broadinstitute.hellbender.tools.walkers.mutect.M2ArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.mutect.MutectStats;
import org.broadinstitute.hellbender.tools.walkers.mutect.SomaticGenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.SomaticReferenceConfidenceModel;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.FilterMutectCalls;
import org.broadinstitute.hellbender.tools.walkers.readorientation.BetaDistributionShape;
import org.broadinstitute.hellbender.tools.walkers.readorientation.F1R2CountsCollector;
import org.broadinstitute.hellbender.transformers.PalindromeArtifactClipReadTransformer;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.NaturalLogUtils;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.activityprofile.ActivityProfileState;
import org.broadinstitute.hellbender.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.haplotype.HaplotypeBAMWriter;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.reference.ReferenceUtils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

public final class Mutect2Engine
implements AssemblyRegionEvaluator {
    private static final List<String> STANDARD_MUTECT_INFO_FIELDS = Arrays.asList("NLOD", "TLOD", "NALOD", "ECNT", "PON", "POPAF", "GERMQ", "CONTQ", "SEQQ", "STRQ", "ROQ", "STRANDQ", "OCM", "NCount", "AS_UNIQ_ALT_READ_COUNT");
    private static final String MUTECT_VERSION = "2.2";
    public static final String TUMOR_SAMPLE_KEY_IN_VCF_HEADER = "tumor_sample";
    public static final String NORMAL_SAMPLE_KEY_IN_VCF_HEADER = "normal_sample";
    private static final Logger logger = LogManager.getLogger(Mutect2Engine.class);
    private static final List<VariantContext> NO_CALLS = Collections.emptyList();
    public static final int INDEL_START_QUAL = 30;
    public static final int INDEL_CONTINUATION_QUAL = 10;
    public static final double MAX_ALT_FRACTION_IN_NORMAL = 0.3;
    public static final int MAX_NORMAL_QUAL_SUM = 100;
    public static final int MIN_PALINDROME_SIZE = 5;
    public static final int HUGE_FRAGMENT_LENGTH = 1000000;
    private M2ArgumentCollection MTAC;
    private SAMFileHeader header;
    private final int minCallableDepth;
    public static final String CALLABLE_SITES_NAME = "callable";
    private static final int MIN_READ_LENGTH = 30;
    private static final int READ_QUALITY_FILTER_THRESHOLD = 20;
    public static final int MINIMUM_BASE_QUALITY = 6;
    private final SampleList samplesList;
    private final Set<String> normalSamples;
    private final boolean forceCallingAllelesPresent;
    private CachingIndexedFastaSequenceFile referenceReader;
    private ReadThreadingAssembler assemblyEngine;
    private ReadLikelihoodCalculationEngine likelihoodCalculationEngine;
    private SomaticGenotypingEngine genotypingEngine;
    private Optional<HaplotypeBAMWriter> haplotypeBAMWriter;
    private VariantAnnotatorEngine annotationEngine;
    private final SmithWatermanAligner aligner;
    private final AssemblyRegionTrimmer trimmer;
    private SomaticReferenceConfidenceModel referenceConfidenceModel = null;
    private final MutableLong callableSites = new MutableLong(0L);
    private final Optional<F1R2CountsCollector> f1R2CountsCollector;
    private PileupQualBuffer tumorPileupQualBuffer = new PileupQualBuffer();
    private PileupQualBuffer normalPileupQualBuffer = new PileupQualBuffer();

    public Mutect2Engine(M2ArgumentCollection MTAC, AssemblyRegionArgumentCollection assemblyRegionArgs, boolean createBamOutIndex, boolean createBamOutMD5, SAMFileHeader header, GATKPath referenceSpec, VariantAnnotatorEngine annotatorEngine) {
        this.MTAC = Utils.nonNull(MTAC);
        this.header = Utils.nonNull(header);
        this.minCallableDepth = MTAC.callableDepth;
        this.referenceReader = ReferenceUtils.createReferenceReader(Utils.nonNull(referenceSpec));
        this.aligner = SmithWatermanAligner.getAligner(MTAC.smithWatermanImplementation);
        this.samplesList = new IndexedSampleList(new ArrayList<String>(ReadUtils.getSamplesFromHeader(header)));
        this.normalSamples = MTAC.normalSamples.isEmpty() ? Collections.emptySet() : (MTAC.normalSamples.size() == 1 ? Collections.singleton(this.decodeSampleNameIfNecessary(MTAC.normalSamples.iterator().next())) : MTAC.normalSamples.stream().map(this::decodeSampleNameIfNecessary).collect(Collectors.toSet()));
        this.normalSamples.forEach(this::checkSampleInBamHeader);
        this.forceCallingAllelesPresent = MTAC.alleles != null;
        this.annotationEngine = Utils.nonNull(annotatorEngine);
        this.assemblyEngine = MTAC.createReadThreadingAssembler();
        this.likelihoodCalculationEngine = AssemblyBasedCallerUtils.createLikelihoodCalculationEngine(MTAC.likelihoodArgs, true);
        this.genotypingEngine = new SomaticGenotypingEngine(MTAC, this.normalSamples, this.annotationEngine);
        this.haplotypeBAMWriter = AssemblyBasedCallerUtils.createBamWriter(MTAC, createBamOutIndex, createBamOutMD5, header);
        this.trimmer = new AssemblyRegionTrimmer(assemblyRegionArgs, header.getSequenceDictionary());
        this.referenceConfidenceModel = new SomaticReferenceConfidenceModel(this.samplesList, header, 0, MTAC.minAF);
        List<String> tumorSamples = ReadUtils.getSamplesFromHeader(header).stream().filter(this::isTumorSample).collect(Collectors.toList());
        this.f1R2CountsCollector = MTAC.f1r2TarGz == null ? Optional.empty() : Optional.of(new F1R2CountsCollector(MTAC.f1r2Args, header, MTAC.f1r2TarGz, tumorSamples));
    }

    public static List<ReadFilter> makeStandardMutect2ReadFilters() {
        return Arrays.asList(new MappingQualityReadFilter(20), ReadFilterLibrary.MAPPING_QUALITY_AVAILABLE, ReadFilterLibrary.MAPPING_QUALITY_NOT_ZERO, ReadFilterLibrary.MAPPED, ReadFilterLibrary.NOT_SECONDARY_ALIGNMENT, ReadFilterLibrary.NOT_DUPLICATE, ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK, ReadFilterLibrary.NON_CHIMERIC_ORIGINAL_ALIGNMENT_READ_FILTER, ReadFilterLibrary.NON_ZERO_REFERENCE_LENGTH_ALIGNMENT, new ReadLengthReadFilter(30, Integer.MAX_VALUE), ReadFilterLibrary.GOOD_CIGAR, new WellformedReadFilter());
    }

    public static ReadTransformer makeStandardMutect2PostFilterReadTransformer(Path referencePath, boolean clipITRArtifacts) {
        return !clipITRArtifacts ? ReadTransformer.identity() : new PalindromeArtifactClipReadTransformer(new ReferenceFileSource(referencePath), 5);
    }

    public static List<Class<? extends Annotation>> getStandardMutect2AnnotationGroups() {
        return Collections.singletonList(StandardMutectAnnotation.class);
    }

    public void writeHeader(VariantContextWriter vcfWriter, Set<VCFHeaderLine> defaultToolHeaderLines) {
        HashSet<Object> headerInfo = new HashSet<Object>();
        headerInfo.add(new VCFHeaderLine("MutectVersion", MUTECT_VERSION));
        headerInfo.add(new VCFHeaderLine("filtering_status", "Warning: unfiltered Mutect 2 calls.  Please run " + FilterMutectCalls.class.getSimpleName() + " to remove false positives."));
        headerInfo.addAll(this.annotationEngine.getVCFAnnotationDescriptions(false));
        headerInfo.addAll(defaultToolHeaderLines);
        STANDARD_MUTECT_INFO_FIELDS.stream().map(GATKVCFHeaderLines::getInfoLine).forEach(headerInfo::add);
        VCFStandardHeaderLines.addStandardFormatLines(headerInfo, (boolean)true, (String[])new String[]{"GT", "AD", "GQ", "DP", "PL"});
        headerInfo.add(GATKVCFHeaderLines.getFormatLine("AF"));
        headerInfo.add(GATKVCFHeaderLines.getFormatLine("PID"));
        headerInfo.add(GATKVCFHeaderLines.getFormatLine("PGT"));
        headerInfo.add(VCFStandardHeaderLines.getFormatLine((String)"PS"));
        ReadUtils.getSamplesFromHeader(this.header).stream().filter(this::isTumorSample).forEach(s -> headerInfo.add(new VCFHeaderLine(TUMOR_SAMPLE_KEY_IN_VCF_HEADER, s)));
        this.normalSamples.forEach(sample -> headerInfo.add(new VCFHeaderLine(NORMAL_SAMPLE_KEY_IN_VCF_HEADER, sample)));
        if (this.emitReferenceConfidence()) {
            headerInfo.addAll(this.referenceConfidenceModel.getVCFHeaderLines());
            headerInfo.add(GATKVCFHeaderLines.getFormatLine("TLOD"));
        }
        VCFHeader vcfHeader = new VCFHeader(headerInfo, this.samplesList.asListOfSamples());
        vcfHeader.setSequenceDictionary(this.header.getSequenceDictionary());
        vcfWriter.writeHeader(vcfHeader);
    }

    public List<VariantContext> callRegion(AssemblyRegion originalAssemblyRegion, ReferenceContext referenceContext, FeatureContext featureContext) {
        AssemblyBasedCallerUtils.cleanOverlappingReadPairs(originalAssemblyRegion.getReads(), this.samplesList, this.header, false, OptionalInt.of(this.MTAC.pcrSnvQual / 2), OptionalInt.of(this.MTAC.pcrIndelQual / 2));
        if (!originalAssemblyRegion.isActive() || originalAssemblyRegion.size() == 0) {
            return this.emitReferenceConfidence() ? this.referenceModelForNoVariation(originalAssemblyRegion) : NO_CALLS;
        }
        this.removeUnmarkedDuplicates(originalAssemblyRegion);
        List<VariantContext> givenAlleles = featureContext.getValues(this.MTAC.alleles).stream().filter(vc -> this.MTAC.forceCallFiltered || vc.isNotFiltered()).collect(Collectors.toList());
        AssemblyResultSet untrimmedAssemblyResult = AssemblyBasedCallerUtils.assembleReads(originalAssemblyRegion, givenAlleles, this.MTAC, this.header, this.samplesList, logger, this.referenceReader, this.assemblyEngine, this.aligner, false);
        SortedSet<VariantContext> allVariationEvents = untrimmedAssemblyResult.getVariationEvents(this.MTAC.maxMnpDistance);
        AssemblyRegionTrimmer.Result trimmingResult = this.trimmer.trim(originalAssemblyRegion, allVariationEvents, referenceContext);
        if (!trimmingResult.isVariationPresent()) {
            return this.emitReferenceConfidence() ? this.referenceModelForNoVariation(originalAssemblyRegion) : NO_CALLS;
        }
        AssemblyResultSet assemblyResult = untrimmedAssemblyResult.trimTo(trimmingResult.getVariantRegion());
        if (!assemblyResult.isVariationPresent()) {
            return this.emitReferenceConfidence() ? this.referenceModelForNoVariation(originalAssemblyRegion) : NO_CALLS;
        }
        AssemblyRegion regionForGenotyping = assemblyResult.getRegionForGenotyping();
        this.removeReadStubs(regionForGenotyping);
        Map<String, List<GATKRead>> reads = this.splitReadsBySample(regionForGenotyping.getReads());
        AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods = this.likelihoodCalculationEngine.computeReadLikelihoods(assemblyResult, this.samplesList, reads);
        readLikelihoods.switchToNaturalLog();
        Map<GATKRead, GATKRead> readRealignments = AssemblyBasedCallerUtils.realignReadsToTheirBestHaplotype(readLikelihoods, assemblyResult.getReferenceHaplotype(), assemblyResult.getPaddedReferenceLoc(), this.aligner);
        readLikelihoods.changeEvidence(readRealignments);
        CalledHaplotypes calledHaplotypes = this.genotypingEngine.callMutations(readLikelihoods, assemblyResult, referenceContext, regionForGenotyping.getSpan(), featureContext, givenAlleles, this.header, this.haplotypeBAMWriter.isPresent(), this.emitReferenceConfidence());
        this.writeBamOutput(assemblyResult, readLikelihoods, calledHaplotypes, regionForGenotyping.getSpan());
        if (this.emitReferenceConfidence()) {
            if (!this.containsCalls(calledHaplotypes)) {
                return this.referenceModelForNoVariation(originalAssemblyRegion);
            }
            LinkedList<VariantContext> result = new LinkedList<VariantContext>();
            trimmingResult.nonVariantLeftFlankRegion().ifPresent(flank -> result.addAll(this.referenceModelForNoVariation((AssemblyRegion)flank)));
            result.addAll(this.referenceConfidenceModel.calculateRefConfidence(assemblyResult.getReferenceHaplotype(), calledHaplotypes.getCalledHaplotypes(), assemblyResult.getPaddedReferenceLoc(), regionForGenotyping, readLikelihoods, new HomogeneousPloidyModel(this.samplesList, 2), calledHaplotypes.getCalls()));
            trimmingResult.nonVariantRightFlankRegion().ifPresent(flank -> result.addAll(this.referenceModelForNoVariation((AssemblyRegion)flank)));
            return result;
        }
        return calledHaplotypes.getCalls();
    }

    private void removeReadStubs(AssemblyRegion assemblyRegion) {
        List<GATKRead> readStubs = assemblyRegion.getReads().stream().filter(r -> r.getLength() < 10).collect(Collectors.toList());
        assemblyRegion.removeAll(readStubs);
    }

    private void removeUnmarkedDuplicates(AssemblyRegion assemblyRegion) {
        Map<ImmutablePair, List<GATKRead>> possibleDuplicates = assemblyRegion.getReads().stream().filter(read -> read.isPaired() && !read.mateIsUnmapped() && (!read.getMateContig().equals(read.getContig()) || Math.abs(read.getFragmentLength()) > 1000000)).collect(Collectors.groupingBy(read -> ImmutablePair.of((Object)ReadUtils.getSampleName(read, this.header), (Object)((read.isFirstOfPair() ? 1 : -1) * read.getUnclippedStart()))));
        List<GATKRead> duplicates = possibleDuplicates.values().stream().flatMap(list -> {
            Map<String, List<GATKRead>> readsByContig = list.stream().collect(Collectors.groupingBy(GATKRead::getMateContig));
            return readsByContig.values().stream().flatMap(contigReads -> contigReads.stream().skip(contigReads.size() > list.size() / 2 ? 1L : 0L));
        }).collect(Collectors.toList());
        assemblyRegion.removeAll(duplicates);
    }

    private boolean containsCalls(CalledHaplotypes calledHaplotypes) {
        return calledHaplotypes.getCalls().stream().flatMap(call -> call.getGenotypes().stream()).anyMatch(Genotype::isCalled);
    }

    private void writeBamOutput(AssemblyResultSet assemblyResult, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods, CalledHaplotypes calledHaplotypes, Locatable callableRegion) {
        if (this.haplotypeBAMWriter.isPresent()) {
            HashSet<Haplotype> calledHaplotypeSet = new HashSet<Haplotype>(calledHaplotypes.getCalledHaplotypes());
            this.haplotypeBAMWriter.get().writeReadsAlignedToHaplotypes(assemblyResult.getHaplotypeList(), assemblyResult.getPaddedReferenceLoc(), assemblyResult.getHaplotypeList(), calledHaplotypeSet, readLikelihoods, callableRegion);
        }
    }

    private boolean hasNormal() {
        return !this.normalSamples.isEmpty();
    }

    private boolean isNormalSample(String sample) {
        return this.normalSamples.contains(sample);
    }

    private boolean isTumorSample(String sample) {
        return !this.isNormalSample(sample);
    }

    protected Map<String, List<GATKRead>> splitReadsBySample(Collection<GATKRead> reads) {
        return AssemblyBasedCallerUtils.splitReadsBySample(this.samplesList, this.header, reads);
    }

    public void writeExtraOutputs(File statsTable) {
        List<MutectStats> stats = Arrays.asList(new MutectStats(CALLABLE_SITES_NAME, this.callableSites.getValue().longValue()));
        MutectStats.writeToFile(stats, statsTable);
        this.f1R2CountsCollector.ifPresent(collector -> {
            collector.writeHistograms();
            collector.closeAndArchiveFiles();
        });
    }

    public void shutdown() {
        this.likelihoodCalculationEngine.close();
        this.aligner.close();
        this.haplotypeBAMWriter.ifPresent(writer -> writer.close());
        this.referenceReader.close();
    }

    @Override
    public ActivityProfileState isActive(AlignmentContext context, ReferenceContext ref, FeatureContext features) {
        VariantContext germlineVariant;
        List<Double> germlineAlleleFrequencies;
        List<VariantContext> germline;
        if (this.forceCallingAllelesPresent && features.getValues(this.MTAC.alleles, ref).stream().anyMatch(vc -> this.MTAC.forceCallFiltered || vc.isNotFiltered())) {
            return new ActivityProfileState(ref.getInterval(), 1.0);
        }
        byte refBase = ref.getBase();
        SimpleInterval refInterval = ref.getInterval();
        if (context == null || context.getBasePileup().isEmpty()) {
            return new ActivityProfileState(refInterval, 0.0);
        }
        ReadPileup pileup = context.getBasePileup();
        if (pileup.size() >= this.minCallableDepth) {
            this.callableSites.increment();
        }
        ReadPileup tumorPileup = pileup.makeFilteredPileup(pe -> this.isTumorSample(ReadUtils.getSampleName(pe.getRead(), this.header)));
        this.f1R2CountsCollector.ifPresent(collector -> collector.process(tumorPileup, ref));
        this.tumorPileupQualBuffer.accumulateQuals(tumorPileup, refBase, this.MTAC.pcrSnvQual);
        Pair<Integer, ByteArrayList> bestTumorAltAllele = this.tumorPileupQualBuffer.likeliestIndexAndQuals();
        double tumorLogOdds = Mutect2Engine.logLikelihoodRatio(tumorPileup.size() - ((ByteArrayList)bestTumorAltAllele.getRight()).size(), (List)bestTumorAltAllele.getRight());
        if (tumorLogOdds < this.MTAC.getInitialLogOdds()) {
            return new ActivityProfileState(refInterval, 0.0);
        }
        if (this.hasNormal() && !this.MTAC.genotypeGermlineSites) {
            ReadPileup normalPileup = pileup.makeFilteredPileup(pe -> this.isNormalSample(ReadUtils.getSampleName(pe.getRead(), this.header)));
            this.normalPileupQualBuffer.accumulateQuals(normalPileup, refBase, this.MTAC.pcrSnvQual);
            Pair<Integer, ByteArrayList> bestNormalAltAllele = this.normalPileupQualBuffer.likeliestIndexAndQuals();
            if (bestNormalAltAllele.getLeft() == bestTumorAltAllele.getLeft()) {
                int normalAltCount = ((ByteArrayList)bestNormalAltAllele.getRight()).size();
                double normalQualSum = this.normalPileupQualBuffer.qualSum((Integer)bestNormalAltAllele.getLeft());
                if ((double)normalAltCount > (double)normalPileup.size() * 0.3 && normalQualSum > 100.0) {
                    return new ActivityProfileState(refInterval, 0.0);
                }
            }
        } else if (!this.MTAC.genotypeGermlineSites && !(germline = features.getValues(this.MTAC.germlineResource, refInterval)).isEmpty() && !(germlineAlleleFrequencies = Mutect2Engine.getAttributeAsDoubleList(germlineVariant = germline.get(0), "AF", 0.0)).isEmpty() && germlineAlleleFrequencies.get(0) > this.MTAC.maxPopulationAlleleFrequency) {
            return new ActivityProfileState(refInterval, 0.0);
        }
        if (!this.MTAC.genotypePonSites && !features.getValues(this.MTAC.pon, new SimpleInterval(context.getContig(), (int)context.getPosition(), (int)context.getPosition())).isEmpty()) {
            return new ActivityProfileState(refInterval, 0.0);
        }
        if (pileup.size() < this.minCallableDepth) {
            this.callableSites.increment();
        }
        return new ActivityProfileState(refInterval, 1.0, ActivityProfileState.Type.NONE, null);
    }

    public static List<Double> getAttributeAsDoubleList(VariantContext vc, String key, double defaultValue) {
        return vc.getCommonInfo().getAttributeAsList(key).stream().map(x -> {
            if (x == null) {
                return defaultValue;
            }
            if (x instanceof Number) {
                return ((Number)x).doubleValue();
            }
            String string = (String)x;
            return string.equals(".") ? defaultValue : Double.valueOf(string);
        }).collect(Collectors.toList());
    }

    public boolean emitReferenceConfidence() {
        return this.MTAC.emitReferenceConfidence != ReferenceConfidenceMode.NONE;
    }

    private List<VariantContext> referenceModelForNoVariation(AssemblyRegion region) {
        AssemblyBasedCallerUtils.finalizeRegion(region, false, true, (byte)9, this.header, this.samplesList, false, false);
        SimpleInterval paddedLoc = region.getPaddedSpan();
        Haplotype refHaplotype = AssemblyBasedCallerUtils.createReferenceHaplotype(region, paddedLoc, this.referenceReader);
        List<Haplotype> haplotypes = Collections.singletonList(refHaplotype);
        return this.referenceConfidenceModel.calculateRefConfidence(refHaplotype, haplotypes, paddedLoc, region, AssemblyBasedCallerUtils.createDummyStratifiedReadMap(refHaplotype, this.samplesList, this.header, region), new HomogeneousPloidyModel(this.samplesList, 2), Collections.emptyList(), false, Collections.emptyList());
    }

    private static int getCurrentOrFollowingIndelLength(PileupElement pe) {
        return pe.isDeletion() ? pe.getCurrentCigarElement().getLength() : pe.getLengthOfImmediatelyFollowingIndel();
    }

    private static byte indelQual(int indelLength) {
        return (byte)Math.min(30 + (indelLength - 1) * 10, 127);
    }

    public static double logLikelihoodRatio(int refCount, List<Byte> altQuals) {
        return Mutect2Engine.logLikelihoodRatio(refCount, altQuals, 1);
    }

    public static double logLikelihoodRatio(int nRef, List<Byte> altQuals, int repeatFactor, Optional<BetaDistributionShape> afPrior) {
        double betaEntropy;
        int nAlt = repeatFactor * altQuals.size();
        int n = nRef + nAlt;
        double fTildeRatio = FastMath.exp((double)(MathUtils.digamma(nRef + 1) - MathUtils.digamma(nAlt + 1)));
        double readSum = 0.0;
        for (byte qual : altQuals) {
            double epsilon = QualityUtils.qualToErrorProb(qual);
            double zBarAlt = (1.0 - epsilon) / (1.0 - epsilon + epsilon * fTildeRatio);
            double logEpsilon = NaturalLogUtils.qualToLogErrorProb(qual);
            double logOneMinusEpsilon = NaturalLogUtils.qualToLogProb(qual);
            readSum += zBarAlt * (logOneMinusEpsilon - logEpsilon) + MathUtils.fastBernoulliEntropy(zBarAlt);
        }
        if (afPrior.isPresent()) {
            double alpha = afPrior.get().getAlpha();
            double beta = afPrior.get().getBeta();
            betaEntropy = Gamma.logGamma((double)(alpha + beta)) - Gamma.logGamma((double)alpha) - Gamma.logGamma((double)beta) - Gamma.logGamma((double)(alpha + beta + (double)n)) + Gamma.logGamma((double)(alpha + (double)nAlt)) + Gamma.logGamma((double)(beta + (double)nRef));
        } else {
            betaEntropy = MathUtils.log10ToLog(-MathUtils.log10Factorial(n + 1) + MathUtils.log10Factorial(nAlt) + MathUtils.log10Factorial(nRef));
        }
        return betaEntropy + readSum * (double)repeatFactor;
    }

    public static double logLikelihoodRatio(int nRef, List<Byte> altQuals, int repeatFactor) {
        return Mutect2Engine.logLikelihoodRatio(nRef, altQuals, repeatFactor, Optional.empty());
    }

    public static double logLikelihoodRatio(int refCount, int altCount, double errorProbability) {
        byte qual = QualityUtils.errorProbToQual(errorProbability);
        return Mutect2Engine.logLikelihoodRatio(refCount, Collections.singletonList(qual), altCount);
    }

    private static boolean isNextToUsefulSoftClip(PileupElement pe) {
        int offset = pe.getOffset();
        return pe.getQual() > 6 && (pe.isBeforeSoftClip() && pe.getRead().getBaseQuality(offset + 1) > 6 || pe.isAfterSoftClip() && pe.getRead().getBaseQuality(offset - 1) > 6);
    }

    private void checkSampleInBamHeader(String sample) {
        if (sample != null && !this.samplesList.asListOfSamples().contains(sample)) {
            throw new UserException.BadInput("Sample " + sample + " is not in BAM header: " + this.samplesList.asListOfSamples());
        }
    }

    private String decodeSampleNameIfNecessary(String name) {
        return this.samplesList.asListOfSamples().contains(name) ? name : IOUtils.urlDecode(name);
    }

    private static class PileupQualBuffer {
        private static final int OTHER_SUBSTITUTION = 4;
        private static final int INDEL = 5;
        private static final int ONE_THIRD_QUAL_CORRECTION = 5;
        private List<ByteArrayList> buffers = IntStream.range(0, 6).mapToObj(n -> new ByteArrayList()).collect(Collectors.toList());

        public void accumulateQuals(ReadPileup pileup, byte refBase, int pcrErrorQual) {
            this.clear();
            int position = pileup.getLocation().getStart();
            for (PileupElement pe : pileup) {
                int indelLength = Mutect2Engine.getCurrentOrFollowingIndelLength(pe);
                if (indelLength > 0) {
                    this.accumulateIndel(Mutect2Engine.indelQual(indelLength));
                    continue;
                }
                if (Mutect2Engine.isNextToUsefulSoftClip(pe)) {
                    this.accumulateIndel(Mutect2Engine.indelQual(1));
                    continue;
                }
                if (pe.getBase() == refBase || pe.getQual() <= 6) continue;
                GATKRead read = pe.getRead();
                int mateStart = !read.isProperlyPaired() || read.mateIsUnmapped() ? Integer.MAX_VALUE : read.getMateStart();
                boolean overlapsMate = mateStart <= position && position < mateStart + read.getLength();
                this.accumulateSubstitution(pe.getBase(), overlapsMate ? (byte)FastMath.min((int)pe.getQual(), (int)(pcrErrorQual / 2)) : pe.getQual());
            }
        }

        public Pair<Integer, ByteArrayList> likeliestIndexAndQuals() {
            int bestIndex = 0;
            long bestSum = 0L;
            for (int n = 0; n < this.buffers.size(); ++n) {
                long sum = this.qualSum(n);
                if (sum <= bestSum) continue;
                bestSum = sum;
                bestIndex = n;
            }
            return ImmutablePair.of((Object)bestIndex, (Object)this.buffers.get(bestIndex));
        }

        private void accumulateSubstitution(byte base, byte qual) {
            int index = BaseUtils.simpleBaseToBaseIndex(base);
            if (index == -1) {
                this.buffers.get(4).add(qual);
            } else {
                this.buffers.get(index).add((byte)FastMath.min((int)(qual + 5), (int)254));
            }
        }

        private void accumulateIndel(byte qual) {
            this.buffers.get(5).add(qual);
        }

        private void clear() {
            this.buffers.forEach(ByteArrayList::clear);
        }

        public long qualSum(int index) {
            ByteArrayList list = this.buffers.get(index);
            long result = 0L;
            for (int n = 0; n < list.size(); ++n) {
                result += (long)list.getByte(n);
            }
            return result;
        }
    }
}

