/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.mutect;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public class MutectStats {
    private String statistic;
    private double value;

    public MutectStats(String statistic, double value) {
        this.statistic = statistic;
        this.value = value;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public double getValue() {
        return this.value;
    }

    public static void writeToFile(List<MutectStats> records, File outputTable) {
        try (MutectStatsWriter writer = new MutectStatsWriter(IOUtils.fileToPath(outputTable));){
            writer.writeAllRecords(records);
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while writing to %s.", outputTable));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<MutectStats> readFromFile(File tableFile) {
        try (MutectStatsReader reader = new MutectStatsReader(IOUtils.fileToPath(tableFile));){
            List<MutectStats> list = reader.toList();
            return list;
        }
        catch (IOException e) {
            throw new UserException(String.format("Encountered an IO exception while reading from %s.", tableFile));
        }
    }

    private static enum MutectStatsColumn {
        STATISTIC("statistic"),
        VALUE("value");

        private final String columnName;
        public static final TableColumnCollection COLUMNS;

        private MutectStatsColumn(String columnName) {
            this.columnName = Utils.nonNull(columnName);
        }

        public String toString() {
            return this.columnName;
        }

        static {
            COLUMNS = new TableColumnCollection(new Object[]{STATISTIC, VALUE});
        }
    }

    private static class MutectStatsReader
    extends TableReader<MutectStats> {
        public MutectStatsReader(Path file) throws IOException {
            super(file);
        }

        @Override
        protected MutectStats createRecord(DataLine dataLine) {
            String sample = dataLine.get(MutectStatsColumn.STATISTIC);
            double contamination = dataLine.getDouble(MutectStatsColumn.VALUE);
            return new MutectStats(sample, contamination);
        }
    }

    private static class MutectStatsWriter
    extends TableWriter<MutectStats> {
        private MutectStatsWriter(Path output) throws IOException {
            super(output, MutectStatsColumn.COLUMNS);
        }

        @Override
        protected void composeLine(MutectStats record, DataLine dataLine) {
            dataLine.set(MutectStatsColumn.STATISTIC.toString(), record.getStatistic()).set(MutectStatsColumn.VALUE.toString(), record.getValue());
        }
    }
}

